/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.structurepiececounter;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.craisinlord.integrated_api.misc.structurepiececounter.StructurePieceCountsObj;
import com.craisinlord.integrated_api.modinit.IAConditionsRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<class_2960, List<StructurePieceCountsObj>> StructureToPieceCountsObjs = new HashMap<class_2960, List<StructurePieceCountsObj>>();
    private final Map<class_2960, Map<class_2960, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<class_2960, Map<class_2960, RequiredPieceNeeds>>();
    private final Map<class_2960, Map<class_2960, Integer>> cachedMaxCountPiecesMap = new HashMap<class_2960, Map<class_2960, Integer>>();

    public StructurePieceCountsManager() {
        super(GSON, "integrated_pieces_spawn_counts");
    }

    @class_6328
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(class_2960 fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("integrated_pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            Supplier<Boolean> supplier;
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany != null && entry.neverSpawnMoreThanThisMany != null && entry.alwaysSpawnThisMany > entry.neverSpawnMoreThanThisMany) {
                throw new Exception("Integrated API Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
            }
            if (entry.condition == null || (supplier = IAConditionsRegistry.IA_JSON_CONDITIONS_REGISTRY.lookup().get(new class_2960(entry.condition))) == null || supplier.get().booleanValue()) continue;
            piecesSpawnCounts.remove(entry);
        }
        return piecesSpawnCounts;
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, List<StructurePieceCountsObj>> mapBuilder = new HashMap<class_2960, List<StructurePieceCountsObj>>();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                mapBuilder.put((class_2960)fileIdentifier, this.getStructurePieceCountsObjs((class_2960)fileIdentifier, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                IntegratedAPI.LOGGER.error("Integrated API Error: Couldn't parse integrated_pieces_spawn_counts file {} - JSON looks like: {}", fileIdentifier, jsonElement, (Object)e);
            }
        });
        this.StructureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(manager);
    }

    public void parseAndAddCountsJSONObj(class_2960 structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.StructureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                IntegratedAPI.LOGGER.error("Integrated API Error: Couldn't parse integrated_pieces_spawn_counts file {} - JSON looks like: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<class_2960, RequiredPieceNeeds> getRequirePieces(class_2960 structureRL) {
        if (!this.StructureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<class_2960, RequiredPieceNeeds> requirePiecesMap = new HashMap<class_2960, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.alwaysSpawnThisMany != null) {
                    requirePiecesMap.put(new class_2960(entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
                }
            });
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @class_6328
    public Map<class_2960, Integer> getMaximumCountForPieces(class_2960 structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<class_2960, Integer> maxCountPiecesMap = new HashMap<class_2960, Integer>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.neverSpawnMoreThanThisMany != null) {
                    maxCountPiecesMap.put(new class_2960(entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
                }
            });
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

