/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public final class ShapeMerger {
    private static final Long2ObjectMap<class_2350> BY_NORMAL = (Long2ObjectMap)Arrays.stream(class_2350.values()).collect(Collectors.toMap(dir -> new class_2338(dir.method_10163()).method_10063(), dir -> dir, (dir, dir2) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));
    private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
    private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
    private class_243 lastCenterPoint = null;
    private class_238 currentBox;
    private final Map<class_243, class_238> boxAssignments = Maps.newHashMap();
    private final Multimap<class_238, class_243> mergerAssignments = HashMultimap.create();

    public double getRegionBuildingAxisValue() {
        return this.regionBuildingAxis;
    }

    public void setRegionBuildingAxisValue(double regionBuildingAxis) {
        this.regionBuildingAxis = regionBuildingAxis;
    }

    public double getFaceBuildingAxisValue() {
        return this.faceBuildingAxis;
    }

    public void setFaceBuildingAxisValue(double faceBuildingAxis) {
        this.faceBuildingAxis = faceBuildingAxis;
    }

    public class_238 getCurrentBox() {
        return this.currentBox;
    }

    public void setCurrentBox(class_238 currentBox, class_243 centerPoint) {
        this.currentBox = currentBox;
        if (currentBox != null) {
            this.boxAssignments.put(centerPoint, currentBox);
            this.mergerAssignments.put((Object)currentBox, (Object)centerPoint);
        }
    }

    public Optional<class_238> getBoxFor(class_243 target) {
        return Optional.ofNullable(this.boxAssignments.get(target));
    }

    public Optional<class_243> getLastCenter() {
        return Optional.ofNullable(this.lastCenterPoint);
    }

    public void onNextEntry(class_243 lastCenterPoint) {
        this.lastCenterPoint = lastCenterPoint;
    }

    public void expandCurrentBoxTowards(class_238 target, class_243 center) {
        class_238 current = this.getCurrentBox();
        if (current == null) {
            throw new IllegalStateException("Can not expand current box, if current is not set.");
        }
        class_238 expanded = current.method_991(target);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((class_243)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(center, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)center);
        this.currentBox = expanded;
    }

    public Collection<class_238> getBoxes() {
        return this.mergerAssignments.keySet();
    }

    public void expandBoxAt(class_243 neighborCenter, class_238 entryData, class_243 centerPoint) {
        class_238 current = this.boxAssignments.get(neighborCenter);
        if (current == null) {
            throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
        }
        class_238 expanded = current.method_991(entryData);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((class_243)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(centerPoint, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)centerPoint);
    }

    public boolean mergeNeighbors(class_243 centerPoint, class_238 aabb) {
        for (class_2350 offsetDirection : class_2350.values()) {
            class_238 neighborBox;
            class_243 neighborCenter = centerPoint.method_1019(class_243.method_24954((class_2382)offsetDirection.method_10163()));
            Optional<class_238> potentialNeighborBox = this.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !ShapeMerger.areBoxesNeighbors(aabb, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            this.expandBoxAt(neighborCenter, aabb, centerPoint);
            return true;
        }
        return false;
    }

    public static boolean areBoxesNeighbors(class_238 l, class_238 r, class_2350 direction) {
        double startOfR;
        double endOfL = ShapeMerger.getDirectionalValue(l, direction);
        if (endOfL != (startOfR = ShapeMerger.getDirectionalValue(r, direction.method_10153()))) {
            return false;
        }
        for (class_2350 d : class_2350.values()) {
            if (d.method_10166() == direction.method_10166() || ShapeMerger.getDirectionalValue(l, d) == ShapeMerger.getDirectionalValue(r, d)) continue;
            return false;
        }
        return true;
    }

    public static double getDirectionalValue(class_238 bb, class_2350 direction) {
        return direction.method_10171() == class_2350.class_2352.field_11056 ? bb.method_990(direction.method_10166()) : bb.method_1001(direction.method_10166());
    }

    public static Collection<class_238> merge(Collection<class_2338> positions, class_2338 origin) {
        ShapeMerger merger = new ShapeMerger();
        positions.stream().map(pos -> pos.method_10059((class_2382)origin)).sorted().map(class_238::new).forEachOrdered(aabb -> {
            if (merger.getRegionBuildingAxisValue() != aabb.field_1323) {
                merger.setCurrentBox(null, null);
            }
            merger.setRegionBuildingAxisValue(aabb.field_1323);
            if (merger.getFaceBuildingAxisValue() != aabb.field_1322) {
                merger.setCurrentBox(null, null);
            }
            merger.setFaceBuildingAxisValue(aabb.field_1322);
            Optional<class_243> previousCenterPoint = merger.getLastCenter();
            class_243 centerPoint = aabb.method_1005();
            merger.onNextEntry(centerPoint);
            Optional<class_2350> moveNext = previousCenterPoint.map(v -> {
                class_243 w = centerPoint.method_1020(v);
                class_2338 onPos = class_2338.method_49638((class_2374)w);
                return ShapeMerger.dirFromNormal(onPos.method_10263(), onPos.method_10264(), onPos.method_10260());
            });
            if (merger.getCurrentBox() != null && moveNext.map(dir -> ShapeMerger.areBoxesNeighbors(merger.getCurrentBox(), aabb, dir)).orElse(false).booleanValue()) {
                merger.expandCurrentBoxTowards((class_238)aabb, centerPoint);
                if (merger.mergeNeighbors(centerPoint, merger.getCurrentBox())) {
                    return;
                }
                return;
            }
            if (merger.mergeNeighbors(centerPoint, (class_238)aabb)) {
                return;
            }
            merger.setCurrentBox((class_238)aabb, centerPoint);
        });
        return merger.getBoxes();
    }

    private static class_2350 dirFromNormal(int pX, int pY, int pZ) {
        return (class_2350)BY_NORMAL.get(class_2338.method_10064((int)pX, (int)pY, (int)pZ));
    }
}

