/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.EntityDistanceComparator;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class ShapelessShape
implements Shape {
    private static final List<class_2338> NEIGHBOR_POSITIONS;
    private static final List<class_2338> NEIGHBOR_POSITIONS_PLANT;

    @Override
    public String getName() {
        return "shapeless";
    }

    @Override
    public BlockMatcher getTagMatcher() {
        return BlockMatcher.TAGS_MATCH_SHAPELESS;
    }

    @Override
    public List<class_2338> getBlocks(ShapeContext context) {
        HashSet<class_2338> known = new HashSet<class_2338>();
        this.walk(context, known, context.matcher() == BlockMatcher.CROP_LIKE);
        ArrayList<class_2338> list = new ArrayList<class_2338>(known);
        list.sort(new EntityDistanceComparator(context.pos()));
        if (list.size() > context.maxBlocks()) {
            list.subList(context.maxBlocks(), list.size()).clear();
        }
        return list;
    }

    private void walk(ShapeContext context, HashSet<class_2338> known, boolean cropLike) {
        HashSet<class_2338> traversed = new HashSet<class_2338>();
        ArrayDeque<class_2338> openSet = new ArrayDeque<class_2338>();
        openSet.add(context.pos());
        traversed.add(context.pos());
        while (!openSet.isEmpty()) {
            class_2338 ptr = (class_2338)openSet.pop();
            if (!context.check(ptr) || !known.add(ptr)) continue;
            if (known.size() >= context.maxBlocks()) {
                return;
            }
            for (class_2338 side : cropLike ? NEIGHBOR_POSITIONS_PLANT : NEIGHBOR_POSITIONS) {
                class_2338 offset = ptr.method_10081((class_2382)side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    static {
        int x;
        NEIGHBOR_POSITIONS = new ArrayList<class_2338>(26);
        NEIGHBOR_POSITIONS_PLANT = new ArrayList<class_2338>(26);
        for (x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    NEIGHBOR_POSITIONS.add(new class_2338(x, y, z));
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                NEIGHBOR_POSITIONS_PLANT.add(new class_2338(x, 0, z));
            }
        }
        NEIGHBOR_POSITIONS_PLANT.add(new class_2338(0, 1, 0));
        NEIGHBOR_POSITIONS_PLANT.add(new class_2338(0, -1, 0));
    }
}

