/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import com.google.common.collect.BiMap;
import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.mixin.AxeItemAccess;
import dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3830;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_5955;

public class RightClickHandlers {
    static int axeStripping(class_3222 player, class_1268 hand, class_2338 clickPos, FTBUltiminePlayerData data) {
        HashSet<class_3414> sounds = new HashSet<class_3414>();
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        class_1937 level = player.method_37908();
        class_1799 itemStack = player.method_5998(hand);
        AxeItemAccess axeItemAccess = (AxeItemAccess)itemStack.method_7909();
        for (class_2338 pos : data.cachedPositions()) {
            class_2680 state = player.method_37908().method_8320(pos);
            Optional<class_2680> stripping = axeItemAccess.invokeGetStripped(state);
            Optional scraping = class_5955.method_34735((class_2680)state);
            Optional<class_2680> waxing = Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)state.method_26204())).map(block -> block.method_34725(state));
            Optional<Object> actual = Optional.empty();
            if (stripping.isPresent()) {
                sounds.add(class_3417.field_14675);
                actual = stripping;
            } else if (scraping.isPresent()) {
                sounds.add(class_3417.field_29541);
                level.method_8444((class_1657)player, 3005, pos, 0);
                actual = scraping;
            } else if (waxing.isPresent()) {
                sounds.add(class_3417.field_29542);
                level.method_8444((class_1657)player, 3004, pos, 0);
                actual = waxing;
            }
            if (!actual.isPresent()) continue;
            class_174.field_24478.method_23889(player, pos, itemStack);
            level.method_8652(pos, (class_2680)actual.get(), 11);
            level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)((class_2680)actual.get())));
            itemStack.method_7956(1, (class_1309)player, (Consumer)brokenItemHandler);
            if (!brokenItemHandler.isBroken) continue;
            break;
        }
        sounds.forEach(sound -> level.method_8396(null, clickPos, sound, class_3419.field_15245, 1.0f, 1.0f));
        return sounds.size();
    }

    static int shovelFlattening(class_3222 player, class_1268 hand, class_2338 clickPos, FTBUltiminePlayerData data) {
        int didWork = 0;
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        for (class_2338 pos : data.cachedPositions()) {
            if (!player.method_37908().method_8320(pos.method_10084()).method_26215()) continue;
            class_2680 state = player.method_37908().method_8320(pos);
            class_2680 newState = ShovelItemAccess.getFlattenables().get(state.method_26204());
            if (newState == null && state.method_26164(FTBUltimine.FLATTENABLE_TAG)) {
                newState = class_2246.field_10194.method_9564();
            }
            if (newState == null) continue;
            player.method_37908().method_8652(pos, newState, 11);
            ++didWork;
            player.method_6047().method_7956(1, (class_1309)player, (Consumer)brokenItemHandler);
            player.method_37908().method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)newState));
            if (!brokenItemHandler.isBroken && player.method_7344().method_7586() > 0) continue;
            break;
        }
        if (didWork > 0) {
            player.method_37908().method_8396((class_1657)player, clickPos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
        }
        return didWork;
    }

    static int farmlandConversion(class_3222 player, class_1268 hand, class_2338 clickPos, FTBUltiminePlayerData data) {
        int clicked = 0;
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        for (class_2338 pos : data.cachedPositions()) {
            class_2680 state;
            if (!player.method_37908().method_8320(pos.method_10084()).method_26215() || !(state = player.method_37908().method_8320(pos)).method_26164(FTBUltimine.TILLABLE_TAG)) continue;
            player.method_37908().method_8652(pos, class_2246.field_10362.method_9564(), 11);
            player.method_37908().method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)class_2246.field_10362.method_9564()));
            ++clicked;
            if (player.method_7337()) continue;
            player.method_7322((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
            player.method_6047().method_7956(1, (class_1309)player, (Consumer)brokenItemHandler);
            if (!brokenItemHandler.isBroken && !FTBUltimine.isTooExhausted(player)) continue;
            break;
        }
        if (clicked > 0) {
            player.method_37908().method_8396((class_1657)player, clickPos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
        }
        return clicked;
    }

    static int cropHarvesting(class_3222 player, class_1268 hand, class_2338 clickPos, class_2350 face, FTBUltiminePlayerData data) {
        int clicked = 0;
        ItemCollection itemCollection = new ItemCollection();
        for (class_2338 pos : data.cachedPositions()) {
            class_2680 state = player.method_37908().method_8320(pos);
            if (!RightClickHandlers.isHarvestable(state)) continue;
            class_2586 blockEntity = state.method_31709() ? player.method_37908().method_8321(pos) : null;
            List drops = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)player.method_37908()), (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)class_1799.field_8037);
            for (class_1799 stack : drops) {
                if (class_2248.method_9503((class_1792)stack.method_7909()) == state.method_26204() && RightClickHandlers.consumesItemToReplant(state)) {
                    stack.method_7934(1);
                }
                itemCollection.add(stack);
            }
            RightClickHandlers.resetAge(player.method_37908(), pos, state);
            ++clicked;
        }
        itemCollection.drop(player.method_37908(), face == null ? clickPos : clickPos.method_10093(face));
        return clicked;
    }

    private static boolean consumesItemToReplant(class_2680 state) {
        return state.method_26204() != class_2246.field_16999;
    }

    private static boolean isHarvestable(class_2680 state) {
        class_2302 cropBlock;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof class_2302 && (cropBlock = (class_2302)class_22482).method_9825(state) || state.method_26204() instanceof class_3830 && (Integer)state.method_11654((class_2769)class_3830.field_17000) >= 3 || state.method_26204() instanceof class_2282 && (Integer)state.method_11654((class_2769)class_2282.field_10779) >= 2;
    }

    private static void resetAge(class_1937 level, class_2338 pos, class_2680 currentState) {
        class_2248 class_22482 = currentState.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            level.method_8652(pos, cropBlock.method_9828(0), 3);
        } else if (currentState.method_26204() instanceof class_3830) {
            level.method_8652(pos, (class_2680)currentState.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(1)), 3);
        } else if (currentState.method_26204() instanceof class_2282) {
            level.method_8652(pos, (class_2680)currentState.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

