/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimineCommands;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.RightClickHandlers;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineCommonConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBRanksIntegration;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugins;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.LargeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1831;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3965;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    public static boolean ranksMod;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final class_6862<class_1792> DENY_TAG;
    public static final class_6862<class_1792> STRICT_DENY_TAG;
    public static final class_6862<class_1792> ALLOW_TAG;
    public static final class_6862<class_2248> EXCLUDED_BLOCKS;
    public static final class_6862<class_2248> BLOCK_WHITELIST;
    public static final class_6862<class_2248> TILLABLE_TAG;
    public static final class_6862<class_2248> FLATTENABLE_TAG;
    private static Predicate<class_1657> permissionOverride;

    public static void setPermissionOverride(Predicate<class_1657> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        if (Platform.isModLoaded((String)"ftbranks")) {
            ranksMod = true;
            FTBRanksIntegration.init();
        }
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltimineCommonConfig.load();
        FTBUltiminePlugins.init();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new DataReloadListener());
        ShapeRegistry.register(new ShapelessShape(), true);
        ShapeRegistry.register(new SmallTunnelShape());
        ShapeRegistry.register(new SmallSquareShape());
        ShapeRegistry.register(new LargeTunnelShape());
        ShapeRegistry.register(new MiningTunnelShape());
        ShapeRegistry.register(new EscapeTunnelShape());
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
        CommandRegistrationEvent.EVENT.register(FTBUltimineCommands::registerCommands);
    }

    @NotNull
    public FTBUltiminePlayerData getOrCreatePlayerData(class_1657 player) {
        return this.cachedDataMap.computeIfAbsent(player.method_5667(), FTBUltiminePlayerData::new);
    }

    private void playerJoined(class_3222 serverPlayer) {
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBUltimineServerConfig.CONFIG.write(config);
        new SyncConfigFromServerPacket(config).sendTo(serverPlayer);
        new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(serverPlayer), SyncUltimineTimePacket.TimeType.COOLDOWN).sendTo(serverPlayer);
    }

    private void serverStarting(MinecraftServer server) {
        ShapeRegistry.freeze();
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        FTBUltimineServerConfig.load(server);
    }

    public void setKeyPressed(class_3222 player, boolean pressed) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((class_1657)player);
        data.setPressed(pressed);
        data.clearCache();
        if (!data.isPressed()) {
            new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
        }
    }

    public void modeChanged(class_3222 player, boolean next) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((class_1657)player);
        data.cycleShape(next);
        data.clearCache();
        new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
    }

    public static boolean isValidTool(class_1799 mainHand, class_1799 offHand) {
        if (mainHand.method_31573(STRICT_DENY_TAG) || offHand.method_31573(STRICT_DENY_TAG) || mainHand.method_31573(DENY_TAG)) {
            return false;
        }
        if (((Boolean)FTBUltimineServerConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand.method_7960()) {
                return false;
            }
            return mainHand.method_7909() instanceof class_1831 || mainHand.method_7936() > 0 || mainHand.method_31573(ALLOW_TAG);
        }
        return true;
    }

    public boolean canUltimine(class_1657 player) {
        class_1799 offHand;
        if (PlayerHooks.isFake((class_1657)player) || player.method_5667() == null || CooldownTracker.isOnCooldown(player)) {
            return false;
        }
        if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        class_1799 mainHand = player.method_6047();
        return FTBUltimine.isValidTool(mainHand, offHand = player.method_6079()) && FTBUltiminePlugins.canUltimine(player);
    }

    public EventResult blockBroken(class_1937 world, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((class_1657)player)) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((class_1657)player);
        if (!data.isPressed()) {
            return EventResult.pass();
        }
        class_239 result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof class_3965) || result.method_17783() != class_239.class_240.field_1332) {
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((class_3965)result).method_17780(), false, FTBUltimineServerConfig.getMaxBlocks(player));
        if (!data.hasCachedPositions()) {
            return EventResult.pass();
        }
        if ((double)player.field_7495 < (double)data.cachedPositions().size() * (Double)FTBUltimineServerConfig.EXPERIENCE_PER_BLOCK.get()) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.method_6047().method_7960();
        float baseSpeed = state.method_26214((class_1922)world, pos);
        int blocksMined = 0;
        for (class_2338 p : data.cachedPositions()) {
            class_2680 state1 = world.method_8320(p);
            float destroySpeed = state1.method_26214((class_1922)world, p);
            if (!player.method_7337() && (destroySpeed < 0.0f || destroySpeed > baseSpeed || !player.method_7305(state1))) continue;
            if (!player.field_13974.method_14266(p) && ((Boolean)FTBUltimineServerConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.method_7337()) {
                player.method_7322((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                if (FTBUltimine.isTooExhausted(player)) break;
            }
            class_1799 stack = player.method_6047();
            if (hadItem && stack.method_7960() || hadItem && stack.method_7985() && stack.method_7969().method_10577("tic_broken") || hadItem && (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get() > 0 && stack.method_7963() && stack.method_7919() >= stack.method_7936() - (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get()) break;
            ++blocksMined;
        }
        if (!player.method_7337()) {
            CooldownTracker.setLastUltimineTime((class_1657)player, System.currentTimeMillis());
            data.addPendingXPCost(Math.max(0, blocksMined - 1));
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.method_37908(), pos);
        if (this.tempBlockDroppedXp > 0) {
            player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        new SendShapePacket(data.getCurrentShapeIndex(), Collections.emptyList()).sendTo(player);
        return EventResult.interruptFalse();
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 clickPos, class_2350 face) {
        class_3965 blockHitResult;
        FTBUltiminePlayerData data;
        class_3222 serverPlayer;
        block21: {
            block20: {
                block19: {
                    block18: {
                        if (!(player instanceof class_3222)) break block18;
                        serverPlayer = (class_3222)player;
                        if (!PlayerHooks.isFake((class_1657)player) && player.method_5667() != null) break block19;
                    }
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData(player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
                    return EventResult.pass();
                }
                class_239 result = FTBUltiminePlayerData.rayTrace(serverPlayer);
                if (!(result instanceof class_3965)) break block20;
                blockHitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block21;
            }
            return EventResult.pass();
        }
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, blockHitResult.method_17780(), false, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        if (shapeContext == null || !data.isPressed() || !data.hasCachedPositions()) {
            return EventResult.pass();
        }
        int didWork = 0;
        if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HARVESTING.get()).booleanValue() && shapeContext.matcher() == BlockMatcher.CROP_LIKE) {
            didWork = RightClickHandlers.cropHarvesting(serverPlayer, hand, clickPos, face, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HOE.get()).booleanValue() && serverPlayer.method_5998(hand).method_7909() instanceof class_1794) {
            didWork = RightClickHandlers.farmlandConversion(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_AXE.get()).booleanValue() && serverPlayer.method_5998(hand).method_7909() instanceof class_1743) {
            didWork = RightClickHandlers.axeStripping(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_SHOVEL.get()).booleanValue() && serverPlayer.method_5998(hand).method_7909() instanceof class_1821) {
            didWork = RightClickHandlers.shovelFlattening(serverPlayer, hand, clickPos, data);
        }
        if (didWork > 0) {
            player.method_6104(hand);
            if (!player.method_7337()) {
                CooldownTracker.setLastUltimineTime(player, System.currentTimeMillis());
                data.addPendingXPCost(Math.max(0, didWork - 1));
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            FTBUltiminePlayerData data = this.getOrCreatePlayerData(player);
            data.checkBlocks(serverPlayer, true, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
            data.takePendingXP(serverPlayer);
        }
    }

    public EventResult entityJoinedWorld(class_1297 entity, class_1937 level) {
        if (entity.method_5805()) {
            if (this.isBreakingBlock && entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                if (!item.method_6983().method_7960()) {
                    this.tempBlockDropsList.add(item.method_6983());
                    item.method_6979(class_1799.field_8037);
                }
                return EventResult.interruptFalse();
            }
            if (this.isBreakingBlock && entity instanceof class_1303) {
                class_1303 orb = (class_1303)entity;
                this.tempBlockDroppedXp += orb.method_5919();
                entity.method_5768();
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static boolean isTooExhausted(class_3222 player) {
        class_1702 data = player.method_7344();
        return data.method_35219() / 4.0f > data.method_7589() + (float)data.method_7586();
    }

    static {
        LOGGER = LogManager.getLogger();
        ranksMod = false;
        DENY_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(MOD_ID, "excluded_tools"));
        STRICT_DENY_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(MOD_ID, "excluded_tools/strict"));
        ALLOW_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(MOD_ID, "included_tools"));
        EXCLUDED_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "excluded_blocks"));
        BLOCK_WHITELIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "block_whitelist"));
        TILLABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "farmland_tillable"));
        FLATTENABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "shovel_flattenable"));
        permissionOverride = player -> true;
    }

    private static class DataReloadListener
    implements class_4013 {
        private DataReloadListener() {
        }

        public void method_14491(class_3300 resourceManager) {
            BlockMatcher.TagCache.onReload();
        }
    }
}

