/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public interface ResourceSearchMode<T> {
    public static final ResourceSearchMode<class_1799> ALL_ITEMS = new ResourceSearchMode<class_1799>(){
        private List<SelectableResource<class_1799>> allItemsCache = null;

        @Override
        public Icon getIcon() {
            return Icons.COMPASS;
        }

        @Override
        public class_5250 getDisplayName() {
            return class_2561.method_43471((String)"ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<? extends SelectableResource<class_1799>> getAllResources() {
            if (this.allItemsCache == null) {
                class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)false, (class_7225.class_7874)ClientUtils.registryAccess());
                this.allItemsCache = class_7706.method_47344().method_47313().stream().map(SelectableResource::item).toList();
            }
            return this.allItemsCache;
        }
    };
    public static final ResourceSearchMode<class_1799> INVENTORY = new ResourceSearchMode<class_1799>(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(class_1802.field_8106);
        }

        @Override
        public class_5250 getDisplayName() {
            return class_2561.method_43471((String)"ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<? extends SelectableResource<class_1799>> getAllResources() {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return Collections.emptySet();
            }
            int invSize = player.method_31548().method_5439();
            ArrayList<SelectableResource<class_1799>> items = new ArrayList<SelectableResource<class_1799>>(invSize);
            for (int i = 0; i < invSize; ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960()) continue;
                items.add(SelectableResource.item(stack));
            }
            return items;
        }
    };
    public static final ResourceSearchMode<FluidStack> ALL_FLUIDS = new ResourceSearchMode<FluidStack>(){
        private List<SelectableResource<FluidStack>> allFluidsCache = null;

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(class_1802.field_8251);
        }

        @Override
        public class_5250 getDisplayName() {
            return class_2561.method_43471((String)"ftblibrary.select_fluid.list_mode.all");
        }

        @Override
        public Collection<? extends SelectableResource<FluidStack>> getAllResources() {
            if (this.allFluidsCache == null) {
                ArrayList fluidstacks = new ArrayList();
                class_7923.field_41173.forEach(f -> {
                    if (f.method_15793(f.method_15785())) {
                        fluidstacks.add(SelectableResource.fluid(FluidStack.create((class_3611)f, (long)FluidStackHooks.bucketAmount())));
                    }
                });
                this.allFluidsCache = List.copyOf(fluidstacks);
            }
            return this.allFluidsCache;
        }
    };

    public Icon getIcon();

    public class_5250 getDisplayName();

    public Collection<? extends SelectableResource<T>> getAllResources();
}

