/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.kit;

import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.apache.commons.lang3.Validate;

public enum KitManager {
    INSTANCE;

    private final Map<String, Kit> allKits = new HashMap<String, Kit>();

    public static KitManager getInstance() {
        return INSTANCE;
    }

    public void load(class_2487 kits) {
        this.allKits.clear();
        kits.method_10541().forEach(key -> this.allKits.put((String)key, Kit.fromNBT(key, kits.method_10562(key))));
    }

    public class_2487 save() {
        return (class_2487)class_156.method_654((Object)new class_2487(), tag -> this.allKits.forEach((name, kit) -> tag.method_10566(name, (class_2520)kit.toNBT())));
    }

    public Optional<Kit> get(String kitName) {
        return Optional.ofNullable(this.allKits.get(kitName));
    }

    public Collection<Kit> allKits() {
        return Collections.unmodifiableCollection(this.allKits.values());
    }

    public void giveKitToPlayer(String kitName, class_3222 player) {
        FTBEPlayerData.getOrCreate((class_1657)player).ifPresent(playerData -> this.get(kitName).ifPresentOrElse(kit -> kit.giveToPlayer(player, (FTBEPlayerData)playerData, true), () -> {
            throw new IllegalArgumentException("Kit '" + kitName + "' does not exist");
        }));
    }

    public void deleteKit(String kitName) {
        Validate.isTrue((boolean)this.allKits.containsKey(kitName), (String)("Kit '" + kitName + "' does not exist"), (Object[])new Object[0]);
        this.allKits.remove(kitName);
        FTBEPlayerData.cleanupKitCooldowns(kitName);
        FTBEWorldData.instance.markDirty();
    }

    public void createFromPlayerInv(String kitName, class_3222 player, long cooldownSecs, boolean hotbarOnly) {
        if (hotbarOnly) {
            class_2371 items = class_2371.method_10211();
            for (int i = 0; i < 9; ++i) {
                items.add((Object)((class_1799)player.method_31548().field_7547.get(i)));
            }
            this.createKit(kitName, cooldownSecs, () -> items);
        } else {
            this.createKit(kitName, cooldownSecs, () -> player.method_31548().field_7547);
        }
    }

    public void createFromBlockInv(String kitName, class_1937 level, class_2338 pos, class_2350 side, long cooldownSecs) {
        this.createKit(kitName, cooldownSecs, () -> InventoryUtil.getItemsInInventory(level, pos, side));
    }

    private void createKit(String kitName, long cooldownSecs, Supplier<class_2371<class_1799>> itemSupplier) {
        List<class_1799> items = itemSupplier.get().stream().filter(stack -> !stack.method_7960()).toList();
        if (items.isEmpty()) {
            throw new IllegalArgumentException("No items found!");
        }
        this.addKit(new Kit(kitName, items, cooldownSecs, false), false);
    }

    public void addKit(Kit kit, boolean overwrite) {
        if (!overwrite) {
            Validate.isTrue((!this.allKits.containsKey(kit.getKitName()) ? 1 : 0) != 0, (String)("Kit '" + kit.getKitName() + "' already exists"), (Object[])new Object[0]);
        }
        this.allKits.put(kit.getKitName(), kit);
        FTBEWorldData.instance.markDirty();
    }
}

