/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.integration.PermissionsHelper;
import dev.ftb.mods.ftbessentials.mixin.PlayerListAccess;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1707;
import net.minecraft.class_1714;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3971;
import net.minecraft.class_4862;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MiscCommands {
    protected static final int DEFAULT_RADIUS = 200;
    protected static final int MAX_PLAYER_RADIUS = 16;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.KICKME.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kickme").requires((Predicate)FTBEConfig.KICKME)).executes(context -> MiscCommands.kickme(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.TRASHCAN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trashcan").requires((Predicate)FTBEConfig.TRASHCAN)).executes(context -> MiscCommands.trashcan(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.ENDER_CHEST.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enderchest").requires((Predicate)FTBEConfig.ENDER_CHEST)).executes(context -> MiscCommands.enderChest(((class_2168)context.getSource()).method_9207(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> MiscCommands.enderChest(((class_2168)context.getSource()).method_9207(), class_2186.method_9315((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.ANVIL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"anvil").requires(FTBEConfig.ANVIL.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((class_2168)context.getSource()).method_9207(), "block.minecraft.anvil", (id, inv, player) -> new VirtualAnvilMenu(id, inv, (class_3222)player))));
        }
        if (FTBEConfig.SMITHING_TABLE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"smithing").requires(FTBEConfig.SMITHING_TABLE.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((class_2168)context.getSource()).method_9207(), "block.minecraft.smithing_table", (id, inv, player) -> new VirtualSmithingMenu(id, inv, (class_3222)player))));
        }
        if (FTBEConfig.CRAFTING_TABLE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"crafting").requires(FTBEConfig.CRAFTING_TABLE.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((class_2168)context.getSource()).method_9207(), "block.minecraft.crafting_table", (id, inv, player) -> new VirtualCraftingMenu(id, inv, (class_3222)player))));
        }
        if (FTBEConfig.STONECUTTER.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stonecutter").requires(FTBEConfig.STONECUTTER.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((class_2168)context.getSource()).method_9207(), "block.minecraft.stonecutter", (id, inv, player) -> new VirtualStoneCutterMenu(id, inv, (class_3222)player))));
        }
        if (FTBEConfig.LEADERBOARD.isEnabled()) {
            dispatcher.register(Leaderboard.buildCommand());
        }
        if (FTBEConfig.REC.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"recording").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.recording(((class_2168)context.getSource()).method_9207())));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"streaming").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.streaming(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.HAT.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hat").requires(FTBEConfig.HAT.enabledAndOp())).executes(context -> MiscCommands.hat(((class_2168)context.getSource()).method_9207())));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nickname").requires((Predicate)FTBEConfig.NICK)).executes(context -> MiscCommands.nickname(((class_2168)context.getSource()).method_9207(), ""))).then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MiscCommands.nickname(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
        }
        if (FTBEConfig.NEAR.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"near").requires(FTBEConfig.NEAR.enabledAndOp())).executes(context -> MiscCommands.showNear((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207(), 200))).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> MiscCommands.showNear((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> MiscCommands.showNear((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), 200))).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> MiscCommands.showNear((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))));
        }
    }

    private static int openWorkSite(class_3222 player, String xlateKey, class_1270 ctor) {
        player.method_17355((class_3908)new class_747((id, inv, p) -> ctor.createMenu(id, inv, (class_1657)player), (class_2561)class_2561.method_43471((String)xlateKey)));
        return 1;
    }

    private static int enderChest(class_3222 player, @Nullable class_3222 target) {
        class_5250 title = class_2561.method_43471((String)"container.enderchest");
        if (target != null) {
            title.method_27693(" \u00d7 ").method_10852(target.method_5476());
        }
        class_3222 t = target == null ? player : target;
        player.method_17355((class_3908)new class_747((i, inv, p) -> class_1707.method_19245((int)i, (class_1661)inv, (class_1263)t.method_7274()), (class_2561)title));
        return 1;
    }

    public static int kickme(class_3222 player) {
        player.field_13987.method_14367((class_2561)class_2561.method_43470((String)"You kicked yourself!"));
        return 1;
    }

    public static int trashcan(class_3222 player) {
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Trash Can");
            }

            public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
                return class_1707.method_19249((int)id, (class_1661)playerInventory);
            }
        });
        return 1;
    }

    public static <T extends Number> int leaderboard(class_2168 source, Leaderboard<T> leaderboard, boolean reverse) {
        int i;
        try (Stream<Path> stream = Files.list(FTBEWorldData.instance.mkdirs("playerdata"));){
            stream.filter(path -> path.toString().endsWith(".json")).map(Path::getFileName).map(path -> new GameProfile(UUID.fromString(path.toString().replace(".json", "")), null)).filter(profile -> !FTBEPlayerData.playerExists(profile.getId())).map(FTBEPlayerData::getOrCreate).filter(Optional::isPresent).forEach(data -> ((FTBEPlayerData)data.get()).load());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        FTBEPlayerData.forEachPlayer(playerData -> {
            class_3442 stats = MiscCommands.getPlayerStats(source.method_9211(), playerData.getUuid());
            Object num = leaderboard.getValue(stats);
            if (leaderboard.test(num)) {
                list.add(Pair.of((Object)playerData, num));
            }
        });
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.method_9228() instanceof class_3222) {
            for (i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get(i)).getLeft()).getUuid().equals(source.method_9228().method_5667())) continue;
                self = list.size();
                break;
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)("== Leaderboard [" + leaderboard.getName() + "] ==")).method_27692(class_124.field_1077), false);
        if (list.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No data!").method_27692(class_124.field_1080), false);
            return 1;
        }
        for (i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            Object num = String.valueOf(i + 1);
            if (i < 10) {
                num = "0" + (String)num;
            }
            class_5250 component = class_2561.method_43470((String)"");
            component.method_27692(class_124.field_1080);
            if (i == 0) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)13938487))));
            } else if (i == 1) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xC0C0C0))));
            } else if (i == 2) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)10451508))));
            } else {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + (String)num + " ")));
            }
            component.method_10852((class_2561)class_2561.method_43470((String)((FTBEPlayerData)pair3.getLeft()).getName()).method_27692(i == self ? class_124.field_1060 : class_124.field_1054));
            component.method_10852((class_2561)class_2561.method_43470((String)": "));
            component.method_10852((class_2561)class_2561.method_43470((String)leaderboard.asString((Number)pair3.getRight())));
            source.method_9226(() -> component, false);
        }
        return 1;
    }

    public static int recording(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.RECORDING);
            PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING) {
                player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is now recording!"), false);
            } else {
                player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is no longer recording!"), false);
            }
            data.sendTabName(player.field_13995);
            return 1;
        }).orElse(0);
    }

    public static int streaming(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.STREAMING);
            PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING) {
                player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is now streaming!"), false);
            } else {
                player.field_13995.method_3760().method_43514((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1054).method_27693(" is no longer streaming!"), false);
            }
            data.sendTabName(player.field_13995);
            return 1;
        }).orElse(0);
    }

    public static int hat(class_3222 player) {
        class_1799 hstack = player.method_6118(class_1304.field_6169);
        class_1799 istack = player.method_6118(class_1304.field_6173);
        player.method_5673(class_1304.field_6169, istack);
        player.method_5673(class_1304.field_6173, hstack);
        player.field_7498.method_7623();
        return 1;
    }

    public static int nickname(class_3222 player, String nick) {
        if (nick.length() > 30) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Nickname too long!"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setNick(nick.trim());
            PlayerDisplayNameUtil.refreshDisplayName((class_1657)player);
            if (data.getNick().isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Nickname reset!"), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)("Nickname changed to '" + data.getNick() + "'")), false);
            }
            data.sendTabName(player.field_13995);
            return 1;
        }).orElse(0);
    }

    private static class_3442 getPlayerStats(MinecraftServer server, UUID playerId) {
        Map<UUID, class_3442> stats = ((PlayerListAccess)server.method_3760()).getStats();
        return stats.computeIfAbsent(playerId, k -> {
            File file1 = server.method_27050(class_5218.field_24181).toFile();
            File file2 = new File(file1, playerId + ".json");
            return new class_3442(server, file2);
        });
    }

    private static int showNear(class_2168 source, class_3222 target, int radius) {
        int max;
        if (!source.method_9259(2) && source.method_43737() && radius > (max = PermissionsHelper.getInstance().getInt(source.method_44023(), 16, "ftbessentials.near.max_radius"))) {
            source.method_9226(() -> class_2561.method_43470((String)("Limiting radius to " + max)).method_27692(class_124.field_1065), false);
            radius = max;
        }
        int radius2 = radius * radius;
        List<class_3222> l = target.method_5682().method_3760().method_14571().stream().filter(other -> other != target).filter(other -> other.method_5858((class_1297)target) < (double)radius2).sorted(Comparator.comparingDouble(o -> o.method_5858((class_1297)target))).toList();
        int r = radius;
        source.method_9226(() -> class_2561.method_43470((String)(l.size() + " player(s) within " + r + "m")).method_27692(class_124.field_1054), false);
        l.forEach(player -> source.method_9226(() -> class_2561.method_43470((String)"\u2022 ").method_10852(player.method_5476()).method_27692(class_124.field_1075).method_27693(String.format(" - %5.2fm", Float.valueOf(player.method_5739((class_1297)target)))), false));
        return 1;
    }

    private static class VirtualStoneCutterMenu
    extends class_3971 {
        public VirtualStoneCutterMenu(int id, class_1661 inv, class_3222 player) {
            super(id, inv, class_3914.method_17392((class_1937)player.method_37908(), (class_2338)player.method_24515()));
        }

        public boolean method_7597(class_1657 player) {
            return true;
        }
    }

    private static class VirtualCraftingMenu
    extends class_1714 {
        public VirtualCraftingMenu(int id, class_1661 inv, class_3222 player) {
            super(id, inv, class_3914.method_17392((class_1937)player.method_37908(), (class_2338)player.method_24515()));
        }

        public boolean method_7597(class_1657 player) {
            return true;
        }
    }

    private static class VirtualSmithingMenu
    extends class_4862 {
        public VirtualSmithingMenu(int id, class_1661 inv, class_3222 player) {
            super(id, inv, class_3914.method_17392((class_1937)player.method_37908(), (class_2338)player.method_24515()));
        }

        protected boolean method_24925(class_2680 blockState) {
            return true;
        }
    }

    private static class VirtualAnvilMenu
    extends class_1706 {
        public VirtualAnvilMenu(int id, class_1661 inv, class_3222 player) {
            super(id, inv, class_3914.method_17392((class_1937)player.method_37908(), (class_2338)player.method_24515()));
        }

        protected boolean method_24925(class_2680 blockState) {
            return true;
        }
    }
}

