/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class HomeCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (FTBEConfig.HOME.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.home(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(HomeCommands.getHomeSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.home(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.setHome(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.setHome(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.delHome(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(HomeCommands.getHomeSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.delHome(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listhomes").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.listHomes((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207().method_7334()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> HomeCommands.listHomes((class_2168)context.getSource(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"player").iterator().next()))));
        }
    }

    public static Set<String> getHomeSuggestions(CommandContext<class_2168> context) throws CommandSyntaxException {
        return FTBEPlayerData.getOrCreate((class_1657)((class_2168)context.getSource()).method_9207()).map(data -> data.homeManager().getNames()).orElse(Set.of());
    }

    public static int home(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> data.homeManager().teleportTo(name, player, data.homeTeleporter).runCommand(player)).orElse(0);
    }

    public static int setHome(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            try {
                data.homeManager().addDestination(name, new TeleportPos((class_1297)player), player);
                player.method_7353((class_2561)class_2561.method_43470((String)"Home set!"), false);
                return 1;
            }
            catch (SavedTeleportManager.TooManyDestinationsException e) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Can't add any more homes!"), false);
                return 0;
            }
        }).orElse(0);
    }

    public static int delHome(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            if (data.homeManager().deleteDestination(name.toLowerCase())) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Home deleted!"), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Home not found!"), false);
            return 0;
        }).orElse(0);
    }

    public static int listHomes(class_2168 source, GameProfile of) {
        return FTBEPlayerData.getOrCreate(of).map(data -> {
            if (data.homeManager().getNames().isEmpty()) {
                source.method_9226(() -> class_2561.method_43470((String)"None"), false);
            } else {
                TeleportPos origin = new TeleportPos((class_5321<class_1937>)source.method_9225().method_27983(), class_2338.method_49638((class_2374)source.method_9222()));
                data.homeManager().destinations().forEach(entry -> source.method_9226(() -> class_2561.method_43470((String)(entry.name() + ": " + entry.destination().distanceString(origin))), false));
            }
            return 1;
        }).orElse(0);
    }
}

