/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.EnumMap;
import net.minecraft.class_2540;

public class ChunkChangeResponsePacket
extends BaseS2CMessage {
    private final int totalChunks;
    private final int changedChunks;
    private final EnumMap<ClaimResult.StandardProblem, Integer> problems;

    public ChunkChangeResponsePacket(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems) {
        this.totalChunks = totalChunks;
        this.changedChunks = changedChunks;
        this.problems = problems;
    }

    ChunkChangeResponsePacket(class_2540 buf) {
        this.totalChunks = buf.method_10816();
        this.changedChunks = buf.method_10816();
        this.problems = new EnumMap(ClaimResult.StandardProblem.class);
        int nProblems = buf.method_10816();
        for (int i = 0; i < nProblems; ++i) {
            String name = buf.method_10800(Short.MAX_VALUE);
            int count = buf.method_10816();
            ClaimResult.StandardProblem.forName(name).ifPresent(res -> this.problems.put((ClaimResult.StandardProblem)res, count));
        }
    }

    public MessageType getType() {
        return FTBChunksNet.CHUNK_CHANGE_RESPONSE;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.totalChunks);
        buf.method_10804(this.changedChunks);
        buf.method_10804(this.problems.size());
        this.problems.forEach((res, count) -> {
            buf.method_10814(res.getResultId());
            buf.method_10804(count.intValue());
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        ChunkScreen.notifyChunkUpdates(this.totalChunks, this.changedChunks, this.problems);
    }
}

