/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.stc;

import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2540;

public class NavigationResponsePacket
implements IPacketBase<NavigationResponsePacket> {
    public long id;
    public List<SimpleRoute> routes;
    public long duration;
    public long lastUpdated;

    public NavigationResponsePacket() {
    }

    public NavigationResponsePacket(long id, List<SimpleRoute> routes, long duration, long lastUpdated) {
        this.id = id;
        this.routes = routes;
        this.duration = duration;
        this.lastUpdated = lastUpdated;
    }

    public void encode(NavigationResponsePacket packet, class_2540 buffer) {
        buffer.writeLong(packet.id);
        buffer.writeLong(packet.duration);
        buffer.writeLong(packet.lastUpdated);
        buffer.writeInt(packet.routes.size());
        for (SimpleRoute route : packet.routes) {
            buffer.method_10794(route.toNbt());
        }
    }

    public NavigationResponsePacket decode(class_2540 buffer) {
        long id = buffer.readLong();
        long duration = buffer.readLong();
        long lastUpdated = buffer.readLong();
        int routesCount = buffer.readInt();
        ArrayList<SimpleRoute> routes = new ArrayList<SimpleRoute>(routesCount);
        for (int i = 0; i < routesCount; ++i) {
            routes.add(SimpleRoute.fromNbt(buffer.method_10798()));
        }
        return new NavigationResponsePacket(id, routes, duration, lastUpdated);
    }

    public void handle(NavigationResponsePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> NavigationResponsePacket.lambda$handle$1((Supplier)contextSupplier, packet));
    }

    private static /* synthetic */ void lambda$handle$1(Supplier contextSupplier, NavigationResponsePacket packet) {
        ((NetworkManager.PacketContext)contextSupplier.get()).queue(() -> InstanceManager.runClientNavigationResponseAction(packet.id, packet.routes, new NavigationResponseData(packet.lastUpdated, packet.duration)));
    }

    public record NavigationResponseData(long lastUpdated, long calculationTime) {
    }
}

