/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.event.listeners;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.RealtimeRequestPacket;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class JourneyListener {
    public static final int ID = 1;
    private static final int REALTIME_REFRESH_TIME = 100;
    private final SimpleRoute route;
    private int stationIndex = 0;
    private State currentState = State.BEFORE_JOURNEY;
    private int realTimeRefreshTimer = 0;
    private boolean isStarted;
    private static final String keyJourneyBegins = "gui.createrailwaysnavigator.route_overview.journey_begins";
    private static final String keyJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.journey_begins_with_platform";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyAfterJourney = "gui.createrailwaysnavigator.route_overview.after_journey";
    private static final String keyJourneyInterruptedTitle = "gui.createrailwaysnavigator.route_overview.train_canceled_title";
    private static final String keyJourneyInterrupted = "gui.createrailwaysnavigator.route_overview.train_canceled_info";
    private static final String keyConnectionMissedInfo = "gui.createrailwaysnavigator.route_overview.connection_missed_info";
    private static final String keyOptionsText = "gui.createrailwaysnavigator.route_overview.options";
    private static final String keyKeybindOptions = "key.createrailwaysnavigator.route_overlay_options";
    private static final String keyNotificationJourneyBeginsTitle = "gui.createrailwaysnavigator.route_overview.notification.journey_begins.title";
    private static final String keyNotificationJourneyBegins = "gui.createrailwaysnavigator.route_overview.notification.journey_begins";
    private static final String keyNotificationJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.journey_begins_with_platform";
    private static final String keyNotificationPlatformChangedTitle = "gui.createrailwaysnavigator.route_overview.notification.platform_changed.title";
    private static final String keyNotificationPlatformChanged = "gui.createrailwaysnavigator.route_overview.notification.platform_changed";
    private static final String keyNotificationTrainDelayedTitle = "gui.createrailwaysnavigator.route_overview.notification.train_delayed.title";
    private static final String keyNotificationTrainDelayed = "gui.createrailwaysnavigator.route_overview.notification.train_delayed";
    private static final String keyNotificationTransferTitle = "gui.createrailwaysnavigator.route_overview.notification.transfer.title";
    private static final String keyNotificationTransfer = "gui.createrailwaysnavigator.route_overview.notification.transfer";
    private static final String keyNotificationTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.transfer_with_platform";
    private static final String keyNotificationConnectionEndangeredTitle = "gui.createrailwaysnavigator.route_overview.notification.connection_endangered.title";
    private static final String keyNotificationConnectionEndangered = "gui.createrailwaysnavigator.route_overview.notification.connection_endangered";
    private static final String keyNotificationConnectionMissedTitle = "gui.createrailwaysnavigator.route_overview.notification.connection_missed.title";
    private static final String keyNotificationConnectionMissed = "gui.createrailwaysnavigator.route_overview.notification.connection_missed";
    private static final String keyNotificationJourneyCompletedTitle = "gui.createrailwaysnavigator.route_overview.notification.journey_completed.title";
    private static final String keyNotificationJourneyCompleted = "gui.createrailwaysnavigator.route_overview.notification.journey_completed";
    private Map<UUID, Optional<Runnable>> onUpdateRealtime = new HashMap<UUID, Optional<Runnable>>();
    private Map<UUID, Optional<Consumer<class_2561>>> onInfoTextChange = new HashMap<UUID, Optional<Consumer<class_2561>>>();
    private Map<UUID, Optional<Consumer<NotificationData>>> onNotificationSend = new HashMap<UUID, Optional<Consumer<NotificationData>>>();
    private Map<UUID, Optional<Consumer<State>>> onStateChange = new HashMap<UUID, Optional<Consumer<State>>>();
    private Map<UUID, Optional<Consumer<String>>> onNarratorAnnounce = new HashMap<UUID, Optional<Consumer<String>>>();
    private Map<UUID, Optional<Consumer<JourneyBeginData>>> onJourneyBegin = new HashMap<UUID, Optional<Consumer<JourneyBeginData>>>();
    private Map<UUID, Optional<Consumer<JourneyInterruptData>>> onJourneyInterrupt = new HashMap<UUID, Optional<Consumer<JourneyInterruptData>>>();
    private Map<UUID, Optional<Consumer<ReachNextStopData>>> onReachNextStop = new HashMap<UUID, Optional<Consumer<ReachNextStopData>>>();
    private Map<UUID, Optional<Consumer<ContinueData>>> onContinue = new HashMap<UUID, Optional<Consumer<ContinueData>>>();
    private Map<UUID, Optional<Consumer<FinishJourneyData>>> onFinishJourney = new HashMap<UUID, Optional<Consumer<FinishJourneyData>>>();
    private Map<UUID, Optional<Consumer<AnnounceNextStopData>>> onAnnounceNextStop = new HashMap<UUID, Optional<Consumer<AnnounceNextStopData>>>();
    private class_2561 lastInfoText = TextUtils.empty();
    private NotificationData lastNotification = null;
    private String lastNarratorText = "";
    private boolean beginAnnounced = false;

    public JourneyListener(SimpleRoute route) {
        this.route = route;
    }

    public static JourneyListener listenTo(SimpleRoute route) {
        return new JourneyListener(route);
    }

    public JourneyListener start() {
        class_5250 text = this.currentStation().getInfo().platform() == null || this.currentStation().getInfo().platform().isBlank() ? ELanguage.translate(keyJourneyBegins, this.currentStation().getTrain().trainName(), this.currentStation().getTrain().scheduleTitle(), TimeUtils.parseTime((long)((int)((this.currentStation().getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))) : ELanguage.translate(keyJourneyBeginsWithPlatform, this.currentStation().getTrain().trainName(), this.currentStation().getTrain().scheduleTitle(), TimeUtils.parseTime((long)((int)((this.currentStation().getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), this.currentStation().getInfo().platform());
        String narratorText = text.getString() + ". " + ELanguage.translate(keyOptionsText, TextUtils.keybind((String)keyKeybindOptions)).getString();
        this.onJourneyBegin.values().forEach(arg_0 -> this.lambda$start$0((class_2561)text, narratorText, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
        this.isStarted = true;
        this.requestRealtimeData();
        return this;
    }

    public JourneyListener stop() {
        this.isStarted = false;
        return this;
    }

    public JourneyListener registerOnUpdateRealtime(IJourneyListenerClient client, Runnable m) {
        this.unregisterOnUpdateRealtime(client);
        this.onUpdateRealtime.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnStateChange(IJourneyListenerClient client, Consumer<State> m) {
        this.unregisterOnUpdateRealtime(client);
        this.onStateChange.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnNarratorAnnounce(IJourneyListenerClient client, Consumer<String> m) {
        this.unregisterOnNarratorAnnounce(client);
        this.onNarratorAnnounce.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnInfoTextChange(IJourneyListenerClient client, Consumer<class_2561> m) {
        this.unregisterOnInfoTextChange(client);
        this.onInfoTextChange.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnNotification(IJourneyListenerClient client, Consumer<NotificationData> m) {
        this.unregisterOnNotification(client);
        this.onNotificationSend.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnReachNextStop(IJourneyListenerClient client, Consumer<ReachNextStopData> m) {
        this.unregisterOnReachNextStop(client);
        this.onReachNextStop.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnContinueWithJourneyAfterStop(IJourneyListenerClient client, Consumer<ContinueData> m) {
        this.unregisterOnContinueWithJourneyAfterStop(client);
        this.onContinue.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnFinishJourney(IJourneyListenerClient client, Consumer<FinishJourneyData> m) {
        this.unregisterOnFinishJourney(client);
        this.onFinishJourney.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnAnnounceNextStop(IJourneyListenerClient client, Consumer<AnnounceNextStopData> m) {
        this.unregisterOnAnnounceNextStop(client);
        this.onAnnounceNextStop.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnJourneyBegin(IJourneyListenerClient client, Consumer<JourneyBeginData> m) {
        this.unregisterOnJourneyBegin(client);
        this.onJourneyBegin.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public JourneyListener registerOnJourneyInterrupt(IJourneyListenerClient client, Consumer<JourneyInterruptData> m) {
        this.unregisterOnJourneyInterrupt(client);
        this.onJourneyInterrupt.put(client.getJourneyListenerClientId(), Optional.of(m));
        return this;
    }

    public void unregisterOnUpdateRealtime(IJourneyListenerClient client) {
        if (this.onUpdateRealtime.containsKey(client.getJourneyListenerClientId())) {
            this.onUpdateRealtime.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnStateChange(IJourneyListenerClient client) {
        if (this.onStateChange.containsKey(client.getJourneyListenerClientId())) {
            this.onStateChange.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnNarratorAnnounce(IJourneyListenerClient client) {
        if (this.onNarratorAnnounce.containsKey(client.getJourneyListenerClientId())) {
            this.onNarratorAnnounce.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnNotification(IJourneyListenerClient client) {
        if (this.onNotificationSend.containsKey(client.getJourneyListenerClientId())) {
            this.onNotificationSend.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnInfoTextChange(IJourneyListenerClient client) {
        if (this.onInfoTextChange.containsKey(client.getJourneyListenerClientId())) {
            this.onInfoTextChange.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnReachNextStop(IJourneyListenerClient client) {
        if (this.onReachNextStop.containsKey(client.getJourneyListenerClientId())) {
            this.onReachNextStop.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnContinueWithJourneyAfterStop(IJourneyListenerClient client) {
        if (this.onContinue.containsKey(client.getJourneyListenerClientId())) {
            this.onContinue.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnFinishJourney(IJourneyListenerClient client) {
        if (this.onFinishJourney.containsKey(client.getJourneyListenerClientId())) {
            this.onFinishJourney.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnAnnounceNextStop(IJourneyListenerClient client) {
        if (this.onAnnounceNextStop.containsKey(client.getJourneyListenerClientId())) {
            this.onAnnounceNextStop.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnJourneyBegin(IJourneyListenerClient client) {
        if (this.onJourneyBegin.containsKey(client.getJourneyListenerClientId())) {
            this.onJourneyBegin.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregisterOnJourneyInterrupt(IJourneyListenerClient client) {
        if (this.onJourneyInterrupt.containsKey(client.getJourneyListenerClientId())) {
            this.onJourneyInterrupt.remove(client.getJourneyListenerClientId());
        }
    }

    public void unregister(IJourneyListenerClient client) {
        this.unregisterOnAnnounceNextStop(client);
        this.unregisterOnContinueWithJourneyAfterStop(client);
        this.unregisterOnFinishJourney(client);
        this.unregisterOnInfoTextChange(client);
        this.unregisterOnJourneyBegin(client);
        this.unregisterOnNarratorAnnounce(client);
        this.unregisterOnReachNextStop(client);
        this.unregisterOnStateChange(client);
        this.unregisterOnUpdateRealtime(client);
        this.unregisterOnNotification(client);
        this.unregisterOnJourneyInterrupt(client);
    }

    public void tick() {
        if (!this.isStarted) {
            return;
        }
        if (this.currentState != State.AFTER_JOURNEY && this.currentState != State.JOURNEY_INTERRUPTED) {
            ++this.realTimeRefreshTimer;
            if (this.realTimeRefreshTimer > 100) {
                this.realTimeRefreshTimer = 0;
                this.requestRealtimeData();
            }
        }
        if (!this.beginAnnounced && this.firstStation().getEstimatedTime() - (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue() < class_310.method_1551().field_1687.method_8532()) {
            class_5250 title = ELanguage.translate(keyNotificationJourneyBeginsTitle, this.lastStation().getStationName());
            class_5250 description = this.currentStation().getInfo().platform() == null || this.currentStation().getInfo().platform().isBlank() ? ELanguage.translate(keyNotificationJourneyBegins, this.currentStation().getTrain().trainName(), this.currentStation().getTrain().scheduleTitle(), TimeUtils.parseTime((long)((int)((this.currentStation().getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))) : ELanguage.translate(keyNotificationJourneyBeginsWithPlatform, this.currentStation().getTrain().trainName(), this.currentStation().getTrain().scheduleTitle(), TimeUtils.parseTime((long)((int)((this.currentStation().getEstimatedTimeWithThreshold() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), this.currentStation().getInfo().platform());
            this.setNotificationText(new NotificationData(this.currentState, (class_2561)title, (class_2561)description));
            this.setNarratorText(title.getString() + " " + description.getString());
            this.beginAnnounced = true;
        }
    }

    private void requestRealtimeData() {
        List<UUID> ids = Arrays.stream(this.route.getStationArray()).map(x -> x.getTrain().trainId()).distinct().toList();
        long id = InstanceManager.registerClientRealtimeResponseAction((predictions, time) -> {
            Map<UUID, List<DeparturePrediction.SimpleDeparturePrediction>> predMap = predictions.stream().collect(Collectors.groupingBy(DeparturePrediction.SimpleDeparturePrediction::trainId));
            if (predMap.containsKey(this.currentStation().getTrain().trainId())) {
                DeparturePrediction.SimpleDeparturePrediction currentTrainNextStop = predMap.get(this.currentStation().getTrain().trainId()).get(0);
                List<DeparturePrediction.SimpleDeparturePrediction> currentTrainSchedule = predMap.get(this.currentStation().getTrain().trainId());
                if (this.currentState != State.BEFORE_JOURNEY && this.currentState != State.JOURNEY_INTERRUPTED && this.currentState != State.WHILE_TRAVELING && this.currentState != State.WHILE_TRANSFER) {
                    while (!currentTrainNextStop.stationTagName().equals(this.currentStation().getStationName()) && this.currentState != State.AFTER_JOURNEY) {
                        if (this.currentStation().getTag() == SimpleRoute.StationTag.END) continue;
                        this.nextStop();
                    }
                }
                if ((!this.currentState.isWaitingForNextTrainToDepart() || this.currentState == State.BEFORE_JOURNEY || this.currentState == State.WHILE_TRANSFER) && this.currentStation().shouldRenderRealtime() && this.isStationValidForShedule(currentTrainSchedule, this.currentStation().getTrain().trainId(), this.stationIndex) && time >= this.currentStation().getEstimatedTime()) {
                    if (this.currentStation().getTag() == SimpleRoute.StationTag.PART_END) {
                        if (this.route.getStationArray()[this.stationIndex + 1].isTrainCanceled()) {
                            this.journeyInterrupt(this.route.getStationArray()[this.stationIndex + 1]);
                        } else if (this.route.getStationArray()[this.stationIndex + 1].isDeparted()) {
                            this.reachTransferStopConnectionMissed();
                        } else {
                            this.reachTransferStop();
                        }
                    } else if (this.currentStation().getTag() == SimpleRoute.StationTag.END) {
                        this.finishJourney();
                    } else {
                        this.reachNextStop();
                    }
                }
                if (this.currentState == State.AFTER_JOURNEY) {
                    return;
                }
            } else {
                this.journeyInterrupt(this.currentStation());
                return;
            }
            Map mappedRoute = Arrays.stream(this.route.getStationArray()).skip(this.stationIndex).collect(Collectors.groupingBy(x -> x.getTrain().trainId(), LinkedHashMap::new, Collectors.toList()));
            for (int i = this.stationIndex; i < this.route.getStationCount(true); ++i) {
                SimpleRoute.StationEntry e = this.route.getStationArray()[i];
                if (!predMap.containsKey(e.getTrain().trainId()) || e.isTrainCanceled()) {
                    e.setTrainCanceled(true, "", e.getTrain().trainName());
                    continue;
                }
                List<DeparturePrediction.SimpleDeparturePrediction> preds = predMap.get(e.getTrain().trainId());
                List stations = (List)mappedRoute.get(e.getTrain().trainId());
                this.updateRealtime(preds, stations, e.getTrain().trainId(), this.stationIndex, (long)time);
            }
            boolean departed = false;
            for (List routePart : mappedRoute.values()) {
                if (mappedRoute.size() < 2 || ((SimpleRoute.StationEntry)routePart.get(0)).isDeparted()) continue;
                if (departed) {
                    routePart.forEach(x -> x.setDeparted(true));
                    continue;
                }
                long min = routePart.stream().filter(x -> x.getCurrentTime() + (long)((Integer)ModClientConfig.TRANSFER_TIME.get()).intValue() > x.getScheduleTime()).mapToLong(x -> x.getCurrentTime()).min().orElse(-1L);
                long currentTime = ((SimpleRoute.StationEntry)routePart.get(0)).getCurrentTime();
                if (min <= 0L || currentTime <= min || currentTime + (long)((Integer)ModClientConfig.TRANSFER_TIME.get()).intValue() <= ((SimpleRoute.StationEntry)routePart.get(0)).getScheduleTime()) continue;
                routePart.forEach(x -> x.setDeparted(true));
                departed = true;
                class_5250 title = ELanguage.translate(keyNotificationConnectionMissedTitle);
                class_5250 description = ELanguage.translate(keyNotificationConnectionMissed, ((SimpleRoute.StationEntry)routePart.get(0)).getTrain().trainName(), ((SimpleRoute.StationEntry)routePart.get(0)).getTrain().scheduleTitle());
                this.setNotificationText(new NotificationData(this.currentState, (class_2561)title, (class_2561)description));
                this.setNarratorText(title.getString() + " " + description.getString());
            }
            this.checkStationAccessibility();
            if (this.currentState != State.BEFORE_JOURNEY && this.currentState != State.JOURNEY_INTERRUPTED && !this.currentState.nextStopAnnounced() && !this.currentState.isWaitingForNextTrainToDepart() && time >= this.route.getStationArray()[this.stationIndex].getEstimatedTime() - (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue()) {
                this.announceNextStop();
            }
            this.onUpdateRealtime.values().forEach(x -> {
                if (x.isPresent()) {
                    ((Runnable)x.get()).run();
                }
            });
        });
        CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new RealtimeRequestPacket(id, ids));
    }

    private boolean isStationValidForShedule(List<DeparturePrediction.SimpleDeparturePrediction> schedule, UUID trainId, int startIndex) {
        SimpleRoute.StationEntry entry;
        ArrayList<String> filteredStationEntryList = new ArrayList<String>();
        for (int i = startIndex; i < this.route.getStationCount(true) && (entry = this.route.getStationArray()[i]).getTrain().trainId().equals(trainId); ++i) {
            filteredStationEntryList.add(entry.getStationName());
        }
        String[] filteredStationEntries = (String[])filteredStationEntryList.toArray(String[]::new);
        String[] sched = (String[])schedule.stream().map(x -> x.stationTagName()).toArray(String[]::new);
        int k = 0;
        for (int i = 0; i < filteredStationEntries.length; ++i) {
            if (!filteredStationEntries[i].equals(sched[k])) {
                return false;
            }
            if (++k <= sched.length) continue;
            k = 0;
        }
        return true;
    }

    private void updateRealtime(List<DeparturePrediction.SimpleDeparturePrediction> schedule, List<SimpleRoute.StationEntry> route, UUID trainId, int startIndex, long updateTime) {
        boolean b = false;
        long lastTime = -1L;
        List<SimpleRoute.StationEntry> routePart = route.stream().filter(x -> x.getTrain().trainId().equals(trainId)).toList();
        SimpleRoute.StationEntry first = routePart.get(0);
        if (first.getTag() != SimpleRoute.StationTag.PART_START && first.getTag() != SimpleRoute.StationTag.START) {
            first = null;
        }
        SimpleRoute.StationEntry last = routePart.get(routePart.size() - 1);
        boolean wasDelayed = last.isDelayed();
        TrainStationAlias.StationInfo oldInfo = first == null ? null : first.getUpdatedInfo();
        int k = 0;
        for (int i = 0; i < schedule.size() && k < route.size(); ++i) {
            DeparturePrediction.SimpleDeparturePrediction current = schedule.get(i);
            long newTime = (long)current.departureTicks() + updateTime;
            if (route.get(0).getStationName().equals(current.stationTagName())) {
                k = 0;
                b = true;
            }
            if (route.get(k).getStationName().equals(current.stationTagName()) && b) {
                if (newTime > lastTime) {
                    route.get(k).updateRealtimeData(current.departureTicks(), updateTime, current.stationInfo(), () -> {});
                    lastTime = route.get(k).getCurrentTime();
                }
                ++k;
                continue;
            }
            b = false;
        }
        if (oldInfo != null && !first.getUpdatedInfo().equals(oldInfo)) {
            this.setNotificationText(new NotificationData(this.currentState, (class_2561)ELanguage.translate(keyNotificationPlatformChangedTitle), (class_2561)ELanguage.translate(keyNotificationPlatformChanged, first.getStationName(), first.getUpdatedInfo().platform())));
        }
        if (!wasDelayed && last.isDelayed()) {
            this.setNotificationText(new NotificationData(this.currentState, (class_2561)ELanguage.translate(keyNotificationTrainDelayedTitle, last.getTrain().trainName(), TimeUtils.parseDuration((long)last.getDifferenceTime())), (class_2561)ELanguage.translate(keyNotificationTrainDelayed, TimeUtils.parseTime((long)((int)(last.getEstimatedTimeWithThreshold() % 24000L) + 6000), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), TimeUtils.parseTime((long)((int)(last.getScheduleTime() % 24000L) + 6000), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), last.getStationName())));
        }
    }

    private void checkStationAccessibility() {
        boolean willMiss = false;
        for (int i = this.stationIndex; i < this.route.getStationCount(true); ++i) {
            SimpleRoute.StationEntry station = this.route.getStationArray()[i];
            SimpleRoute.StationEntry nextStation = i < this.route.getStationCount(true) - 1 ? this.route.getStationArray()[i + 1] : null;
            boolean wasWillMiss = station.willMissStop();
            if (nextStation == null) continue;
            if (station.isDeparted()) {
                willMiss = true;
            }
            if (!willMiss) {
                long transferTime = -1L;
                if (nextStation != null && !nextStation.isDeparted()) {
                    transferTime = nextStation.getCurrentTime() + (long)((Integer)ModClientConfig.TRANSFER_TIME.get()).intValue() < nextStation.getScheduleTime() ? nextStation.getScheduleTime() - station.getScheduleTime() : nextStation.getCurrentTime() - station.getCurrentTime();
                }
                if (transferTime < 0L) {
                    willMiss = true;
                }
            }
            station.setWillMiss(willMiss);
            if (station.getTag() != SimpleRoute.StationTag.PART_START || wasWillMiss || !station.willMissStop()) continue;
            this.setNotificationText(new NotificationData(this.currentState, (class_2561)ELanguage.translate(keyNotificationConnectionEndangeredTitle), (class_2561)ELanguage.translate(keyNotificationConnectionEndangered, station.getTrain().trainName(), station.getTrain().scheduleTitle())));
        }
    }

    public class_2561 getLastInfoText() {
        return this.lastInfoText;
    }

    public String lastNarratorText() {
        return this.lastNarratorText;
    }

    public NotificationData getLastNotification() {
        return this.lastNotification;
    }

    private void setState(State state) {
        this.currentState = state;
        this.onStateChange.values().forEach(x -> {
            if (x.isPresent()) {
                ((Consumer)x.get()).accept(this.currentState);
            }
        });
    }

    private void setInfoText(class_2561 text) {
        this.lastInfoText = text;
        this.onInfoTextChange.values().forEach(x -> {
            if (x.isPresent()) {
                ((Consumer)x.get()).accept(text);
            }
        });
    }

    private void setNotificationText(NotificationData data) {
        this.lastNotification = data;
        this.onNotificationSend.values().forEach(x -> {
            if (x.isPresent()) {
                ((Consumer)x.get()).accept(data);
            }
        });
    }

    private void setNarratorText(String text) {
        this.lastNarratorText = text;
        this.onNarratorAnnounce.values().forEach(x -> {
            if (x.isPresent()) {
                ((Consumer)x.get()).accept(text);
            }
        });
    }

    private void nextStop() {
        if (!this.changeCurrentStation()) {
            return;
        }
        this.setState(State.WHILE_TRAVELING);
        this.onContinue.values().forEach(x -> {
            if (x.isPresent()) {
                ((Consumer)x.get()).accept(new ContinueData(this.currentState));
            }
        });
    }

    private boolean changeCurrentStation() {
        if (this.stationIndex + 1 >= this.route.getStationCount(true)) {
            this.finishJourney();
            return false;
        }
        ++this.stationIndex;
        return true;
    }

    private void finishJourney() {
        class_5250 text = ELanguage.translate(keyAfterJourney, this.route.getStationArray()[this.route.getStationCount(true) - 1].getStationName());
        this.setState(State.AFTER_JOURNEY);
        this.onFinishJourney.values().forEach(arg_0 -> this.lambda$finishJourney$19((class_2561)text, arg_0));
        this.setInfoText((class_2561)text);
        this.setNotificationText(new NotificationData(this.currentState, (class_2561)ELanguage.translate(keyNotificationJourneyCompletedTitle), (class_2561)ELanguage.translate(keyNotificationJourneyCompleted)));
        this.stop();
    }

    private void announceNextStop() {
        class_5250 textA = TextUtils.empty();
        class_5250 textB = TextUtils.empty();
        class_5250 text = textA = ELanguage.translate(keyNextStop, this.currentStation().getStationName());
        if (this.currentStation().getTag() == SimpleRoute.StationTag.PART_END && this.currentStation().getIndex() + 1 < this.route.getStationCount(true)) {
            textB = this.nextStation().get().getInfo().platform() == null || this.nextStation().get().getInfo().platform().isBlank() ? ELanguage.translate(keyTransfer, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle()) : ELanguage.translate(keyTransferWithPlatform, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle(), this.nextStation().get().getInfo().platform());
            class_5250 transferText = textB;
            text = TextUtils.concatWithStarChars((class_2561[])new class_2561[]{text, transferText});
            this.setState(State.BEFORE_TRANSFER);
            this.setNotificationText(new NotificationData(this.currentState, (class_2561)ELanguage.translate(keyNotificationTransferTitle), (class_2561)(this.nextStation().get().getInfo().platform() == null || this.nextStation().get().getInfo().platform().isBlank() ? ELanguage.translate(keyNotificationTransfer, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle()) : ELanguage.translate(keyNotificationTransferWithPlatform, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle(), this.nextStation().get().getInfo().platform()))));
        } else {
            this.setState(State.BEFORE_NEXT_STOP);
        }
        String narratorText = textA.getString() + ". " + textB.getString();
        boolean transfer = this.currentStation().getTag() == SimpleRoute.StationTag.PART_END && this.currentStation().getIndex() + 1 < this.route.getStationCount(true);
        class_5250 fText = text;
        this.onAnnounceNextStop.values().forEach(arg_0 -> this.lambda$announceNextStop$20((class_2561)fText, narratorText, transfer, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
    }

    private void reachNextStop() {
        class_5250 text = TextUtils.text((String)this.currentStation().getStationName());
        String narratorText = text.getString();
        this.setState(State.WHILE_NEXT_STOP);
        this.onReachNextStop.values().forEach(arg_0 -> this.lambda$reachNextStop$21((class_2561)text, narratorText, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
    }

    private void reachTransferStop() {
        class_5250 text = this.nextStation().isPresent() ? (this.nextStation().get().getInfo().platform() == null || this.nextStation().get().getInfo().platform().isBlank() ? ELanguage.translate(keyTransfer, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle()) : ELanguage.translate(keyTransferWithPlatform, this.nextStation().get().getTrain().trainName(), this.nextStation().get().getTrain().scheduleTitle(), this.nextStation().get().getInfo().platform())) : TextUtils.empty();
        String narratorText = text.getString();
        this.setState(State.WHILE_TRANSFER);
        this.changeCurrentStation();
        this.onReachNextStop.values().forEach(arg_0 -> this.lambda$reachTransferStop$22((class_2561)text, narratorText, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
    }

    private void reachTransferStopConnectionMissed() {
        class_5250 text = TextUtils.concatWithStarChars((class_2561[])new class_2561[]{TextUtils.text((String)this.currentStation().getStationName()), ELanguage.translate(keyConnectionMissedInfo)});
        String narratorText = "";
        this.setState(State.JOURNEY_INTERRUPTED);
        this.onReachNextStop.values().forEach(arg_0 -> this.lambda$reachTransferStopConnectionMissed$23((class_2561)text, narratorText, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
        this.stop();
    }

    private void journeyInterrupt(SimpleRoute.StationEntry station) {
        class_5250 text = ELanguage.translate(keyJourneyInterruptedTitle);
        class_5250 desc = ELanguage.translate(keyJourneyInterrupted, station.getTrain().trainName());
        String narratorText = "";
        this.setState(State.JOURNEY_INTERRUPTED);
        this.onJourneyInterrupt.values().forEach(arg_0 -> this.lambda$journeyInterrupt$24((class_2561)text, (class_2561)desc, narratorText, arg_0));
        this.setInfoText((class_2561)text);
        this.setNarratorText(narratorText);
        this.stop();
    }

    public long getTransferTime(int index) {
        Optional<SimpleRoute.StationEntry> station = this.getEntryAt(index);
        Optional<SimpleRoute.StationEntry> nextStation = this.getEntryAt(index + 1);
        long transferTime = -1L;
        if (station.isPresent() && nextStation.isPresent() && !nextStation.get().isDeparted()) {
            transferTime = nextStation.get().getCurrentTime() + (long)((Integer)ModClientConfig.TRANSFER_TIME.get()).intValue() < nextStation.get().getScheduleTime() ? nextStation.get().getScheduleTime() - station.get().getScheduleTime() : nextStation.get().getCurrentTime() - station.get().getCurrentTime();
        }
        return transferTime;
    }

    public SimpleRoute.StationEntry currentStation() {
        return this.route.getStationArray()[this.stationIndex];
    }

    public Optional<SimpleRoute.StationEntry> nextStation() {
        return this.stationIndex + 1 < this.route.getStationCount(true) ? Optional.of(this.route.getStationArray()[this.stationIndex + 1]) : Optional.empty();
    }

    public Optional<SimpleRoute.StationEntry> previousSation() {
        return this.stationIndex > 0 ? Optional.of(this.route.getStationArray()[this.stationIndex - 1]) : Optional.empty();
    }

    public SimpleRoute.StationEntry firstStation() {
        return this.route.getStationArray()[0];
    }

    public SimpleRoute.StationEntry lastStation() {
        return this.route.getStationArray()[this.route.getStationCount(true) - 1];
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public long getTimeDifferenceForStation(int index) {
        SimpleRoute.StationEntry station = this.route.getStationArray()[index];
        return station.getCurrentRefreshTime() + (long)station.getCurrentTicks() - station.getRefreshTime() - (long)station.getTicks();
    }

    public int getIndex() {
        return this.stationIndex;
    }

    public SimpleRoute getListeningRoute() {
        return this.route;
    }

    public Optional<SimpleRoute.StationEntry> getEntryAt(int index) {
        return index >= 0 && index < this.route.getStationCount(true) ? Optional.of(this.route.getStationArray()[index]) : Optional.empty();
    }

    private /* synthetic */ void lambda$journeyInterrupt$24(class_2561 text, class_2561 desc, String narratorText, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new JourneyInterruptData(this.currentState, text, desc, narratorText));
        }
    }

    private /* synthetic */ void lambda$reachTransferStopConnectionMissed$23(class_2561 text, String narratorText, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new ReachNextStopData(this.currentState, text, narratorText, TransferState.CONNECTION_MISSED));
        }
    }

    private /* synthetic */ void lambda$reachTransferStop$22(class_2561 text, String narratorText, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new ReachNextStopData(this.currentState, text, narratorText, TransferState.DEFAULT));
        }
    }

    private /* synthetic */ void lambda$reachNextStop$21(class_2561 text, String narratorText, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new ReachNextStopData(this.currentState, text, narratorText, TransferState.NONE));
        }
    }

    private /* synthetic */ void lambda$announceNextStop$20(class_2561 fText, String narratorText, boolean transfer, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new AnnounceNextStopData(this.currentState, fText, narratorText, transfer));
        }
    }

    private /* synthetic */ void lambda$finishJourney$19(class_2561 text, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new FinishJourneyData(this.currentState, text));
        }
    }

    private /* synthetic */ void lambda$start$0(class_2561 text, String narratorText, Optional x) {
        if (x.isPresent()) {
            ((Consumer)x.get()).accept(new JourneyBeginData(this.currentState, text, narratorText));
        }
    }

    public static enum State {
        BEFORE_JOURNEY,
        WHILE_TRAVELING,
        BEFORE_NEXT_STOP,
        WHILE_NEXT_STOP,
        BEFORE_TRANSFER,
        WHILE_TRANSFER,
        AFTER_JOURNEY,
        JOURNEY_INTERRUPTED;


        public boolean nextStopAnnounced() {
            return this == BEFORE_NEXT_STOP || this == BEFORE_TRANSFER;
        }

        public boolean isWhileTraveling() {
            return this == WHILE_TRAVELING;
        }

        public boolean isTranferring() {
            return this == WHILE_TRANSFER;
        }

        public boolean isAtNextStop() {
            return this == WHILE_NEXT_STOP;
        }

        public boolean isWaitingForNextTrainToDepart() {
            return this.isTranferring() || this.isAtNextStop();
        }

        public boolean important() {
            return this == WHILE_TRANSFER || this == BEFORE_TRANSFER || this == AFTER_JOURNEY || this == BEFORE_JOURNEY || this == JOURNEY_INTERRUPTED;
        }
    }

    public record NotificationData(State state, class_2561 title, class_2561 text) {
    }

    public record JourneyInterruptData(State state, class_2561 title, class_2561 text, String narratorText) {
    }

    public record ReachNextStopData(State state, class_2561 infoText, String narratorText, TransferState transferState) {
    }

    public static enum TransferState {
        NONE,
        DEFAULT,
        CONNECTION_MISSED,
        CONNECTION_CANCELLED;

    }

    public record AnnounceNextStopData(State state, class_2561 infoText, String narratorText, boolean isTransfer) {
    }

    public record FinishJourneyData(State state, class_2561 infoText) {
    }

    public record ContinueData(State state) {
    }

    public record JourneyBeginData(State state, class_2561 infoText, String narratorText) {
    }
}

