/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class TrainStationAlias {
    private static final String NBT_ALIAS_NAME = "AliasName";
    private static final String NBT_STATION_LIST = "Stations";
    private static final String NBT_STATION_MAP = "StationData";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_STATION_ENTRY_NAME = "Name";
    protected AliasName aliasName;
    protected Map<String, StationInfo> stations = new HashMap<String, StationInfo>();
    protected String lastEditorName = null;
    protected long lastEditedTime = 0L;

    protected TrainStationAlias(AliasName aliasName, Map<String, StationInfo> initialValues, String lastEditorName, long lastEditedTime) {
        this(aliasName, initialValues);
        this.lastEditorName = lastEditorName;
        this.lastEditedTime = lastEditedTime;
    }

    public TrainStationAlias(AliasName aliasName, Map<String, StationInfo> initialValues) {
        this(aliasName);
        this.stations.putAll(initialValues);
    }

    public TrainStationAlias(AliasName aliasName) {
        this.aliasName = aliasName;
    }

    public TrainStationAlias copy() {
        return new TrainStationAlias(new AliasName(this.getAliasName().get()), new HashMap<String, StationInfo>(this.getAllStations()));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        if (this.aliasName == null) {
            return nbt;
        }
        nbt.method_10566(NBT_ALIAS_NAME, (class_2520)this.getAliasName().toNbt());
        if (this.lastEditorName != null) {
            nbt.method_10582(NBT_LAST_EDITOR, this.getLastEditorName());
        }
        nbt.method_10544(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        class_2499 stationsList = new class_2499();
        this.stations.forEach((key, value) -> {
            class_2487 entry = new class_2487();
            entry.method_10582(NBT_STATION_ENTRY_NAME, key);
            value.writeNbt(entry);
            stationsList.add((Object)entry);
        });
        nbt.method_10566(NBT_STATION_MAP, (class_2520)stationsList);
        return nbt;
    }

    public static TrainStationAlias fromNbt(class_2487 nbt) {
        if (!nbt.method_10545(NBT_ALIAS_NAME)) {
            return new TrainStationAlias(AliasName.of("null"));
        }
        AliasName name = AliasName.fromNbt(nbt.method_10562(NBT_ALIAS_NAME));
        String lastEditorName = nbt.method_10545(NBT_LAST_EDITOR) ? nbt.method_10558(NBT_LAST_EDITOR) : null;
        long lastEditedTime = nbt.method_10537(NBT_LAST_EDITED_TIME);
        Map<String, StationInfo> stations = nbt.method_10545(NBT_STATION_LIST) ? nbt.method_10554(NBT_STATION_LIST, 8).stream().map(x -> ((class_2519)x).method_10714()).collect(Collectors.toMap(x -> x, x -> StationInfo.empty())) : (nbt.method_10545(NBT_STATION_MAP) ? nbt.method_10554(NBT_STATION_MAP, 10).stream().map(x -> (class_2487)x).collect(Collectors.toMap(x -> x.method_10558(NBT_STATION_ENTRY_NAME), x -> StationInfo.fromNbt(x))) : new IdentityHashMap<String, StationInfo>());
        return new TrainStationAlias(name, stations, lastEditorName, lastEditedTime);
    }

    public String getLastEditorName() {
        return this.lastEditorName;
    }

    public void updateLastEdited(String name) {
        this.lastEditorName = name;
        this.lastEditedTime = new Date().getTime();
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public AliasName getAliasName() {
        return this.aliasName;
    }

    public void updateInfoForStation(String station, StationInfo info) {
        if (this.stations.containsKey(station)) {
            this.stations.replace(station, info);
        }
    }

    public void add(String station, StationInfo info) {
        if (!this.stations.containsKey(station)) {
            this.stations.put(station, info);
        }
    }

    public void addAll(Map<String, StationInfo> stations) {
        stations.forEach((key, value) -> {
            if (!this.stations.containsKey(key)) {
                this.stations.put((String)key, (StationInfo)value);
            }
        });
    }

    public boolean contains(String station) {
        String regex = station.isBlank() ? station : "\\Q" + station.replace("*", "\\E.*\\Q");
        return this.stations.keySet().stream().anyMatch(x -> x.matches(regex));
    }

    public Set<String> getAllStationNames() {
        return this.stations.keySet();
    }

    public Map<String, StationInfo> getAllStations() {
        return this.stations;
    }

    public StationInfo getInfoForStation(String stationName) {
        return this.stations.containsKey(stationName) ? this.stations.get(stationName) : StationInfo.empty();
    }

    public void setName(AliasName name) {
        this.aliasName = name;
    }

    public void remove(String station) {
        this.stations.remove(station);
    }

    public String toString() {
        return String.format("%s", this.getAliasName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainStationAlias) {
            TrainStationAlias alias = (TrainStationAlias)obj;
            return this.getAliasName().equals(alias.getAliasName()) && this.getAllStationNames().size() == alias.getAllStationNames().size() && this.getAllStationNames().stream().allMatch(x -> alias.contains((String)x));
        }
        return false;
    }

    public int hashCode() {
        return 7 * Objects.hash(this.aliasName);
    }

    public void update(TrainStationAlias newData) {
        this.aliasName = newData.aliasName;
        this.stations = newData.stations;
        this.lastEditedTime = newData.lastEditedTime;
        this.lastEditorName = newData.lastEditorName;
    }

    public record StationInfo(String platform) {
        private static final String NBT_PLATFORM = "Platform";

        public static StationInfo empty() {
            return new StationInfo("");
        }

        public void writeNbt(class_2487 nbt) {
            nbt.method_10582(NBT_PLATFORM, this.platform());
        }

        public static StationInfo fromNbt(class_2487 nbt) {
            return new StationInfo(nbt.method_10558(NBT_PLATFORM));
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof StationInfo) {
                StationInfo other = (StationInfo)obj;
                return this.platform().equals(other.platform());
            }
            return false;
        }
    }
}

