/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.RoutePart;
import de.mrjulsen.crn.data.TrainStop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Route {
    private Collection<RoutePart> parts = new ArrayList<RoutePart>();
    private final long refreshTime;

    public Route(Collection<RoutePart> initialValues, long refreshTime) {
        this(refreshTime);
        this.parts.addAll(initialValues);
    }

    public Route(long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public void addPart(RoutePart part) {
        if (!this.contains(part)) {
            this.parts.add(part);
        }
    }

    public boolean isEmpty() {
        return this.parts.size() <= 0;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public boolean contains(RoutePart part) {
        return this.parts.contains(part);
    }

    public Collection<RoutePart> getParts() {
        return this.parts;
    }

    public int getStationCount() {
        return this.parts.stream().mapToInt(x -> x.getStationCount(false)).sum() + this.parts.size() + 1;
    }

    public int getTransferCount() {
        return this.getParts().size() - 1;
    }

    public int getTotalDuration() {
        return this.getEndStation().getPrediction().getTicks() - this.getStartStation().getPrediction().getTicks();
    }

    public TrainStop getStartStation() {
        return this.parts.stream().findFirst().get().getStartStation();
    }

    public TrainStop getEndStation() {
        return this.parts.stream().reduce((a, b) -> b).get().getEndStation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Route) {
            Route other = (Route)obj;
            return this.getParts().size() == other.getParts().size() && this.getParts().stream().allMatch(x -> other.getParts().stream().anyMatch(y -> y.equals(x)));
        }
        return false;
    }

    public boolean exactEquals(Object obj, boolean respectOrder, boolean respectTrains) {
        if (obj instanceof Route) {
            Route other = (Route)obj;
            if (this.getParts().size() != other.getParts().size()) {
                return false;
            }
            RoutePart[] a = (RoutePart[])this.getParts().toArray(RoutePart[]::new);
            RoutePart[] b = (RoutePart[])other.getParts().toArray(RoutePart[]::new);
            for (int i = 0; i < a.length; ++i) {
                if ((!respectOrder || a[i].exactEquals(b[i], respectTrains)) && (respectOrder || a[i].equals(b[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toName() {
        return String.format("%s - %s", this.parts.stream().findFirst().get().getStartStation().getStationAlias().getAliasName(), this.parts.stream().reduce((a, b) -> b).get().getEndStation().getStationAlias().getAliasName());
    }

    public String toString() {
        return Arrays.toString(this.getParts().toArray());
    }
}

