/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.SearchSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModDestinationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.RouteEntryOverviewWidget;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.NavigationRequestPacket;
import de.mrjulsen.crn.network.packets.cts.NearestStationRequestPacket;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import org.lwjgl.opengl.GL11;

public class NavigatorScreen
extends DLScreen
implements IJourneyListenerClient {
    private static final class_2960 GUI = new class_2960("createrailwaysnavigator", "textures/gui/navigator.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 10;
    private static final int ENTRY_SPACING = 4;
    private final int AREA_X = 16;
    private final int AREA_Y = 67;
    private final int AREA_W = 220;
    private final int AREA_H = 143;
    private int guiLeft;
    private int guiTop;
    private boolean initialized = false;
    private int angle = 0;
    private DLCreateIconButton locationButton;
    private DLCreateIconButton searchButton;
    private DLCreateIconButton goToTopButton;
    private DLCreateIconButton globalSettingsButton;
    private DLCreateIconButton searchSettingsButton;
    private DLEditBox fromBox;
    private DLEditBox toBox;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private ModDestinationSuggestions destinationSuggestions;
    private GuiAreaDefinition switchButtonsArea;
    private final WidgetsCollection routesCollection = new WidgetsCollection();
    private SimpleRoute[] routes;
    private String stationFrom = "";
    private String stationTo = "";
    private long lastRefreshedTime;
    private final NavigatorScreen instance;
    private final class_1937 level;
    private final class_327 shadowlessFont;
    private final UUID clientId = UUID.randomUUID();
    private boolean isLoadingRoutes = false;
    private boolean generatingRouteEntries = false;
    private final class_5250 searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
    private final class_5250 noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
    private final class_5250 notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
    private final class_5250 errorTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.error_title");
    private final class_5250 startEndEqualText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_equal");
    private final class_5250 startEndNullText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_null");
    private final class_5250 tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
    private final class_5250 tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
    private final class_5250 tooltipSwitch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.switch.tooltip");
    private final class_5250 tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
    private final class_5250 tooltipSearchSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search_settings.tooltip");

    public NavigatorScreen(class_1937 level) {
        super((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.title"));
        this.instance = this;
        this.level = level;
        this.shadowlessFont = new NoShadowFontWrapper(class_310.method_1551().field_1772);
    }

    @Override
    public UUID getJourneyListenerClientId() {
        return this.clientId;
    }

    private void generateRouteEntries() {
        this.generatingRouteEntries = true;
        this.routesCollection.components.clear();
        if (this.routes != null && this.routes.length > 0) {
            for (int i = 0; i < this.routes.length; ++i) {
                SimpleRoute route = this.routes[i];
                RouteEntryOverviewWidget w = new RouteEntryOverviewWidget(this.instance, this.level, this.lastRefreshedTime, this.guiLeft + 26, this.guiTop + 67 + 10 + i * 58, route, btn -> {});
                this.routesCollection.components.add(w);
            }
        }
        this.generatingRouteEntries = false;
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().method_1887("");
        }
        this.destinationSuggestions = null;
    }

    private void setLastRefreshedTime() {
        this.lastRefreshedTime = this.level.method_8532();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        JourneyListenerManager.getInstance().removeClientListenerForAll(this);
        super.method_25419();
    }

    private void switchButtonClick() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        String fromInput = this.fromBox.method_1882();
        String toInput = this.toBox.method_1882();
        this.fromBox.method_1852(toInput);
        this.toBox.method_1852(fromInput);
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = false;
        this.guiLeft = this.field_22789 / 2 - 127;
        this.guiTop = this.field_22790 / 2 - 123;
        this.switchButtonsArea = new GuiAreaDefinition(this.guiLeft + 190, this.guiTop + 34, 11, 12);
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSwitch).assignedTo(this.switchButtonsArea));
        this.locationButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 208, this.guiTop + 20, 18, 18, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                long id = InstanceManager.registerClientNearestStationResponseAction(result -> {
                    if (result.aliasName.isPresent()) {
                        NavigatorScreen.this.fromBox.method_1852(result.aliasName.get().getAliasName().get());
                    }
                });
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NearestStationRequestPacket(id, ((NavigatorScreen)NavigatorScreen.this).field_22787.field_1724.method_19538()));
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipLocation).assignedTo((class_339)this.locationButton));
        this.searchButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 208, this.guiTop + 42, 18, 18, (ScreenElement)AllIcons.I_MTD_SCAN){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                if (NavigatorScreen.this.stationFrom == null || NavigatorScreen.this.stationTo == null || NavigatorScreen.this.stationFrom.isBlank() || NavigatorScreen.this.stationTo.isBlank()) {
                    class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)NavigatorScreen.this.errorTitle, (class_2561)NavigatorScreen.this.startEndNullText));
                    return;
                }
                if (NavigatorScreen.this.stationFrom.equals(NavigatorScreen.this.stationTo)) {
                    class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)NavigatorScreen.this.errorTitle, (class_2561)NavigatorScreen.this.startEndEqualText));
                    return;
                }
                NavigatorScreen.this.isLoadingRoutes = true;
                long id = InstanceManager.registerClientNavigationResponseAction((routes, data) -> {
                    JourneyListenerManager.getInstance().removeClientListenerForAll(NavigatorScreen.this.instance);
                    NavigatorScreen.this.instance.routes = (SimpleRoute[])routes.toArray(SimpleRoute[]::new);
                    NavigatorScreen.this.setLastRefreshedTime();
                    NavigatorScreen.this.generateRouteEntries();
                    NavigatorScreen.this.isLoadingRoutes = false;
                    for (SimpleRoute route : NavigatorScreen.this.instance.routes) {
                        UUID listenerId = route.listen(NavigatorScreen.this.instance);
                        JourneyListenerManager.getInstance().get(listenerId, NavigatorScreen.this.instance).start();
                    }
                });
                NavigatorScreen.this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
                CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new NavigationRequestPacket(id, NavigatorScreen.this.stationFrom, NavigatorScreen.this.stationTo));
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSearch).assignedTo((class_339)this.searchButton));
        this.fromBox = this.addEditBox(this.guiLeft + 50, this.guiTop + 25, 157, 12, this.stationFrom, (class_2561)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationFrom = v;
            this.updateEditorSubwidgets(this.fromBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.fromBox.method_1880(25);
        this.fromBox.method_1868(0xFFFFFF);
        this.toBox = this.addEditBox(this.guiLeft + 50, this.guiTop + 47, 157, 12, this.stationTo, (class_2561)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationTo = v;
            this.updateEditorSubwidgets(this.toBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.toBox.method_1880(25);
        this.toBox.method_1868(0xFFFFFF);
        this.goToTopButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 255 - 10, this.guiTop + 67, 18, 18, (ScreenElement)AllIcons.I_PRIORITY_VERY_HIGH){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                NavigatorScreen.this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)Constants.TOOLTIP_GO_TO_TOP).assignedTo((class_339)this.goToTopButton));
        if (this.field_22787.field_1724.method_5687(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue())) {
            this.globalSettingsButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 43, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()){

                public void method_25348(double mouseX, double mouseY) {
                    super.method_25348(mouseX, mouseY);
                    NavigatorScreen.this.field_22787.method_1507((class_437)new GlobalSettingsScreen(NavigatorScreen.this.level, (class_437)NavigatorScreen.this.instance));
                }
            });
            this.addTooltip(DLTooltip.of((class_5348)this.tooltipGlobalSettings).assignedTo((class_339)this.globalSettingsButton));
        }
        this.searchSettingsButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.FILTER.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                NavigatorScreen.this.field_22787.method_1507((class_437)new SearchSettingsScreen(NavigatorScreen.this.level, (class_437)NavigatorScreen.this.instance));
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSearchSettings).assignedTo((class_339)this.searchSettingsButton));
        this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 255 - 42, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_MTD_CLOSE){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                NavigatorScreen.this.method_25419();
            }
        });
        this.generateRouteEntries();
        this.initialized = true;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModDestinationSuggestions(this.field_22787, (class_437)this, (class_342)field, this.field_22793, this.getViableStations(field), field.method_25364() + 2 + field.method_46427());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<TrainStationAlias> getViableStations(DLEditBox field) {
        return ClientTrainStationSnapshot.getInstance().getAllTrainStations().stream().map(x -> GlobalSettingsManager.getInstance().getSettingsData().getAliasFor((String)x)).distinct().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted((TrainStationAlias)x)).sorted((a, b) -> a.getAliasName().get().compareTo(b.getAliasName().get())).toList();
    }

    public void method_25393() {
        this.angle += 6;
        if (this.angle > 360) {
            this.angle = 0;
        }
        this.scroll.tickChaser();
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
            if (!this.toBox.method_20315() && !this.fromBox.method_20315()) {
                this.clearSuggestions();
            }
        }
        if (this.goToTopButton != null) {
            this.goToTopButton.field_22764 = this.routes != null && this.scroll.getValue() > 0.0f;
        }
        this.searchButton.field_22763 = !this.isLoadingRoutes;
        super.method_25393();
    }

    protected void startStencil(class_332 graphics, float x, float y, float w, float h) {
        RenderSystem.clear((int)1280, (boolean)class_310.field_1703);
        GL11.glDisable((int)2960);
        RenderSystem.stencilMask((int)-1);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(x, y, 0.0f);
        graphics.method_51448().method_22905(w, h, 1.0f);
        graphics.method_33284(0, 0, 1, 1, -100, -16777216, -16777216);
        graphics.method_51448().method_22909();
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }

    protected void endStencil() {
        GL11.glDisable((int)2960);
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.field_22787.method_1488();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((class_2960)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (class_5348)this.field_22785, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.method_8532() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.method_1727(timeString)), (int)(this.guiTop + 4), (class_5348)TextUtils.text((String)timeString), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (!this.isLoadingRoutes && !this.generatingRouteEntries) {
            if (this.routes == null) {
                GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (class_5348)this.notSearchedText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                ModGuiIcons.INFO.render(graphics, this.guiLeft + 127 - 8, this.guiTop + 123);
            } else if (this.routes.length <= 0) {
                GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (class_5348)this.noConnectionsText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                AllIcons.I_ACTIVE.render(graphics.graphics(), this.guiLeft + 127 - 8, this.guiTop + 123);
            } else {
                GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67), (int)220, (int)143);
                graphics.poseStack().method_46416(0.0f, scrollOffset, 0.0f);
                int start = (int)(Math.abs(scrollOffset + 10.0f) / 58.0f);
                int end = Math.min(this.routesCollection.components.size(), start + 2 + 2);
                for (int i = start; i < end; ++i) {
                    ((class_339)this.routesCollection.components.get(i)).method_25394(graphics.graphics(), pMouseX, (int)((float)pMouseY - scrollOffset), pPartialTick);
                }
                GuiUtils.disableScissor((Graphics)graphics);
                GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
                GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 67 + 143 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
                double maxHeight = 10 + this.routes.length * 58 + 10;
                double aH = 144.0;
                if (aH / maxHeight < 1.0) {
                    int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
                    int startY = this.guiTop + 67 + (int)(143.0 * ((double)Math.abs(scrollOffset) / maxHeight));
                    GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
                }
            }
        } else {
            double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
            double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
            GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 127), (int)(this.guiTop + 32 + 123), (class_5348)this.searchingText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            AllIcons.I_MTD_SCAN.render(graphics.graphics(), (int)((double)(this.guiLeft + 127 - 8) + offsetX), (int)((double)(this.guiTop + 123) + offsetY));
        }
        if (this.switchButtonsArea.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.switchButtonsArea.getLeft(), (int)this.switchButtonsArea.getTop(), (int)this.switchButtonsArea.getWidth(), (int)this.switchButtonsArea.getHeight(), (int)0x3FFFFFFF);
        }
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_46416(0.0f, 0.0f, 500.0f);
            this.destinationSuggestions.render(graphics.graphics(), mouseX, mouseY);
            graphics.poseStack().method_22909();
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        float scrollOffset = this.scroll.getValue();
        if (this.switchButtonsArea.isInBounds(pMouseX, pMouseY)) {
            this.switchButtonClick();
        }
        if (super.method_25402(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 67) && pMouseY < (double)(this.guiTop + 67 + 143)) {
            this.routesCollection.performForEach(x -> x.method_25402(pMouseX, pMouseY + (double)scrollOffset, pButton));
        }
        return false;
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, class_3532.method_15350((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -143.0f;
        if (this.routes != null && this.routes.length > 0) {
            max += (float)(10 + this.routes.length * 58 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = class_3532.method_15363((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }
}

