/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public class BERPlatformSimple
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private static final String keyTrainDeparture = "gui.createrailwaysnavigator.route_overview.notification.journey_begins";
    private static final String keyTrainDepartureWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.journey_begins_with_platform";
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private Collection<UUID> lastTrainOrder = new ArrayList<UUID>();

    @Override
    public boolean isSingleLined() {
        return true;
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent) {
    }

    @Override
    public void renderAdditional(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent, float pPartialTicks, class_4587 pPoseStack, class_4597 pBufferSource, int pPackedLight, int pOverlay, Boolean backSide) {
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        List<DeparturePrediction.SimpleDeparturePrediction> preds = blockEntity.getPredictions().stream().filter(x -> x.departureTicks() < (Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).toList();
        List<UUID> uuidOrder = preds.stream().map(x -> x.trainId()).toList();
        if (reason == IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED && this.lastTrainOrder.equals(uuidOrder)) {
            return;
        }
        this.lastTrainOrder = uuidOrder;
        parent.labels.clear();
        byte displayWidth = blockEntity.getXSizeScaled();
        float maxWidth = displayWidth * 16 - 6;
        parent.labels.add(new BERText(parent.getFontUtils(), () -> {
            ArrayList<class_5250> texts = new ArrayList<class_5250>();
            texts.add(ELanguage.translate(keyTime, TimeUtils.parseTime((long)((int)(blockEntity.method_10997().method_8532() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
            texts.addAll(preds.stream().map(x -> {
                String timeString = switch (blockEntity.getTimeDisplay()) {
                    case AdvancedDisplaySource.ETimeDisplay.ETA -> ModUtils.timeRemainingString(x.departureTicks());
                    default -> TimeUtils.parseTime((long)((int)(blockEntity.getLastRefreshedTime() % 24000L + 6000L + (long)x.departureTicks())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
                };
                if (x.stationInfo().platform() == null || x.stationInfo().platform().isBlank()) {
                    return ELanguage.translate(keyTrainDeparture, x.trainName(), x.scheduleTitle(), timeString);
                }
                return ELanguage.translate(keyTrainDepartureWithPlatform, x.trainName(), x.scheduleTitle(), timeString, x.stationInfo().platform());
            }).toList());
            return List.of(TextUtils.concatWithStarChars((class_2561[])((class_2561[])texts.toArray(class_2561[]::new))));
        }, 0.0f).withIsCentered(false).withMaxWidth(maxWidth, true).withStretchScale(0.75f, 0.75f).withStencil(0.0f, maxWidth).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withTicksPerPage(100).withRefreshRate(16).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 5.5f, 0.0f, 1.0f, 0.75f)).build());
    }
}

