/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.base;

import de.mrjulsen.mcdragonlib.client.util.FontUtils;
import de.mrjulsen.mcdragonlib.mixin.BakedGlyphAccessor;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_379;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;

public class BERText {
    private static final byte CHAR_SIZE = 8;
    private final FontUtils fontUtils;
    private final float xOffset;
    private Supplier<List<class_2561>> textData;
    private float minX = 0.0f;
    private float maxX = Float.MAX_VALUE;
    private float minStretchScale = 1.0f;
    private float maxStretchScale = 1.0f;
    private float maxWidth = Float.MAX_VALUE;
    private boolean forceMaxWidth = false;
    private float scrollSpeed = 0.0f;
    private boolean centered = false;
    private int color = -1;
    private int ticksPerPage = 200;
    private int refreshRate = 0;
    private Consumer<BERText> onUpdate;
    private TextTransformation predefinedTextTransformation = null;
    private TextDataCache cache;
    private float scrollXOffset = 0.0f;
    private int refreshTimer = 0;
    private int currentTicks = 0;
    private int currentIndex = 0;
    private List<class_2561> texts;

    public BERText(FontUtils fontUtils, class_2561 text, float xOffset) {
        this.fontUtils = fontUtils;
        this.textData = () -> List.of(text);
        this.xOffset = xOffset;
    }

    public BERText(FontUtils fontUtils, Supplier<List<class_2561>> texts, float xOffset) {
        this.fontUtils = fontUtils;
        this.textData = texts;
        this.xOffset = xOffset;
    }

    public BERText withStencil(float minX, float maxX) {
        this.minX = minX;
        this.maxX = maxX;
        return this;
    }

    public BERText withStretchScale(float minScale, float maxScale) {
        this.minStretchScale = minScale;
        this.maxStretchScale = maxScale;
        return this;
    }

    public BERText withMaxWidth(float maxWidth, boolean force) {
        this.maxWidth = maxWidth;
        this.forceMaxWidth = force;
        return this;
    }

    public BERText withIsCentered(boolean b) {
        this.centered = b;
        return this;
    }

    public BERText withCanScroll(boolean b, float scrollingSpeed) {
        this.scrollSpeed = b ? scrollingSpeed : 0.0f;
        return this;
    }

    public BERText withColor(int color) {
        this.color = color;
        return this;
    }

    public BERText withTicksPerPage(int ticks) {
        this.ticksPerPage = ticks;
        return this;
    }

    public BERText withRefreshRate(int ticks) {
        this.refreshRate = ticks;
        return this;
    }

    public BERText withPredefinedTextTransformation(TextTransformation transformation) {
        this.predefinedTextTransformation = transformation;
        return this;
    }

    public BERText withUpdateFunc(Consumer<BERText> onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public BERText build() {
        this.fetchCurrentText();
        this.calc(false);
        this.scrollXOffset = this.cache.maxWidthScaled();
        return this;
    }

    public FontUtils getFontUtils() {
        return this.fontUtils;
    }

    private void fetchCurrentText() {
        this.texts = this.textData.get();
    }

    public class_2561 getCurrentText() {
        return this.texts.get(this.currentIndex);
    }

    public List<class_2561> getTexts() {
        return this.texts;
    }

    public int getTicksPerPage() {
        return this.ticksPerPage;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMinStretchScale() {
        return this.minStretchScale;
    }

    public float getMaxStretchScale() {
        return this.maxStretchScale;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public boolean forceMaxWidth() {
        return this.forceMaxWidth;
    }

    public boolean canScroll() {
        return this.scrollSpeed > 0.0f;
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public float getTextWidth() {
        return this.getFontUtils().font.method_27525((class_5348)this.getCurrentText());
    }

    public float getScaledTextWidth() {
        return this.getTextWidth() * this.cache.textXScale();
    }

    public int getColor() {
        return this.color;
    }

    public void recalc() {
        this.calc(false);
    }

    protected void calc(boolean callUpdate) {
        boolean mustScroll;
        float textWidth = this.getFontUtils().font.method_27525((class_5348)this.getCurrentText());
        float rawXScale = this.getMaxWidth() / textWidth;
        float finalXScale = MathUtils.clamp((float)rawXScale, (float)this.getMinStretchScale(), (float)this.getMaxStretchScale());
        boolean bl = mustScroll = rawXScale < this.getMinStretchScale();
        if (this.forceMaxWidth() && mustScroll) {
            finalXScale = this.getMaxStretchScale();
        }
        float minX = this.getMinX() / finalXScale;
        float maxWidthScaled = this.getMaxWidth() / finalXScale;
        float maxX = Math.min(this.forceMaxWidth() ? maxWidthScaled : Float.MAX_VALUE, this.getMaxX() / finalXScale);
        float xOffset = this.getXOffset() + (this.isCentered() ? maxWidthScaled / 2.0f - textWidth / 2.0f : 0.0f);
        this.cache = new TextDataCache(finalXScale, minX, maxX, xOffset, maxWidthScaled, textWidth, this.forceMaxWidth() && mustScroll && this.canScroll());
        if (callUpdate && this.onUpdate != null) {
            this.onUpdate.accept(this);
        }
    }

    public void render(class_4587 pPoseStack, class_4597 pBufferSource, int pPackedLight) {
        this.getFontUtils().reset();
        pPoseStack.method_22903();
        if (this.predefinedTextTransformation != null) {
            pPoseStack.method_46416(this.predefinedTextTransformation.x(), this.predefinedTextTransformation.y(), this.predefinedTextTransformation.z());
            pPoseStack.method_22905(this.predefinedTextTransformation.xScale(), this.predefinedTextTransformation.yScale(), 1.0f);
        }
        pPoseStack.method_22903();
        pPoseStack.method_22905(this.cache.textXScale(), 1.0f, 1.0f);
        this.renderTextInBounds(pPoseStack, this.getFontUtils(), pBufferSource, this.getCurrentText(), pPackedLight, this.cache.mustScroll ? this.scrollXOffset : this.cache.xOffset(), this.cache.minX(), this.cache.maxX(), this.getColor());
        pPoseStack.method_22909();
        pPoseStack.method_22909();
    }

    private void renderTextInBounds(class_4587 pPoseStack, FontUtils fontUtils, class_4597 pBufferSource, class_2561 text, int pPackedLight, float xOffset, float xLeft, float xRight, int color) {
        if (xRight <= xLeft) {
            return;
        }
        pPoseStack.method_22903();
        pPoseStack.method_46416(xLeft + (xOffset > 0.0f ? xOffset : 0.0f), 0.0f, 0.0f);
        class_327 class_3272 = fontUtils.font;
        Objects.requireNonNull(class_3272);
        class_327.class_5232 sro = new class_327.class_5232(class_3272, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.method_23760().method_23761(), class_327.class_6415.field_33993, pPackedLight);
        float newX = xOffset;
        float glyphTranslation = 0.0f;
        float charSize = 8 + (text.method_10866().method_10984() ? 1 : 0);
        for (int i = 0; i < text.getString().length(); ++i) {
            float diff;
            char charCode = text.getString().charAt(i);
            class_379 info = fontUtils.fontSet.method_2011((int)charCode, false);
            float glyphWidth = info.method_16798(text.method_10866().method_10984());
            float oldX = newX;
            if ((newX += glyphWidth) > xLeft && oldX < xLeft) {
                diff = xLeft - oldX;
                BakedGlyphAccessor glyph = fontUtils.getGlyphAccessor((int)charCode);
                float glyphUVDiff = glyph.getU1() - glyph.getU0();
                float scale = 1.0f / charSize * diff;
                float sub = glyphUVDiff * scale;
                fontUtils.pushUV((int)charCode);
                glyph.setU0(glyph.getU0() + sub);
                pPoseStack.method_22903();
                float invScale = 1.0f - scale;
                pPoseStack.method_22905(invScale, 1.0f, 1.0f);
                class_327 class_3273 = fontUtils.font;
                Objects.requireNonNull(class_3273);
                class_327.class_5232 sro2 = new class_327.class_5232(class_3273, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.method_23760().method_23761(), class_327.class_6415.field_33993, pPackedLight);
                class_5223.method_27479((String)String.valueOf(charCode), (class_2583)text.method_10866(), (class_5224)sro2);
                pPoseStack.method_22909();
                fontUtils.popUV((int)charCode);
                pPoseStack.method_46416(glyphWidth - charSize * scale, 0.0f, 0.0f);
                continue;
            }
            if (newX > xRight) {
                diff = newX - xRight;
                float charRightSpace = charSize - glyphWidth;
                float totalDiff = diff + charRightSpace;
                BakedGlyphAccessor glyph = fontUtils.getGlyphAccessor((int)charCode);
                float glyphUVDiff = glyph.getU1() - glyph.getU0();
                float scale = 1.0f / charSize * totalDiff;
                float sub = glyphUVDiff * scale;
                fontUtils.pushUV((int)charCode);
                glyph.setU1(glyph.getU1() - sub);
                pPoseStack.method_22903();
                float invScale = 1.0f - scale;
                pPoseStack.method_22905(invScale, 1.0f, 1.0f);
                pPoseStack.method_46416(glyphTranslation / invScale, 0.0f, 0.0f);
                class_327 class_3274 = fontUtils.font;
                Objects.requireNonNull(class_3274);
                class_327.class_5232 sro2 = new class_327.class_5232(class_3274, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.method_23760().method_23761(), class_327.class_6415.field_33993, pPackedLight);
                class_5223.method_27479((String)String.valueOf(charCode), (class_2583)text.method_10866(), (class_5224)sro2);
                pPoseStack.method_22909();
                fontUtils.popUV((int)charCode);
                break;
            }
            if (!(oldX >= xLeft) || !(newX <= xRight)) continue;
            class_5223.method_27479((String)String.valueOf(charCode), (class_2583)text.method_10866(), (class_5224)sro);
            glyphTranslation += glyphWidth;
        }
        pPoseStack.method_22909();
    }

    public void tick() {
        boolean multiText;
        if (this.refreshRate > 0) {
            ++this.refreshTimer;
            if ((this.refreshTimer %= this.refreshRate) == 0) {
                this.fetchCurrentText();
                this.calc(true);
            }
        }
        boolean bl = multiText = this.getTexts().size() > 1;
        if (this.cache.mustScroll()) {
            this.scrollXOffset -= this.getScrollSpeed() / this.getMaxStretchScale();
            if (this.scrollXOffset < -this.cache.textWidth()) {
                this.scrollXOffset = this.cache.maxWidthScaled();
                if (multiText) {
                    ++this.currentIndex;
                    this.fetchCurrentText();
                    this.currentIndex %= this.getTexts().size();
                    this.calc(true);
                }
            }
        } else if (multiText) {
            ++this.currentTicks;
            if ((this.currentTicks %= this.getTicksPerPage()) == 0) {
                ++this.currentIndex;
                this.fetchCurrentText();
                this.currentIndex %= this.getTexts().size();
                this.calc(true);
            }
        }
    }

    public record TextTransformation(float x, float y, float z, float xScale, float yScale) {
    }

    protected record TextDataCache(float textXScale, float minX, float maxX, float xOffset, float maxWidthScaled, float textWidth, boolean mustScroll) {
    }
}

