/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_3542;
import net.minecraft.class_5250;

public class AdvancedDisplaySource
extends DisplaySource {
    public static final String NBT_ADVANCED_DISPLAY = "AdvancedDisplay";
    public static final String NBT_FILTER = "Filter";
    public static final String NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    public static final String NBT_PLATFORM_WIDTH = "PlatformWidth";
    public static final String NBT_TIME_DISPLAY_TYPE = "TimeDisplay";

    public List<class_5250> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        return EMPTY;
    }

    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        context.sourceConfig().method_10556(NBT_ADVANCED_DISPLAY, true);
        return List.of();
    }

    protected String getTranslationKey() {
        return "advanced_display";
    }

    public void populateData(DisplayLinkContext context) {
        class_2487 conf = context.sourceConfig();
        if (!conf.method_10545(NBT_TRAIN_NAME_WIDTH)) {
            conf.method_10569(NBT_TRAIN_NAME_WIDTH, 16);
        }
        if (!conf.method_10545(NBT_PLATFORM_WIDTH)) {
            conf.method_10569(NBT_PLATFORM_WIDTH, -1);
        }
        if (!conf.method_10545(NBT_TIME_DISPLAY_TYPE)) {
            conf.method_10569(NBT_TIME_DISPLAY_TYPE, (int)ETimeDisplay.ABS.getId());
        }
        if (conf.method_10545(NBT_FILTER)) {
            return;
        }
        GlobalStation station = CRNPlatformSpecific.getStationFromBlockEntity(context.getSourceBlockEntity());
        if (station == null) {
            return;
        }
        conf.method_10582(NBT_FILTER, station.name);
    }

    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine) {
            builder.addTextInput(0, 137, (e, t) -> {
                e.method_1852("");
                t.withTooltip((List)ImmutableList.of((Object)Lang.translateDirect((String)"display_source.station_summary.filter", (Object[])new Object[0]).method_27694(s -> s.method_36139(5476833)), (Object)Lang.translateDirect((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})));
            }, NBT_FILTER);
            return;
        }
        builder.addScrollInput(0, 43, (si, l) -> {
            si.titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width.description")).withRange(0, 65).withShiftStep(4);
            si.setState(16);
            l.withSuffix("px");
        }, NBT_TRAIN_NAME_WIDTH);
        builder.addScrollInput(47, 43, (si, l) -> {
            si.titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width.description")).withRange(-1, 65).withShiftStep(4);
            si.setState(16);
            si.format(val -> {
                if (val >= 0) {
                    return TextUtils.text((String)(String.valueOf(val) + "px"));
                }
                return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
            });
        }, NBT_PLATFORM_WIDTH);
        builder.addSelectionScrollInput(94, 43, (si, l) -> si.forOptions(Arrays.stream(ETimeDisplay.values()).map(x -> TextUtils.translate((String)x.getValueInfoTranslationKey("createrailwaysnavigator"))).toList()).titled(TextUtils.translate((String)"enum.createrailwaysnavigator.time_display")).addHint(TextUtils.translate((String)"enum.createrailwaysnavigator.time_display.description")).format(val -> TextUtils.translate((String)ETimeDisplay.getById(val).getValueTranslationKey("createrailwaysnavigator"))).setState((int)ETimeDisplay.ABS.getId()), NBT_TIME_DISPLAY_TYPE);
    }

    public static enum ETimeDisplay implements class_3542,
    ITranslatableEnum
    {
        ABS(0, "abs"),
        ETA(1, "eta");

        private byte id;
        private String name;

        private ETimeDisplay(byte id, String name) {
            this.id = id;
            this.name = name;
        }

        public byte getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static ETimeDisplay getById(int id) {
            return Arrays.stream(ETimeDisplay.values()).filter(x -> x.getId() == id).findFirst().orElse(ABS);
        }

        public String getEnumName() {
            return "time_display";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public String method_15434() {
            return this.getName();
        }
    }
}

