/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.blocks.PoweredEngineShaftBlock;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineValueBox;
import com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class HugeDieselEngineBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
SidedStorageBlockEntity {
    public WeakReference<PoweredEngineShaftBlockEntity> target = new WeakReference<Object>(null);
    public SmartFluidTankBehaviour tank;
    int partialSecond;
    boolean validFuel;
    float oldAngle = 0.0f;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;

    public HugeDieselEngineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.tank.write(tag, clientPacket);
        tag.method_10569("PartialSecond", this.partialSecond);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.tank.read(tag, clientPacket);
        this.partialSecond = tag.method_10550("PartialSecond");
    }

    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public void tick() {
        super.tick();
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        this.validFuel = (Boolean)this.method_11010().method_11654((class_2769)DieselGeneratorBlock.POWERED) != false ? false : FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        ++this.partialSecond;
        if (this.partialSecond >= 20) {
            this.partialSecond = 0;
            if (this.validFuel) {
                if (this.tank.getPrimaryHandler().getFluid().getAmount() >= (long)FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid())) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (long)(this.tank.getPrimaryHandler().getFluid().getAmount() - (long)FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()))));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
        if (this.validFuel) {
            float shaftR;
            if (shaft.movementDirection != 0 && shaft.movementDirection != (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? 1 : -1)) {
                shaft.removeGenerator(this.field_11867);
                this.onDirectionChanged();
                return;
            }
            shaft.update(this.field_11867, this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? 1 : -1, FuelTypeManager.getGeneratedStress((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()), FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()));
            if (!this.field_11863.field_9236) {
                return;
            }
            Float angle = this.getTargetAngle();
            if (angle == null) {
                return;
            }
            angle = Float.valueOf((angle = Float.valueOf((float)((double)(angle.floatValue() * 180.0f) / Math.PI))).floatValue() < 0.0f ? 360.0f - angle.floatValue() : angle.floatValue());
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING);
            float f = facing == class_2350.field_11043 ? 180.0f : (facing == class_2350.field_11035 ? 0.0f : (facing == class_2350.field_11034 ? 0.0f : (facing == class_2350.field_11039 ? 180.0f : (shaftR = facing == class_2350.field_11033 ? 90.0f : -90.0f))));
            if ((this.oldAngle + shaftR) % 360.0f > (angle.floatValue() + shaftR) % 360.0f) {
                this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), SoundRegistry.DIESEL_ENGINE_SOUND.getMainEvent(), class_3419.field_15245, 1.0f, 1.0f, false);
            }
            this.oldAngle = angle.floatValue();
        } else {
            shaft.removeGenerator(this.field_11867);
        }
    }

    public PoweredEngineShaftBlockEntity getShaft() {
        PoweredEngineShaftBlockEntity shaft = (PoweredEngineShaftBlockEntity)((Object)this.target.get());
        if (shaft == null || shaft.method_11015() || !shaft.canBePoweredBy(this.field_11867)) {
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            class_2586 anyShaftAt = this.field_11863.method_8321(this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING), 2));
            class_2680 sState = this.field_11863.method_8320(this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING), 2));
            if (anyShaftAt instanceof PoweredEngineShaftBlockEntity) {
                PoweredEngineShaftBlockEntity ps;
                shaft = ps = (PoweredEngineShaftBlockEntity)anyShaftAt;
                this.target = new WeakReference<PoweredEngineShaftBlockEntity>(shaft);
            } else if (sState.method_26204() instanceof ShaftBlock && sState.method_11654((class_2769)RotatedPillarKineticBlock.AXIS) != ((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING)).method_10166()) {
                this.field_11863.method_8652(this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING), 2), PoweredEngineShaftBlock.getEquivalent(this.field_11863.method_8320(this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING), 2))), 3);
            }
        }
        return shaft;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour(this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (class_2561)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new HugeDieselEngineValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (long)100L);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    private void onDirectionChanged() {
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        shaft.engines.forEach((p, s) -> {
            class_2586 patt8225$temp = this.field_11863.method_8321(p);
            if (patt8225$temp instanceof HugeDieselEngineBlockEntity) {
                HugeDieselEngineBlockEntity be = (HugeDieselEngineBlockEntity)patt8225$temp;
                be.movementDirection.setValue(this.movementDirection.getValue());
            }
        });
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (((Boolean)this.method_11010().method_11654((class_2769)class_2746.method_11825((String)face.toString()))).booleanValue() && face.method_10166() != ((class_2350)this.method_11010().method_11654((class_2769)HugeDieselEngineBlock.FACING)).method_10166()) {
            return this.tank.getCapability();
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled() || !this.validFuel) {
            return false;
        }
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return false;
        }
        float stressBase = FuelTypeManager.getGeneratedStress((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid());
        if (class_3532.method_15347((float)stressBase, (float)0.0f)) {
            return false;
        }
        Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float stressTotal = Math.abs(stressBase);
        Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
    }

    @Environment(value=EnvType.CLIENT)
    public Float getTargetAngle() {
        class_2680 state = this.method_11010();
        if (!BlockRegistry.HUGE_DIESEL_ENGINE.has(state)) {
            return null;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)HugeDieselEngineBlock.FACING);
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        class_2350.class_2351 facingAxis = facing.method_10166();
        if (shaft == null) {
            return null;
        }
        class_2350.class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        float angle = KineticBlockEntityRenderer.getAngleForTe((KineticBlockEntity)shaft, (class_2338)shaft.method_11016(), (class_2350.class_2351)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.method_10179() && facingAxis == class_2350.class_2351.field_11048 ^ facing.method_10171() == class_2350.class_2352.field_11056) {
            angle *= -1.0f;
        }
        if (axis == class_2350.class_2351.field_11048 && facing == class_2350.field_11033) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }
}

