/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.manual_loading;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_5134;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.manual_loading.HandloadingTool;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;

public class RamRodItem
extends class_1792
implements HandloadingTool {
    public static final UUID BASE_ATTACK_KNOCKBACK_UUID = UUID.fromString("bfa4160d-4ef0-4069-9569-3dfd2765f1c6");
    private final Multimap<class_1320, class_1322> defaultModifiers;

    public RamRodItem(class_1792.class_1793 properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", 3.0, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", -3.5, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23722, (Object)new class_1322(BASE_ATTACK_KNOCKBACK_UUID, "Tool modifier", 2.5, class_1322.class_1323.field_6328));
        this.defaultModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.defaultModifiers : super.method_7844(slot);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos1;
        class_2680 state1;
        int i;
        class_1657 player = context.method_8036();
        if (player instanceof DeployerFakePlayer && !RamRodItem.deployersCanUse()) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 face = context.method_8038();
        class_2350 pushDirection = face.method_10153();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        int k = 0;
        if (level.method_8321(pos) instanceof IBigCannonBlockEntity) {
            class_2680 state = level.method_8320(pos.method_10093(face));
            if (state.method_51366()) {
                return class_1269.field_5811;
            }
            k = -1;
            for (int i2 = 0; i2 < RamRodItem.getReach(); ++i2) {
                IBigCannonBlockEntity cbe;
                class_3499.class_3501 info;
                class_2338 pos12 = pos.method_10079(pushDirection, i2);
                class_2680 state12 = level.method_8320(pos12);
                if (state12.method_26215()) continue;
                if (!RamRodItem.isValidLoadBlock(state12, level, pos12, pushDirection)) {
                    return class_1269.field_5814;
                }
                class_2586 class_25862 = level.method_8321(pos12);
                if (class_25862 instanceof IBigCannonBlockEntity && ((info = ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)class_25862).cannonBehavior())).block()).comp_1342() == null || info.comp_1342().method_26215())) continue;
                k = i2;
                break;
            }
            if (k == -1) {
                return class_1269.field_5811;
            }
        }
        ArrayList<class_3499.class_3501> toPush = new ArrayList<class_3499.class_3501>();
        boolean encounteredCannon = false;
        int maxCount = RamRodItem.getPushStrength();
        for (i = 0; i < maxCount + 1 && !(state1 = level.method_8320(pos1 = pos.method_10079(pushDirection, i + k))).method_26215(); ++i) {
            if (!RamRodItem.isValidLoadBlock(state1, level, pos1, pushDirection)) {
                return class_1269.field_5814;
            }
            class_2586 be = level.method_8321(pos1);
            if (be instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                encounteredCannon = true;
                class_3499.class_3501 info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
                if (info.comp_1342().method_26215()) break;
                toPush.add(info);
            } else {
                class_2487 tag = null;
                if (be != null) {
                    tag = be.method_38242();
                    tag.method_10551("x");
                    tag.method_10551("y");
                    tag.method_10551("z");
                }
                toPush.add(new class_3499.class_3501(class_2338.field_10980, state1, tag));
            }
            if (toPush.size() <= maxCount) continue;
            return class_1269.field_5814;
        }
        if (!encounteredCannon || toPush.isEmpty()) {
            return class_1269.field_5814;
        }
        for (i = toPush.size() - 1; i >= 0; --i) {
            pos1 = pos.method_10079(pushDirection, i + k);
            class_2586 be1 = level.method_8321(pos1);
            if (be1 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be1;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                be1.method_5431();
            } else {
                level.method_8650(pos1, false);
            }
            class_3499.class_3501 info = (class_3499.class_3501)toPush.get(i);
            class_2338 pos2 = pos1.method_10093(pushDirection);
            class_2586 class_25863 = level.method_8321(pos2);
            if (class_25863 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)class_25863;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).tryLoadingBlock(info);
                continue;
            }
            level.method_8652(pos2, info.comp_1342(), 67);
            class_2586 be2 = level.method_8321(pos2);
            class_2487 tag = info.comp_1343();
            if (be2 != null) {
                tag = NBTProcessors.process((class_2586)be2, (class_2487)tag, (boolean)false);
            }
            if (be2 == null || tag == null) continue;
            tag.method_10569("x", pos2.method_10263());
            tag.method_10569("y", pos2.method_10264());
            tag.method_10569("z", pos2.method_10260());
            be2.method_11014(tag);
        }
        level.method_8396(null, pos, class_3417.field_15226, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7322((float)toPush.size() * CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
        player.method_7357().method_7906((class_1792)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
        return class_1269.field_21466;
    }

    @Override
    public void onUseOnCannon(class_1657 player, class_1937 level, class_2338 startPos, class_2350 face, MountedBigCannonContraption contraption) {
        if (player instanceof DeployerFakePlayer && !RamRodItem.deployersCanUse()) {
            return;
        }
        class_2350 pushDirection = face.method_10153();
        int k = 0;
        if (contraption.presentBlockEntities.get(startPos) instanceof IBigCannonBlockEntity) {
            k = -1;
            for (int i = 0; i < RamRodItem.getReach(); ++i) {
                IBigCannonBlockEntity cbe;
                class_3499.class_3501 info1;
                class_2338 pos1 = startPos.method_10079(pushDirection, i);
                class_3499.class_3501 info = (class_3499.class_3501)contraption.getBlocks().get(pos1);
                if (info == null || !RamRodItem.isValidLoadBlock(info.comp_1342(), contraption, pos1, pushDirection)) {
                    return;
                }
                Object v = contraption.presentBlockEntities.get(pos1);
                if (v instanceof IBigCannonBlockEntity && (info1 = ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)v).cannonBehavior())).block()).comp_1342().method_26215()) continue;
                k = i;
                break;
            }
            if (k == -1) {
                return;
            }
        }
        ArrayList<class_3499.class_3501> toPush = new ArrayList<class_3499.class_3501>();
        boolean encounteredCannon = false;
        int maxCount = RamRodItem.getPushStrength();
        for (int i = 0; i < maxCount + 1; ++i) {
            class_2338 pos1 = startPos.method_10079(pushDirection, i + k);
            class_3499.class_3501 info = (class_3499.class_3501)contraption.getBlocks().get(pos1);
            if (info == null || !RamRodItem.isValidLoadBlock(info.comp_1342(), contraption, pos1, pushDirection)) {
                return;
            }
            Object v = contraption.presentBlockEntities.get(pos1);
            if (!(v instanceof IBigCannonBlockEntity)) break;
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            encounteredCannon = true;
            class_3499.class_3501 info1 = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
            if (info1.comp_1342().method_26215()) break;
            toPush.add(info1);
            if (toPush.size() <= maxCount) continue;
            return;
        }
        if (!encounteredCannon || toPush.isEmpty()) {
            return;
        }
        if (!level.field_9236) {
            HashSet<class_2338> changes = new HashSet<class_2338>(2);
            for (int i = toPush.size() - 1; i >= 0; --i) {
                class_2338 pos1 = startPos.method_10079(pushDirection, i + k);
                class_2338 pos2 = pos1.method_10093(pushDirection);
                class_3499.class_3501 info = (class_3499.class_3501)toPush.get(i);
                class_2586 be1 = (class_2586)contraption.presentBlockEntities.get(pos1);
                class_2586 be2 = (class_2586)contraption.presentBlockEntities.get(pos2);
                if (!(be1 instanceof IBigCannonBlockEntity)) break;
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be1;
                if (!(be2 instanceof IBigCannonBlockEntity)) break;
                IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)be2;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).tryLoadingBlock(info);
                changes.add(pos2);
                if (i != 0) continue;
                changes.add(pos1);
            }
            BigCannonBlock.writeAndSyncMultipleBlockData(changes, contraption.entity, contraption);
        }
        level.method_8396(null, player.method_24515(), class_3417.field_15226, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7322((float)toPush.size() * CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
        player.method_7357().method_7906((class_1792)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
    }

    public static boolean isValidLoadBlock(class_2680 state, class_1937 level, class_2338 pos, class_2350 dir) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonMunitionBlock) {
            BigCannonMunitionBlock munition = (BigCannonMunitionBlock)class_22482;
            return munition.canBeLoaded(state, dir.method_10166());
        }
        class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)class_22482;
            return cBlock.getOpeningType(level, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).method_10166() == dir.method_10166();
        }
        return false;
    }

    public static boolean isValidLoadBlock(class_2680 state, MountedBigCannonContraption contraption, class_2338 pos, class_2350 dir) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonMunitionBlock) {
            BigCannonMunitionBlock munition = (BigCannonMunitionBlock)class_22482;
            return munition.canBeLoaded(state, dir.method_10166());
        }
        class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)class_22482;
            return cBlock.getOpeningType(contraption, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).method_10166() == dir.method_10166();
        }
        return false;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        CBCTooltip.appendRamRodText(stack, level, tooltip, flag);
    }

    public static int getPushStrength() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodStrength.get();
    }

    public static int getReach() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodReach.get();
    }

    public static boolean deployersCanUse() {
        return (Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get();
    }
}

