/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3542;
import rbasamoyai.createbigcannons.CreateBigCannons;

public record BigCannonMaterialProperties(double minimumVelocityPerBarrel, float weight, int maxSafePropellantStress, FailureMode failureMode, boolean connectsInSurvival, boolean isWeldable, int weldDamage, int weldStressPenalty, float minimumSpread, float spreadReductionPerBarrel) {
    public boolean mayGetStuck(float chargesUsed, int barrelTravelled) {
        if (this.minimumVelocityPerBarrel < 0.0) {
            return true;
        }
        if (barrelTravelled < 1) {
            return false;
        }
        return this.minimumVelocityPerBarrel > (double)(chargesUsed / (float)barrelTravelled);
    }

    public static BigCannonMaterialProperties fromJson(class_2960 id, JsonObject obj) {
        double minimumVelocityPerBarrel = class_3518.method_34915((JsonObject)obj, (String)"minimum_velocity_per_barrel", (double)1.0);
        if (class_3518.method_34920((JsonObject)obj, (String)"squib_ratio_barrels") && class_3518.method_34920((JsonObject)obj, (String)"squib_ratio_propellant")) {
            float ratio;
            float barrels = class_3518.method_15260((JsonObject)obj, (String)"squib_ratio_barrels");
            float propellant = class_3518.method_15260((JsonObject)obj, (String)"squib_ratio_propellant");
            float f = ratio = propellant <= 0.0f ? -1.0f : barrels / propellant;
            if (ratio < 0.0f) {
                ratio = -1.0f;
            }
            CreateBigCannons.LOGGER.warn("Legacy values \"squib_ratio_barrels\" and \"squib_ratio_propellant\" found in config for {}, please change to \"max_safe_propellant_stress\". Recommended value: {}", (Object)id, (Object)String.format(".%2f", Float.valueOf(ratio)));
            if (!class_3518.method_34920((JsonObject)obj, (String)"minimum_velocity_per_barrel")) {
                minimumVelocityPerBarrel = ratio;
            }
        }
        minimumVelocityPerBarrel = Math.max(-1.0, minimumVelocityPerBarrel);
        float weight = Math.max(0.0f, class_3518.method_15277((JsonObject)obj, (String)"weight", (float)2.0f));
        int maxSafeBaseCharges = class_3518.method_15282((JsonObject)obj, (String)"max_safe_propellant_stress", (int)2);
        if (class_3518.method_34920((JsonObject)obj, (String)"max_safe_charges")) {
            CreateBigCannons.LOGGER.warn("Legacy value \"max_safe_charges\" found in config for {}, please change to \"max_safe_propellant_stress\"", (Object)id);
            if (!class_3518.method_34920((JsonObject)obj, (String)"max_safe_propellant_stress")) {
                maxSafeBaseCharges = class_3518.method_15260((JsonObject)obj, (String)"max_safe_charges");
            }
        }
        maxSafeBaseCharges = Math.max(0, maxSafeBaseCharges);
        FailureMode failureMode = FailureMode.byId(class_3518.method_15265((JsonObject)obj, (String)"failure_mode"));
        boolean connectsInSurvival = class_3518.method_15258((JsonObject)obj, (String)"connects_in_survival", (boolean)false);
        boolean isWeldable = class_3518.method_15258((JsonObject)obj, (String)"is_weldable", (boolean)false);
        int weldDamage = Math.max(class_3518.method_15282((JsonObject)obj, (String)"weld_damage", (int)0), 0);
        int weldStressPenalty = Math.max(class_3518.method_15282((JsonObject)obj, (String)"weld_stress_penalty", (int)0), 0);
        float minimumSpread = Math.max(class_3518.method_15277((JsonObject)obj, (String)"minimum_spread", (float)0.05f), 0.0f);
        float spreadReductionPerBarrel = Math.max(class_3518.method_15277((JsonObject)obj, (String)"spread_reduction_per_barrel", (float)1.0f), 0.0f);
        return new BigCannonMaterialProperties(minimumVelocityPerBarrel, weight, maxSafeBaseCharges, failureMode, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty, minimumSpread, spreadReductionPerBarrel);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("minimum_velocity_per_barrel", (Number)this.minimumVelocityPerBarrel);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("max_safe_propellant_stress", (Number)this.maxSafePropellantStress);
        obj.addProperty("failure_mode", this.failureMode.toString());
        obj.addProperty("connects_in_survival", Boolean.valueOf(this.connectsInSurvival));
        obj.addProperty("is_weldable", Boolean.valueOf(this.isWeldable));
        obj.addProperty("weld_damage", (Number)this.weldDamage);
        obj.addProperty("weld_stress_penalty", (Number)this.weldStressPenalty);
        obj.addProperty("minimum_spread", (Number)Float.valueOf(this.minimumSpread));
        obj.addProperty("spread_reduction_per_barrel", (Number)Float.valueOf(this.spreadReductionPerBarrel));
        return obj;
    }

    public void writeBuf(class_2540 buf) {
        buf.writeDouble(this.minimumVelocityPerBarrel).writeFloat(this.weight);
        buf.method_10804(this.maxSafePropellantStress).method_10804(this.failureMode.ordinal()).writeBoolean(this.connectsInSurvival).writeBoolean(this.isWeldable);
        buf.method_10804(this.weldDamage).method_10804(this.weldStressPenalty).writeFloat(this.minimumSpread).writeFloat(this.spreadReductionPerBarrel);
    }

    public static BigCannonMaterialProperties fromBuf(class_2540 buf) {
        double minimumVelocityPerBarrel = buf.readDouble();
        float weight = buf.readFloat();
        int maxSafeBaseCharges = buf.method_10816();
        FailureMode mode = FailureMode.values()[buf.method_10816()];
        boolean connectsInSurvival = buf.readBoolean();
        boolean isWeldable = buf.readBoolean();
        int weldDamage = buf.method_10816();
        int weldStressPenalty = buf.method_10816();
        float minimumSpread = buf.readFloat();
        float spreadReductionPerBarrel = buf.readFloat();
        return new BigCannonMaterialProperties(minimumVelocityPerBarrel, weight, maxSafeBaseCharges, mode, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty, minimumSpread, spreadReductionPerBarrel);
    }

    public static enum FailureMode implements class_3542
    {
        RUPTURE,
        FRAGMENT;

        private static final Map<String, FailureMode> BY_ID;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String method_15434() {
            return this.name;
        }

        public static FailureMode byId(String id) {
            return BY_ID.getOrDefault(id, RUPTURE);
        }

        static {
            BY_ID = Arrays.stream(FailureMode.values()).collect(Collectors.toMap(class_3542::method_15434, Function.identity()));
        }
    }
}

