/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesSerializer;
import rbasamoyai.createbigcannons.block_armor_properties.mimicking_blocks.MimickingBlockArmorUnit;

public abstract class AbstractMimickingBlockArmorProperties
implements BlockArmorPropertiesProvider {
    private final MimickingBlockArmorUnit defaultUnit;
    private final Map<class_2680, MimickingBlockArmorUnit> unitsByState;

    protected AbstractMimickingBlockArmorProperties(MimickingBlockArmorUnit defaultUnit, Map<class_2680, MimickingBlockArmorUnit> unitsByState) {
        this.defaultUnit = defaultUnit;
        this.unitsByState = unitsByState;
    }

    @Override
    public double hardness(class_1937 level, class_2680 state, class_2338 pos, boolean recurse) {
        MimickingBlockArmorUnit properties = this.unitsByState.getOrDefault(state, this.defaultUnit);
        class_2680 copiedState = this.getCopiedState(level, state, pos);
        if (copiedState.method_26214((class_1922)level, pos) == -1.0f) {
            return copiedState.method_26204().method_9520();
        }
        return !recurse || this.isEmptyState(level, copiedState, state, pos) ? properties.emptyHardness() : BlockArmorPropertiesHandler.getProperties(copiedState).hardness(level, copiedState, pos, false) * properties.materialHardnessMultiplier();
    }

    protected abstract class_2680 getCopiedState(class_1937 var1, class_2680 var2, class_2338 var3);

    protected boolean isEmptyState(class_1937 level, class_2680 copiedState, class_2680 state, class_2338 pos) {
        return copiedState == null || copiedState.method_26215();
    }

    public MimickingBlockArmorUnit getDefaultProperties() {
        return this.defaultUnit;
    }

    public Map<class_2680, MimickingBlockArmorUnit> getPropertiesByState() {
        return this.unitsByState;
    }

    public static <T extends AbstractMimickingBlockArmorProperties> BlockArmorPropertiesSerializer<T> createMimicrySerializer(final Factory<T> fac) {
        return new BlockArmorPropertiesSerializer<T>(){

            @Override
            public T loadBlockArmorPropertiesFromJson(class_2248 block, JsonObject obj) {
                MimickingBlockArmorUnit defaultProperties = MimickingBlockArmorUnit.fromJson(obj);
                Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
                if (obj.has("variants") && obj.get("variants").isJsonObject()) {
                    propertiesByState.putAll(MimickingBlockArmorUnit.readAllProperties(block, obj.getAsJsonObject("variants")));
                }
                return (AbstractMimickingBlockArmorProperties)fac.apply(defaultProperties, propertiesByState);
            }

            @Override
            public void toNetwork(T properties, class_2540 buf) {
                ((AbstractMimickingBlockArmorProperties)properties).getDefaultProperties().toNetwork(buf);
                MimickingBlockArmorUnit.writePropertiesToBuf(((AbstractMimickingBlockArmorProperties)properties).getPropertiesByState(), buf);
            }

            @Override
            public T fromNetwork(class_2540 buf) {
                MimickingBlockArmorUnit defaultProperties = MimickingBlockArmorUnit.fromNetwork(buf);
                Map<class_2680, MimickingBlockArmorUnit> propertiesByState = MimickingBlockArmorUnit.readPropertiesFromBuf(buf);
                return (AbstractMimickingBlockArmorProperties)fac.apply(defaultProperties, propertiesByState);
            }
        };
    }

    @FunctionalInterface
    public static interface Factory<T extends AbstractMimickingBlockArmorProperties>
    extends BiFunction<MimickingBlockArmorUnit, Map<class_2680, MimickingBlockArmorUnit>, T> {
    }
}

