/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.cannon;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.item.BeltConnectorItem;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7871;

public abstract class LaunchedItem {
    public int totalTicks;
    public int ticksRemaining;
    public class_2338 target;
    public class_1799 stack;

    private LaunchedItem(class_2338 start, class_2338 target, class_1799 stack) {
        this(target, stack, LaunchedItem.ticksForDistance(start, target), LaunchedItem.ticksForDistance(start, target));
    }

    private static int ticksForDistance(class_2338 start, class_2338 target) {
        return (int)Math.max(10.0, Math.sqrt(Math.sqrt(target.method_10262((class_2382)start))) * 4.0);
    }

    LaunchedItem() {
    }

    private LaunchedItem(class_2338 target, class_1799 stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(class_1937 world) {
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return false;
        }
        if (world.field_9236) {
            return false;
        }
        this.place(world);
        return true;
    }

    public class_2487 serializeNBT() {
        class_2487 c = new class_2487();
        c.method_10569("TotalTicks", this.totalTicks);
        c.method_10569("TicksLeft", this.ticksRemaining);
        c.method_10566("Stack", NBTSerializer.serializeNBT((Object)this.stack));
        c.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
        return c;
    }

    public static LaunchedItem fromNBT(class_2487 c, class_7871<class_2248> holderGetter) {
        ForBelt launched = c.method_10545("Length") ? new ForBelt() : (c.method_10545("BlockState") ? new ForBlockState() : new ForEntity());
        ((LaunchedItem)launched).readNBT(c, holderGetter);
        return launched;
    }

    abstract void place(class_1937 var1);

    void readNBT(class_2487 c, class_7871<class_2248> holderGetter) {
        this.target = class_2512.method_10691((class_2487)c.method_10562("Target"));
        this.ticksRemaining = c.method_10550("TicksLeft");
        this.totalTicks = c.method_10550("TotalTicks");
        this.stack = class_1799.method_7915((class_2487)c.method_10562("Stack"));
    }

    public static class ForBelt
    extends ForBlockState {
        public int length;
        public BeltBlockEntity.CasingType[] casings;

        public ForBelt() {
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 serializeNBT = super.serializeNBT();
            serializeNBT.method_10569("Length", this.length);
            serializeNBT.method_10572("Casing", Arrays.stream(this.casings).map(Enum::ordinal).toList());
            return serializeNBT;
        }

        @Override
        void readNBT(class_2487 nbt, class_7871<class_2248> holderGetter) {
            this.length = nbt.method_10550("Length");
            int[] intArray = nbt.method_10561("Casing");
            this.casings = new BeltBlockEntity.CasingType[this.length];
            for (int i = 0; i < this.casings.length; ++i) {
                this.casings[i] = i >= intArray.length ? BeltBlockEntity.CasingType.NONE : BeltBlockEntity.CasingType.values()[class_3532.method_15340((int)intArray[i], (int)0, (int)(BeltBlockEntity.CasingType.values().length - 1))];
            }
            super.readNBT(nbt, holderGetter);
        }

        public ForBelt(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, BeltBlockEntity.CasingType[] casings) {
            super(start, target, stack, state, null);
            this.casings = casings;
            this.length = casings.length;
        }

        @Override
        void place(class_1937 world) {
            boolean isStart = this.state.method_11654(BeltBlock.PART) == BeltPart.START;
            class_2338 offset = BeltBlock.nextSegmentPosition(this.state, class_2338.field_10980, isStart);
            int i = this.length - 1;
            class_2350.class_2351 axis = this.state.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS ? class_2350.class_2351.field_11052 : ((class_2350)this.state.method_11654(BeltBlock.HORIZONTAL_FACING)).method_10170().method_10166();
            world.method_8501(this.target, (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)AbstractSimpleShaftBlock.AXIS, (Comparable)axis));
            BeltConnectorItem.createBelts(world, this.target, this.target.method_10069(offset.method_10263() * i, offset.method_10264() * i, offset.method_10260() * i));
            for (int segment = 0; segment < this.length; ++segment) {
                class_2338 casingTarget;
                class_2586 class_25862;
                if (this.casings[segment] == BeltBlockEntity.CasingType.NONE || !((class_25862 = world.method_8321(casingTarget = this.target.method_10069(offset.method_10263() * segment, offset.method_10264() * segment, offset.method_10260() * segment))) instanceof BeltBlockEntity)) continue;
                BeltBlockEntity bbe = (BeltBlockEntity)class_25862;
                bbe.setCasingType(this.casings[segment]);
            }
        }
    }

    public static class ForBlockState
    extends LaunchedItem {
        public class_2680 state;
        public class_2487 data;

        ForBlockState() {
        }

        public ForBlockState(class_2338 start, class_2338 target, class_1799 stack, class_2680 state, class_2487 data) {
            super(start, target, stack);
            this.state = state;
            this.data = data;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 serializeNBT = super.serializeNBT();
            serializeNBT.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.state));
            if (this.data != null) {
                this.data.method_10551("x");
                this.data.method_10551("y");
                this.data.method_10551("z");
                this.data.method_10551("id");
                serializeNBT.method_10566("Data", (class_2520)this.data);
            }
            return serializeNBT;
        }

        @Override
        void readNBT(class_2487 nbt, class_7871<class_2248> holderGetter) {
            super.readNBT(nbt, holderGetter);
            this.state = class_2512.method_10681(holderGetter, (class_2487)nbt.method_10562("BlockState"));
            if (nbt.method_10573("Data", 10)) {
                this.data = nbt.method_10562("Data");
            }
        }

        @Override
        void place(class_1937 world) {
            BlockHelper.placeSchematicBlock(world, this.state, this.target, this.stack, this.data);
        }
    }

    public static class ForEntity
    extends LaunchedItem {
        public class_1297 entity;
        private class_2487 deferredTag;

        ForEntity() {
        }

        public ForEntity(class_2338 start, class_2338 target, class_1799 stack, class_1297 entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        @Override
        public boolean update(class_1937 world) {
            if (this.deferredTag != null && this.entity == null) {
                try {
                    Optional loadEntityUnchecked = class_1299.method_5892((class_2487)this.deferredTag, (class_1937)world);
                    if (!loadEntityUnchecked.isPresent()) {
                        return true;
                    }
                    this.entity = (class_1297)loadEntityUnchecked.get();
                }
                catch (Exception var3) {
                    return true;
                }
                this.deferredTag = null;
            }
            return super.update(world);
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 serializeNBT = super.serializeNBT();
            if (this.entity != null) {
                serializeNBT.method_10566("Entity", NBTSerializer.serializeNBT((Object)this.entity));
            }
            return serializeNBT;
        }

        @Override
        void readNBT(class_2487 nbt, class_7871<class_2248> holderGetter) {
            super.readNBT(nbt, holderGetter);
            if (nbt.method_10545("Entity")) {
                this.deferredTag = nbt.method_10562("Entity");
            }
        }

        @Override
        void place(class_1937 world) {
            if (this.entity != null) {
                world.method_8649(this.entity);
            }
        }
    }
}

