/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.transport;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public class TransportedItemStack
implements Comparable<TransportedItemStack> {
    private static Random R = new Random();
    public static final TransportedItemStack EMPTY = new TransportedItemStack(class_1799.field_8037);
    public class_1799 stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public class_2350 insertedFrom;
    public boolean locked;
    public boolean lockedExternally;
    public float prevBeltPosition;
    public float prevSideOffset;
    public FanProcessingType processedBy;
    public int processingTime;

    public TransportedItemStack(class_1799 stack) {
        this.stack = stack;
        boolean centered = BeltHelper.isItemUpright(stack);
        this.angle = centered ? 180 : R.nextInt(360);
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = class_2350.field_11036;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return this.beltPosition < o.beltPosition ? 1 : (this.beltPosition > o.beltPosition ? -1 : 0);
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(this.stack.method_7972());
        copy.beltPosition = this.beltPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevBeltPosition = this.prevBeltPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processedBy = this.processedBy;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public TransportedItemStack fullCopy() {
        TransportedItemStack copy = this.copy();
        copy.locked = this.locked;
        copy.lockedExternally = this.lockedExternally;
        return copy;
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("Item", NBTSerializer.serializeNBT((Object)this.stack));
        nbt.method_10548("Pos", this.beltPosition);
        nbt.method_10548("PrevPos", this.prevBeltPosition);
        nbt.method_10548("Offset", this.sideOffset);
        nbt.method_10548("PrevOffset", this.prevSideOffset);
        nbt.method_10569("InSegment", this.insertedAt);
        nbt.method_10569("Angle", this.angle);
        nbt.method_10569("InDirection", this.insertedFrom.method_10146());
        if (this.locked) {
            nbt.method_10556("Locked", this.locked);
        }
        if (this.lockedExternally) {
            nbt.method_10556("LockedExternally", this.lockedExternally);
        }
        return nbt;
    }

    public static TransportedItemStack read(class_2487 nbt) {
        TransportedItemStack stack = new TransportedItemStack(class_1799.method_7915((class_2487)nbt.method_10562("Item")));
        stack.beltPosition = nbt.method_10583("Pos");
        stack.prevBeltPosition = nbt.method_10583("PrevPos");
        stack.sideOffset = nbt.method_10583("Offset");
        stack.prevSideOffset = nbt.method_10583("PrevOffset");
        stack.insertedAt = nbt.method_10550("InSegment");
        stack.angle = nbt.method_10550("Angle");
        stack.insertedFrom = class_2350.method_10143((int)nbt.method_10550("InDirection"));
        stack.locked = nbt.method_10577("Locked");
        stack.lockedExternally = nbt.method_10577("LockedExternally");
        return stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportedItemStack that = (TransportedItemStack)o;
        if (Float.compare(that.beltPosition, this.beltPosition) != 0) {
            return false;
        }
        if (Float.compare(that.sideOffset, this.sideOffset) != 0) {
            return false;
        }
        if (this.angle != that.angle) {
            return false;
        }
        if (this.insertedAt != that.insertedAt) {
            return false;
        }
        if (this.locked != that.locked) {
            return false;
        }
        if (this.lockedExternally != that.lockedExternally) {
            return false;
        }
        if (Float.compare(that.prevBeltPosition, this.prevBeltPosition) != 0) {
            return false;
        }
        if (Float.compare(that.prevSideOffset, this.prevSideOffset) != 0) {
            return false;
        }
        if (this.processingTime != that.processingTime) {
            return false;
        }
        if (!class_1799.method_7973((class_1799)this.stack, (class_1799)that.stack)) {
            return false;
        }
        if (this.insertedFrom != that.insertedFrom) {
            return false;
        }
        return this.processedBy == that.processedBy;
    }
}

