/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.implementation.peripherals.DisplayLinkPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SequencedGearshiftPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedControllerPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedGaugePeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StationPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StressGaugePeripheral;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    IPeripheral peripheral;

    @Nullable
    public static IPeripheral peripheralProvider(class_1937 level, class_2338 blockPos) {
        AbstractComputerBehaviour behavior = BlockEntityBehaviour.get((class_1922)level, blockPos, AbstractComputerBehaviour.TYPE);
        if (behavior instanceof ComputerBehaviour) {
            ComputerBehaviour real = (ComputerBehaviour)behavior;
            return (IPeripheral)real.getPeripheral();
        }
        return null;
    }

    public ComputerBehaviour(SmartBlockEntity te) {
        super(te);
        this.peripheral = ComputerBehaviour.getPeripheralFor(te);
    }

    public static IPeripheral getPeripheralFor(SmartBlockEntity be) {
        if (be instanceof SpeedControllerBlockEntity) {
            SpeedControllerBlockEntity scbe = (SpeedControllerBlockEntity)be;
            return new SpeedControllerPeripheral(scbe, scbe.targetSpeed);
        }
        if (be instanceof DisplayLinkBlockEntity) {
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)be;
            return new DisplayLinkPeripheral(dlbe);
        }
        if (be instanceof SequencedGearshiftBlockEntity) {
            SequencedGearshiftBlockEntity sgbe = (SequencedGearshiftBlockEntity)be;
            return new SequencedGearshiftPeripheral(sgbe);
        }
        if (be instanceof SpeedGaugeBlockEntity) {
            SpeedGaugeBlockEntity sgbe = (SpeedGaugeBlockEntity)be;
            return new SpeedGaugePeripheral(sgbe);
        }
        if (be instanceof StressGaugeBlockEntity) {
            StressGaugeBlockEntity sgbe = (StressGaugeBlockEntity)be;
            return new StressGaugePeripheral(sgbe);
        }
        if (be instanceof StationBlockEntity) {
            StationBlockEntity sbe = (StationBlockEntity)be;
            return new StationPeripheral(sbe);
        }
        throw new IllegalArgumentException("No peripheral available for " + class_7923.field_41181.method_10221((Object)be.method_11017()));
    }

    @Override
    public <T> T getPeripheral() {
        return (T)this.peripheral;
    }
}

