/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen.recipes;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCItems;
import com.copycatsplus.copycats.CCTags;
import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.datagen.recipes.fabric.CCStandardRecipesImpl;
import com.copycatsplus.copycats.datagen.recipes.gen.CopycatsRecipeProvider;
import com.copycatsplus.copycats.datagen.recipes.gen.GeneratedRecipeBuilder;
import com.copycatsplus.copycats.multiloader.Platform;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7784;

public class CCStandardRecipes
extends CopycatsRecipeProvider {
    private final Set<class_2248> copycatsWithRecipes = new HashSet<class_2248>();
    private final Marker PALETTES = this.enterFolder("palettes");
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLAB = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_SLAB, 2);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLAB_FROM_PANELS = CCStandardRecipes.create(CCBlocks.COPYCAT_SLAB).withSuffix("_from_panels").unlockedBy(() -> ((BlockEntry)AllBlocks.COPYCAT_PANEL).get()).requiresResultFeature().viaShaped(b -> b.method_10434(Character.valueOf('p'), (class_1935)AllBlocks.COPYCAT_PANEL).method_10439("p").method_10439("p"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLAB_FROM_STEPS = CCStandardRecipes.create(CCBlocks.COPYCAT_SLAB).withSuffix("_from_steps").unlockedBy(() -> ((BlockEntry)AllBlocks.COPYCAT_STEP).get()).requiresResultFeature().viaShaped(b -> b.method_10434(Character.valueOf('s'), (class_1935)AllBlocks.COPYCAT_STEP).method_10439("ss"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLAB_FROM_BEAMS = CCStandardRecipes.create(CCBlocks.COPYCAT_SLAB).withSuffix("_from_beams").unlockedByTag(() -> CCTags.Items.COPYCAT_BEAM.tag).requiresResultFeature().requiresFeature(CCBlocks.COPYCAT_BEAM).viaShaped(b -> b.method_10433(Character.valueOf('s'), CCTags.Items.COPYCAT_BEAM.tag).method_10439("ss"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BLOCK = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_BLOCK, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BLOCK_FROM_SLABS = CCStandardRecipes.create(CCBlocks.COPYCAT_BLOCK).withSuffix("_from_slabs").unlockedByTag(() -> CCTags.Items.COPYCAT_SLAB.tag).requiresResultFeature().requiresFeature(CCBlocks.COPYCAT_SLAB).viaShaped(b -> b.method_10433(Character.valueOf('s'), CCTags.Items.COPYCAT_SLAB.tag).method_10439("s").method_10439("s"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BEAM = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_BEAM, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_STEP_CYCLE_1 = CCStandardRecipes.create((ItemProviderEntry<? extends class_1935>)AllBlocks.COPYCAT_STEP).withSuffix("_from_conversion").unlockedByTag(() -> CCTags.Items.COPYCAT_VERTICAL_STEP.tag).requiresFeature(CCBlocks.COPYCAT_VERTICAL_STEP).viaShapeless(b -> b.method_10446(CCTags.Items.COPYCAT_VERTICAL_STEP.tag));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_STEP_CYCLE_2 = CCStandardRecipes.create(CCBlocks.COPYCAT_VERTICAL_STEP).withSuffix("_from_conversion").unlockedBy(() -> ((BlockEntry)AllBlocks.COPYCAT_STEP).get()).requiresResultFeature().viaShapeless(b -> b.method_10454((class_1935)AllBlocks.COPYCAT_STEP));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_VERTICAL_STEP = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_VERTICAL_STEP, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_HALF_PANEL = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_HALF_PANEL, 8);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_PANEL_FROM_HALF_PANELS = CCStandardRecipes.create((ItemProviderEntry<? extends class_1935>)AllBlocks.COPYCAT_PANEL).withSuffix("_from_half_panels").unlockedBy(() -> CCBlocks.COPYCAT_HALF_PANEL.get()).requiresFeature(CCBlocks.COPYCAT_HALF_PANEL).viaShaped(b -> b.method_10434(Character.valueOf('s'), CCBlocks.COPYCAT_HALF_PANEL).method_10439("ss"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_STAIRS = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_STAIRS, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_FENCE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_FENCE, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_FENCE_GATE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_FENCE_GATE, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_TRAPDOOR = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_TRAPDOOR, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_TRAPDOOR_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends class_1935>>)ImmutableList.of((Object)AllBlocks.COPYCAT_PANEL, CCBlocks.COPYCAT_TRAPDOOR));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_WALL = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_WALL, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BOARD = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_BOARD, 8);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BOX = CCStandardRecipes.create(CCItems.COPYCAT_BOX).unlockedByTag(() -> CCTags.Items.COPYCAT_BOARD.tag).requiresResultFeature().viaShaped(b -> b.method_10433(Character.valueOf('s'), CCTags.Items.COPYCAT_BOARD.tag).method_10439("ss ").method_10439("s s").method_10439(" ss"));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_CATWALK = CCStandardRecipes.create(CCItems.COPYCAT_CATWALK).unlockedByTag(() -> CCTags.Items.COPYCAT_BOARD.tag).requiresResultFeature().viaShaped(b -> b.method_10433(Character.valueOf('s'), CCTags.Items.COPYCAT_BOARD.tag).method_10439("s s").method_10439(" s "));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_BYTE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_BYTE, 8);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_LAYER = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_LAYER, 8);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLICE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_SLICE, 16);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_VERTICAL_SLICE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_VERTICAL_SLICE, 16);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLICE_CYCLE = this.conversionCycle((List<ItemProviderEntry<? extends class_1935>>)ImmutableList.of(CCBlocks.COPYCAT_SLICE, CCBlocks.COPYCAT_VERTICAL_SLICE));
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_HALF_LAYER = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_HALF_LAYER, 16);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_WOODEN_BUTTON = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_WOODEN_BUTTON, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_STONE_BUTTON = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_STONE_BUTTON, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_WOOD_PRESSURE_PLATE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_WOODEN_PRESSURE_PLATE, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_STONE_PRESSURE_PLATE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_STONE_PRESSURE_PLATE, 4);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_LIGHT_WEIGHTED_PRESSURE_PLATE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_LIGHT_WEIGHTED_PRESSURE_PLATE, 2);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_HEAVY_WEIGHTED_PRESSURE_PLATE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_HEAVY_WEIGHTED_PRESSURE_PLATE, 2);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_VERTICAL_STAIRS = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_VERTICAL_STAIRS, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_GHOST_BLOCK = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_GHOST_BLOCK, 1);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_LADDER = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_LADDER, 6);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLOPE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_SLOPE, 2);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_VERTICAL_SLOPE = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_VERTICAL_SLOPE, 2);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SLOPE_LAYER = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_SLOPE_LAYER, 8);
    GeneratedRecipeBuilder.GeneratedRecipe COPYCAT_SHAFT = this.copycat((ItemProviderEntry<? extends class_1935>)CCBlocks.COPYCAT_SHAFT, 4);
    String currentFolder = "";

    Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new Marker();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static GeneratedRecipeBuilder create(Supplier<class_1935> result) {
        return CCStandardRecipesImpl.create(result);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static GeneratedRecipeBuilder create(class_2960 result) {
        return CCStandardRecipesImpl.create(result);
    }

    static GeneratedRecipeBuilder create(ItemProviderEntry<? extends class_1935> result) {
        return CCStandardRecipes.create(() -> result.get());
    }

    GeneratedRecipeBuilder.GeneratedRecipe copycat(ItemProviderEntry<? extends class_1935> result, int resultCount) {
        Object copycat;
        Object object = result.get();
        if (object instanceof CopycatBlock) {
            copycat = (CopycatBlock)object;
            this.copycatsWithRecipes.add((class_2248)copycat);
        }
        if (result.get() instanceof IFunctionalCopycatBlock) {
            this.copycatsWithRecipes.add((class_2248)result.get());
        }
        if ((object = result.get()) instanceof MultiStateCopycatBlock) {
            copycat = (MultiStateCopycatBlock)object;
            this.copycatsWithRecipes.add((class_2248)copycat);
        }
        return CCStandardRecipes.create(result).unlockedBy(() -> ((ItemEntry)AllItems.ZINC_INGOT).get()).returns(resultCount).viaStonecuttingTag(TaggedIngredients.ZINC::getTag).create();
    }

    GeneratedRecipeBuilder.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends class_1935>> cycle) {
        GeneratedRecipeBuilder.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends class_1935> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends class_1935> nextEntry = cycle.get((i + 1) % cycle.size());
            result = CCStandardRecipes.create(nextEntry).withSuffix("_from_conversion").unlockedBy(() -> currentEntry.get()).requiresFeature(currentEntry.getId()).requiresFeature(nextEntry.getId()).viaShapeless(b -> b.method_10454((class_1935)currentEntry.get()));
        }
        return result;
    }

    public CCStandardRecipes(class_7784 output) {
        super(output);
        LinkedList<class_2960> missingRecipes = new LinkedList<class_2960>();
        for (RegistryEntry<class_2248> entry : CCBlocks.getAllRegisteredBlocksWithoutWrapped()) {
            if (entry.equals(CCBlocks.COPYCAT_TEST_BLOCK) || this.copycatsWithRecipes.contains(entry.get())) continue;
            missingRecipes.add(entry.getId());
        }
        if (!missingRecipes.isEmpty()) {
            throw new AssertionError((Object)("The following copycats do not have a crafting recipe: \n" + missingRecipes.stream().map(class_2960::toString).collect(Collectors.joining(", "))));
        }
    }

    protected static class Marker {
        protected Marker() {
        }
    }

    public static enum TaggedIngredients {
        ZINC(CCTags.commonItemTag("ingots/zinc"), CCTags.commonItemTag("zinc_ingots"));

        private final class_6862<class_1792> forge;
        private final class_6862<class_1792> fabric;

        private TaggedIngredients(class_6862<class_1792> forge, class_6862<class_1792> fabric) {
            this.forge = forge;
            this.fabric = fabric;
        }

        public class_6862<class_1792> getTag() {
            return Platform.getCurrent().equals((Object)Platform.FORGE) ? this.forge : this.fabric;
        }
    }
}

