/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slope;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.ICustomCTBlocking;
import com.copycatsplus.copycats.content.copycat.base.IStateType;
import com.copycatsplus.copycats.utility.shape.NoneVoxelShape;
import com.copycatsplus.copycats.utility.shape.VoxelUtils;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

public class CopycatSlopeBlock
extends CTWaterloggedCopycatBlock
implements IStateType,
ICustomCTBlocking {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2760> HALF = class_2741.field_12518;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlopeBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2760.field_12617));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        if (!player.method_5715() && player.method_7294()) {
            class_1799 heldItem = player.method_5998(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (class_1747)heldItem.method_7909(), player, hand, ray);
                return class_1269.field_5812;
            }
        }
        return super.method_9534(state, world, pos, player, hand, ray);
    }

    public boolean isIgnoredConnectivitySide(class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2760 half = (class_2760)state.method_11654(HALF);
        class_2680 toState = reader.method_8320(toPos);
        class_2338 diff = toPos.method_10059((class_2382)fromPos);
        if (diff.equals((Object)class_2382.field_11176)) {
            return false;
        }
        class_2350 connectFace = class_2350.method_50026((int)diff.method_10263(), (int)diff.method_10264(), (int)diff.method_10260());
        if (connectFace == null) {
            return false;
        }
        if (toState.method_27852((class_2248)this)) {
            if (toState.method_11654((class_2769)FACING) == direction && toState.method_11654(HALF) == half) {
                return false;
            }
            return direction != connectFace || connectFace != ((class_2350)toState.method_11654((class_2769)FACING)).method_10153();
        }
        return !(direction == connectFace || half == class_2760.field_12619 && connectFace == class_2350.field_11036 || half == class_2760.field_12617 && connectFace == class_2350.field_11033);
    }

    public boolean canConnectTexturesToward(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
        class_2680 toState = reader.method_8320(toPos);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2760 half = (class_2760)state.method_11654(HALF);
        class_2338 diff = toPos.method_10059((class_2382)fromPos);
        if (diff.equals((Object)class_2382.field_11176)) {
            return true;
        }
        class_2350 face = class_2350.method_50026((int)diff.method_10263(), (int)diff.method_10264(), (int)diff.method_10260());
        if (face == null) {
            return true;
        }
        if (toState.method_27852((class_2248)this)) {
            try {
                return toState.method_11654((class_2769)FACING) == facing && toState.method_11654(HALF) == half && face.method_10166().method_10179() && face.method_10166() != facing.method_10166() || face == facing && face == ((class_2350)toState.method_11654((class_2769)FACING)).method_10153();
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return face == facing || half == class_2760.field_12619 && face == class_2350.field_11036 || half == class_2760.field_12617 && face == class_2350.field_11033;
    }

    @Override
    public Optional<Boolean> isCTBlocked(class_1920 reader, class_2680 state, class_2338 pos, class_2338 connectingPos, class_2338 blockingPos, class_2350 face) {
        if (reader.method_8320(blockingPos).method_27852((class_2248)this)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public boolean method_9516(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_10 pType) {
        return false;
    }

    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2760 half = (class_2760)state.method_11654(HALF);
        if (face == facing) {
            return true;
        }
        if (face == facing.method_10153()) {
            return false;
        }
        if (half == class_2760.field_12619) {
            return face != class_2350.field_11033;
        }
        return face != class_2350.field_11036;
    }

    public boolean shouldFaceAlwaysRender(class_2680 state, class_2350 face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 stateForPlacement = super.method_9605(context);
        assert (stateForPlacement != null);
        class_2350 facing = context.method_8042();
        class_2760 half = context.method_8038() == class_2350.field_11033 ? class_2760.field_12619 : (context.method_8038() == class_2350.field_11036 ? class_2760.field_12617 : (context.method_17698().field_1351 - (double)context.method_8037().method_10264() > 0.5 ? class_2760.field_12619 : class_2760.field_12617));
        return (class_2680)((class_2680)stateForPlacement.method_11657((class_2769)FACING, (Comparable)facing)).method_11657(HALF, (Comparable)half);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(new class_2769[]{FACING, HALF}));
    }

    @NotNull
    public class_265 method_9530(class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        class_243[] class_243Array;
        class_2350 facing = (class_2350)pState.method_11654((class_2769)FACING);
        boolean isBottom = pState.method_11654(HALF) == class_2760.field_12617;
        switch (facing) {
            case field_11039: {
                class_243[] class_243Array2 = new class_243[8];
                class_243Array2[0] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array2[1] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array2[2] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array2[3] = new class_243(0.0, (double)(isBottom ? 1 : 0), 0.0);
                class_243Array2[4] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array2[5] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array2[6] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array = class_243Array2;
                class_243Array2[7] = new class_243(0.0, (double)(isBottom ? 1 : 0), 1.0);
                break;
            }
            case field_11034: {
                class_243[] class_243Array3 = new class_243[8];
                class_243Array3[0] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array3[1] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array3[2] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array3[3] = new class_243(1.0, (double)(isBottom ? 1 : 0), 1.0);
                class_243Array3[4] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array3[5] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array3[6] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array = class_243Array3;
                class_243Array3[7] = new class_243(1.0, (double)(isBottom ? 1 : 0), 0.0);
                break;
            }
            case field_11043: {
                class_243[] class_243Array4 = new class_243[8];
                class_243Array4[0] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array4[1] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array4[2] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array4[3] = new class_243(0.0, (double)(isBottom ? 1 : 0), 0.0);
                class_243Array4[4] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array4[5] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array4[6] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array = class_243Array4;
                class_243Array4[7] = new class_243(1.0, (double)(isBottom ? 1 : 0), 0.0);
                break;
            }
            case field_11035: {
                class_243[] class_243Array5 = new class_243[8];
                class_243Array5[0] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array5[1] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array5[2] = new class_243(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array5[3] = new class_243(1.0, (double)(isBottom ? 1 : 0), 1.0);
                class_243Array5[4] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array5[5] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                class_243Array5[6] = new class_243(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                class_243Array = class_243Array5;
                class_243Array5[7] = new class_243(0.0, (double)(isBottom ? 1 : 0), 1.0);
                break;
            }
            default: {
                throw new AssertionError((Object)"Direction shouldn't appear as this is a horizontal facing block only");
            }
        }
        class_243[] triangleVertices = class_243Array;
        class_243[] shape = VoxelUtils.create12Edges(triangleVertices);
        return new NoneVoxelShape(isBottom ? CCShapes.SLOPE_BOTTOM.get(facing) : CCShapes.SLOPE_TOP.get(facing), shape);
    }

    public boolean supportsExternalFaceHiding(class_2680 state) {
        return true;
    }

    public boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        if (state.method_27852((class_2248)this) == neighborState.method_27852((class_2248)this) && CopycatSlopeBlock.getMaterial((class_1922)level, (class_2338)pos).method_26187(CopycatSlopeBlock.getMaterial((class_1922)level, (class_2338)pos.method_10093(dir)), dir.method_10153())) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            class_2760 half = (class_2760)state.method_11654(HALF);
            return neighborState.method_11654((class_2769)FACING) == facing && neighborState.method_11654(HALF) == half && dir.method_10166().method_10179() && dir.method_10166() != facing.method_10166();
        }
        return false;
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRot) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRot.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 pState, @NotNull class_2415 pMirror) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pMirror.method_10343((class_2350)pState.method_11654((class_2769)FACING)));
    }

    @class_6328
    private static class PlacementHelper
    extends PoleHelper<class_2350> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_SLOPE.has(arg_0), state -> ((class_2350)state.method_11654((class_2769)FACING)).method_10170().method_10166(), (class_2769)FACING);
        }

        public Predicate<class_1799> getItemPredicate() {
            return i -> i.method_7909() instanceof class_1747 && ((class_1747)i.method_7909()).method_7711() instanceof CopycatSlopeBlock;
        }
    }
}

