/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.board;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.base.ICustomCTBlocking;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.content.copycat.base.multistate.WaterloggedMultiStateCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class CopycatBoardBlock
extends WaterloggedMultiStateCopycatBlock
implements ICustomCTBlocking {
    public static class_2746 UP = class_2741.field_12519;
    public static class_2746 DOWN = class_2741.field_12546;
    public static class_2746 NORTH = class_2741.field_12489;
    public static class_2746 SOUTH = class_2741.field_12540;
    public static class_2746 EAST = class_2741.field_12487;
    public static class_2746 WEST = class_2741.field_12527;
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = class_2429.field_11329;
    private final ImmutableMap<class_2680, class_265> shapesCache;

    public CopycatBoardBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.method_33615(CopycatBoardBlock::calculateMultifaceShape);
    }

    @Override
    public int maxMaterials() {
        return 6;
    }

    @Override
    public class_2382 vectorScale(class_2680 state) {
        return new class_2382(1, 1, 1);
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(UP, DOWN, NORTH, EAST, SOUTH, WEST).stream().map(class_2769::method_11899).collect(Collectors.toSet());
    }

    @Override
    public boolean partExists(class_2680 state, String property) {
        if (property.equals(UP.method_11899())) {
            return (Boolean)state.method_11654((class_2769)UP);
        }
        if (property.equals(DOWN.method_11899())) {
            return (Boolean)state.method_11654((class_2769)DOWN);
        }
        if (property.equals(NORTH.method_11899())) {
            return (Boolean)state.method_11654((class_2769)NORTH);
        }
        if (property.equals(SOUTH.method_11899())) {
            return (Boolean)state.method_11654((class_2769)SOUTH);
        }
        if (property.equals(EAST.method_11899())) {
            return (Boolean)state.method_11654((class_2769)EAST);
        }
        if (property.equals(WEST.method_11899())) {
            return (Boolean)state.method_11654((class_2769)WEST);
        }
        return false;
    }

    @Override
    public String getPropertyFromInteraction(class_2680 state, class_1922 level, class_2382 hitLocation, class_2338 blockPos, class_2350 facing, class_243 unscaledHit) {
        facing = class_2350.method_10169((class_2350.class_2351)facing.method_10166(), (class_2350.class_2352)(unscaledHit.method_18043(facing.method_10166()) > 0.5 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060));
        class_2746 face = CopycatBoardBlock.byDirection(facing);
        return face.method_11899();
    }

    @Override
    public String getPropertyFromRender(String renderingProperty, class_2680 state, ScaledBlockAndTintGetter level, class_2382 vector, class_2338 blockPos, class_2350 side, class_2680 queryState, class_2338 queryPos) {
        return renderingProperty;
    }

    @Override
    public class_2382 getVectorFromProperty(class_2680 state, String property) {
        return class_2382.field_11176;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)pBuilder.method_11667(new class_2769[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        return !reader.method_8320(toPos).method_27852((class_2248)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
        return reader.method_8320(toPos).method_27852((class_2248)this);
    }

    @Override
    public Optional<Boolean> blockCTTowards(class_1920 reader, class_2680 state, class_2338 pos, class_2338 ctPos, class_2338 connectingPos, class_2350 face) {
        if (!reader.method_8320(ctPos).method_27852((class_2248)this)) {
            return Optional.empty();
        }
        return Optional.of(false);
    }

    @Override
    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        return (Boolean)state.method_11654((class_2769)CopycatBoardBlock.byDirection(face.method_10153())) == false;
    }

    @Override
    public boolean shouldFaceAlwaysRender(class_2680 state, class_2350 face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public boolean method_9516(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_10 pType) {
        return switch (pType) {
            case class_10.field_50 -> {
                if (!((Boolean)pState.method_11654((class_2769)UP)).booleanValue() && ((Boolean)pState.method_11654((class_2769)DOWN)).booleanValue() || ((Boolean)pState.method_11654((class_2769)UP)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static class_265 calculateMultifaceShape(class_2680 pState) {
        class_265 shape = class_259.method_1073();
        for (class_2350 direction : Iterate.directions) {
            if (!((Boolean)pState.method_11654((class_2769)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)CCShapes.CASING_1PX.get(direction));
        }
        return shape;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        class_265 shapeOverride = CopycatBoardBlock.multiPlatformGetShape(pState, pLevel, pPos, pContext);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        return Objects.requireNonNull((class_265)this.shapesCache.get((Object)pState));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 stateForPlacement = super.method_9605(context);
        assert (stateForPlacement != null);
        class_2338 blockPos = context.method_8037();
        class_2680 state = context.method_8045().method_8320(blockPos);
        if (state.method_27852((class_2248)this)) {
            if (!((Boolean)state.method_11654((class_2769)CopycatBoardBlock.byDirection(context.method_8038().method_10153()))).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)CopycatBoardBlock.byDirection(context.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
            }
            return (class_2680)state.method_11657((class_2769)CopycatBoardBlock.byDirection(context.method_8038()), (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)stateForPlacement.method_11657((class_2769)CopycatBoardBlock.byDirection(context.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
    }

    public boolean method_9616(class_2680 pState, class_1750 pUseContext) {
        class_1799 itemstack = pUseContext.method_8041();
        if (!itemstack.method_31574(this.method_8389())) {
            return false;
        }
        if (!((Boolean)pState.method_11654((class_2769)CopycatBoardBlock.byDirection(pUseContext.method_8038().method_10153()))).booleanValue()) {
            double loc;
            class_2350 direction = pUseContext.method_8038().method_10153();
            double pos = CopycatBoardBlock.getByAxis((class_2382)pUseContext.method_8037(), direction.method_10166());
            if (CopycatBoardBlock.getByAxis(direction.method_10163(), direction.method_10166()) > 0) {
                pos += 1.0;
            }
            if (Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((class_2374)pUseContext.method_17698(), direction.method_10166()))) < 0.125) {
                return true;
            }
        }
        if (!((Boolean)pState.method_11654((class_2769)CopycatBoardBlock.byDirection(pUseContext.method_8038()))).booleanValue()) {
            double hitLoc = CopycatBoardBlock.getByAxis((class_2374)pUseContext.method_17698(), pUseContext.method_8038().method_10166());
            int direction = CopycatBoardBlock.getByAxis(pUseContext.method_8038().method_10163(), pUseContext.method_8038().method_10166());
            double offset = hitLoc - (double)Math.round(hitLoc);
            if (class_3532.method_17822((double)direction) == class_3532.method_17822((double)offset) && Math.abs(offset) < 0.125) {
                return true;
            }
        }
        return false;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        int faceCount = 0;
        for (class_2350 direction : Iterate.directions) {
            if (!((Boolean)state.method_11654((class_2769)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            ++faceCount;
        }
        if (faceCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        ArrayList<class_2350> options = new ArrayList<class_2350>(6);
        for (class_2350 direction : Iterate.directions) {
            double loc;
            if (!((Boolean)state.method_11654((class_2769)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            double pos = CopycatBoardBlock.getByAxis((class_2382)context.method_8037(), direction.method_10166());
            if (CopycatBoardBlock.getByAxis(direction.method_10163(), direction.method_10166()) > 0) {
                pos += 1.0;
            }
            if (!(Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((class_2374)context.method_17698(), direction.method_10166()))) < 0.125)) continue;
            options.add(direction);
        }
        if (options.size() > 1) {
            class_2350 backup = (class_2350)options.get(0);
            options.removeIf(d -> d.method_10166() != context.method_8038().method_10166());
            if (options.size() == 0) {
                options.add(backup);
            }
        }
        if (options.size() == 0) {
            return super.onSneakWrenched(state, context);
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        if (world instanceof class_3218) {
            if (player != null) {
                List drops = class_2248.method_9609((class_2680)((class_2680)this.method_9564().method_11657((class_2769)CopycatBoardBlock.byDirection((class_2350)options.get(0)), (Comparable)Boolean.valueOf(true))), (class_3218)((class_3218)world), (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)context.method_8041());
                this.withBlockEntityDo((class_1922)world, pos, ufte -> {
                    String property = CopycatBoardBlock.byDirection((class_2350)options.get(0)).method_11899();
                    drops.add(ufte.getMaterialItemStorage().getMaterialItem(property).consumedItem());
                    ufte.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
                    ufte.setConsumedItem(property, class_1799.field_8037);
                });
                if (!player.method_7337()) {
                    for (class_1799 drop : drops) {
                        player.method_31548().method_7398(drop);
                    }
                }
            }
            class_2338 up = pos.method_10093(class_2350.field_11036);
            world.method_8501(pos, ((class_2680)state.method_11657((class_2769)CopycatBoardBlock.byDirection((class_2350)options.get(0)), (Comparable)Boolean.valueOf(false))).method_26191(class_2350.field_11036, world.method_8320(up), (class_1936)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return class_1269.field_5812;
    }

    private static int getByAxis(class_2382 pos, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> pos.method_10263();
            case class_2350.class_2351.field_11052 -> pos.method_10264();
            case class_2350.class_2351.field_11051 -> pos.method_10260();
        };
    }

    private static double getByAxis(class_2374 pos, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> pos.method_10216();
            case class_2350.class_2351.field_11052 -> pos.method_10214();
            case class_2350.class_2351.field_11051 -> pos.method_10215();
        };
    }

    public boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        if (state.method_27852((class_2248)this) && !((Boolean)state.method_11654((class_2769)CopycatBoardBlock.byDirection(dir))).booleanValue()) {
            return false;
        }
        if (neighborState.method_27852((class_2248)this) && !((Boolean)neighborState.method_11654((class_2769)CopycatBoardBlock.byDirection(dir.method_10153()))).booleanValue()) {
            return false;
        }
        String property = this.getProperty(state, level, pos, new class_3965(class_243.method_24953((class_2382)pos), dir, pos, true), true);
        if (state.method_27852((class_2248)this) == neighborState.method_27852((class_2248)this)) {
            return CopycatBoardBlock.getMaterial(level, pos, property).method_26187(CopycatBoardBlock.getMaterial(level, pos.method_10093(dir)), dir.method_10153());
        }
        return CopycatBoardBlock.getMaterial(level, pos, property).method_26187(neighborState, dir.method_10153());
    }

    @Override
    @NotNull
    public class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRotation) {
        pState = super.method_9598(pState, pRotation);
        return this.mapDirections(pState, arg_0 -> ((class_2470)pRotation).method_10503(arg_0));
    }

    @Override
    public void rotate(@NotNull class_2680 state, @NotNull MultiStateCopycatBlockEntity be, class_2470 rotation) {
        be.getMaterialItemStorage().remapStorage(key -> CopycatBoardBlock.directionToProperty(rotation.method_10503(CopycatBoardBlock.propertyToDirection(key))));
    }

    private static class_2350 propertyToDirection(String property) {
        return switch (property) {
            case "up" -> class_2350.field_11036;
            case "down" -> class_2350.field_11033;
            case "north" -> class_2350.field_11043;
            case "south" -> class_2350.field_11035;
            case "east" -> class_2350.field_11034;
            case "west" -> class_2350.field_11039;
            default -> throw new IllegalStateException("Unexpected value: " + property);
        };
    }

    public static String directionToProperty(class_2350 direction) {
        return direction.method_10151().toLowerCase();
    }

    @Override
    @NotNull
    public class_2680 method_9569(@NotNull class_2680 pState, class_2415 pMirror) {
        pState = super.method_9569(pState, pMirror);
        return this.mapDirections(pState, arg_0 -> ((class_2415)pMirror).method_10343(arg_0));
    }

    @Override
    public void mirror(@NotNull class_2680 state, @NotNull MultiStateCopycatBlockEntity be, class_2415 mirror) {
        be.getMaterialItemStorage().remapStorage(key -> CopycatBoardBlock.directionToProperty(mirror.method_10343(CopycatBoardBlock.propertyToDirection(key))));
    }

    private class_2680 mapDirections(class_2680 pState, Function<class_2350, class_2350> pDirectionalFunction) {
        class_2680 blockstate = pState;
        for (class_2350 direction : Iterate.directions) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)CopycatBoardBlock.byDirection(pDirectionalFunction.apply(direction)), (Comparable)((Boolean)pState.method_11654((class_2769)CopycatBoardBlock.byDirection(direction))));
        }
        return blockstate;
    }

    public static class_2746 byDirection(class_2350 direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }
}

