/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.multistate;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.BlockStateTransform;
import com.copycatsplus.copycats.content.copycat.base.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.fabric.MultiStateCopycatBlockEntityImpl;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public abstract class MultiStateCopycatBlockEntity
extends SmartBlockEntity
implements IFunctionalCopycatBlockEntity,
ISpecialBlockEntityItemRequirement,
ITransformableBlockEntity,
IPartialSafeNBT {
    private final MaterialItemStorage materialItemStorage;

    public MultiStateCopycatBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)class_22482;
            this.materialItemStorage = MaterialItemStorage.create(mscb.maxMaterials(), mscb.storageProperties());
        } else {
            this.materialItemStorage = MaterialItemStorage.create(1, Set.of("block"));
        }
    }

    @Override
    public CopycatBlockEntity getCopycatBlockEntity() {
        return null;
    }

    @Override
    public class_2680 getMaterial() {
        return this.materialItemStorage.getAllMaterials().stream().filter(x -> !x.method_27852((class_2248)AllBlocks.COPYCAT_BASE.get())).findFirst().orElse(AllBlocks.COPYCAT_BASE.getDefaultState());
    }

    @Override
    public void method_31662(@NotNull class_1937 level) {
        super.method_31662(level);
    }

    public void updateTransform() {
        BlockStateTransform transform = (BlockStateTransform)((Object)this.method_11010().method_11654(MultiStateCopycatBlock.TRANSFORM));
        if (transform != BlockStateTransform.ABCD) {
            MultiStateCopycatBlock block = (MultiStateCopycatBlock)this.method_11010().method_26204();
            transform.undoTransform(r -> block.rotate(this.method_11010(), this, (class_2470)r), m -> block.mirror(this.method_11010(), this, (class_2415)m));
        }
        this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(MultiStateCopycatBlock.TRANSFORM, (Comparable)((Object)BlockStateTransform.ABCD)), 54);
    }

    public boolean cycleMaterial(String property) {
        class_2680 material = this.getMaterialItemStorage().getMaterialItem(property).material();
        if (material.method_28498((class_2769)class_2533.field_11625) && material.method_28500((class_2769)class_2533.field_11631).orElse(false).booleanValue()) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2533.field_11625));
        } else if (material.method_28498((class_2769)class_2741.field_12525)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12525));
        } else if (material.method_28498((class_2769)class_2741.field_12481)) {
            this.setMaterial(property, (class_2680)material.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)material.method_11654((class_2769)class_2741.field_12481)).method_10170()));
        } else if (material.method_28498((class_2769)class_2741.field_12496)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12496));
        } else if (material.method_28498((class_2769)class_2741.field_12529)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12529));
        } else if (material.method_28498((class_2769)class_2741.field_12548)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)class_2741.field_12548));
        } else if (material.method_28498((class_2769)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial(property, (class_2680)material.method_28493((class_2769)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    public MaterialItemStorage getMaterialItemStorage() {
        return this.materialItemStorage;
    }

    public void setMaterial(String property, class_2680 blockState) {
        class_2680 wrapperState = this.method_11010();
        class_2680 finalMaterial = blockState;
        if (!this.getMaterialItemStorage().getMaterialItem(property).material().method_27852(finalMaterial.method_26204())) {
            for (class_2350 side : Iterate.directions) {
                MultiStateCopycatBlockEntity cbe;
                class_2680 otherMaterial;
                class_2586 class_25862;
                class_2338 neighbour = this.field_11867.method_10093(side);
                class_2680 neighbourState = this.field_11863.method_8320(neighbour);
                if (neighbourState != wrapperState || !((class_25862 = this.field_11863.method_8321(neighbour)) instanceof MultiStateCopycatBlockEntity) || !(otherMaterial = (cbe = (MultiStateCopycatBlockEntity)class_25862).getMaterialItemStorage().getMaterialItem(property).material()).method_27852(blockState.method_26204())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        MaterialItemStorage.MaterialItem materialItem = this.getMaterialItemStorage().getMaterialItem(property);
        materialItem.setMaterial(blockState);
        this.getMaterialItemStorage().storeMaterialItem(property, materialItem);
        if (!this.field_11863.method_8608()) {
            this.notifyUpdate();
            return;
        }
        this.redraw();
    }

    public void setConsumedItem(String property, class_1799 itemStack) {
        this.getMaterialItemStorage().getMaterialItem(property).setConsumedItem(itemStack);
        this.method_5431();
    }

    public void setEnableCT(String property, boolean value) {
        this.getMaterialItemStorage().getMaterialItem(property).setEnableCT(value);
        this.notifyUpdate();
    }

    public void redraw() {
        if (!this.isVirtual()) {
            this.requestModelUpdate();
        }
        if (this.method_11002()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            this.field_11863.method_8398().method_12130().method_15513(this.method_11016());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state) {
        List<class_1799> stacks = this.getMaterialItemStorage().getAllConsumedItems();
        if (stacks.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public void transform(StructureTransform transform) {
        for (String key : this.getMaterialItemStorage().getAllProperties()) {
            this.getMaterialItemStorage().getMaterialItem(key).setMaterial(transform.apply(this.getMaterialItemStorage().getMaterialItem(key).material()));
        }
        this.notifyUpdate();
    }

    public abstract void requestModelUpdate();

    @Override
    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10566("material_data", (class_2520)this.materialItemStorage.serializeSafe());
    }

    @Override
    public void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("material_data", (class_2520)this.materialItemStorage.serialize());
    }

    @Override
    public void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)class_22482;
            boolean anyUpdated = this.materialItemStorage.deserialize(tag.method_10562("material_data"));
            if (clientPacket && anyUpdated) {
                this.redraw();
            }
        }
    }

    public void migrateData(CopycatBlockEntity copycatBlockEntity) {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)class_22482;
            class_2960 blockId = copycatBlockEntity.method_11010().method_26204().method_40142().method_40237().method_29177();
            Copycats.LOGGER.debug("Converting block({}) at @{} to a multistate copycat", (Object)blockId.toString(), (Object)copycatBlockEntity.method_11016().method_23854());
            MaterialItemStorage.MaterialItem materialItem = this.materialItemStorage.getMaterialItem(this.getMaterialItemStorage().getAllProperties().stream().filter(prop -> mscb.partExists(this.method_11010(), (String)prop)).findFirst().get());
            materialItem.setMaterial(copycatBlockEntity.getMaterial());
            materialItem.setConsumedItem(copycatBlockEntity.getConsumedItem());
            for (String property : mscb.storageProperties()) {
                if (!mscb.partExists(this.method_11010(), property) || this.getMaterialItemStorage().hasCustomMaterial(property)) continue;
                MaterialItemStorage.MaterialItem store = this.materialItemStorage.getMaterialItem(property);
                store.setMaterial(copycatBlockEntity.getMaterial());
                store.setConsumedItem(class_1799.field_8037);
            }
            this.redraw();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static MultiStateCopycatBlockEntity create(class_2591<?> type, class_2338 pos, class_2680 state) {
        void var2_2;
        void var1_1;
        return MultiStateCopycatBlockEntityImpl.create(type, (class_2338)var1_1, (class_2680)var2_2);
    }
}

