/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.multistate;

import com.copycatsplus.copycats.utility.ItemUtils;
import com.copycatsplus.copycats.utility.NBTUtils;
import com.simibubi.create.AllBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class MaterialItemStorage {
    private Map<String, MaterialItem> storage;
    private int maxStorage;

    private MaterialItemStorage(int maxStorage, Set<String> properties) {
        this.storage = new HashMap<String, MaterialItem>(maxStorage);
        this.maxStorage = maxStorage;
        for (String property : properties) {
            this.storage.put(property, new MaterialItem(AllBlocks.COPYCAT_BASE.getDefaultState(), class_1799.field_8037));
        }
    }

    public static MaterialItemStorage create(int maxStorage, Set<String> properties) {
        return new MaterialItemStorage(maxStorage, properties);
    }

    public void storeMaterialItem(String property, MaterialItem materialItem) {
        this.storage.put(property, materialItem);
    }

    @Nullable
    public MaterialItem getMaterialItem(String property) {
        return this.storage.get(property);
    }

    public Set<String> getAllProperties() {
        return this.storage.keySet();
    }

    public Set<class_2680> getAllMaterials() {
        return this.storage.values().stream().map(MaterialItem::material).collect(Collectors.toSet());
    }

    public List<class_1799> getAllConsumedItems() {
        return this.storage.values().stream().map(MaterialItem::consumedItem).dropWhile(itemStack -> itemStack.equals(class_1799.field_8037)).collect(Collectors.toList());
    }

    public Map<String, class_2680> getMaterialMap() {
        return this.storage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ((MaterialItem)s.getValue()).material));
    }

    public boolean hasCustomMaterial(String property) {
        return !this.storage.get(property).material().method_27852((class_2248)AllBlocks.COPYCAT_BASE.get());
    }

    public void remapStorage(Function<String, String> keyMapper) {
        HashMap<String, MaterialItem> newStorage = new HashMap<String, MaterialItem>();
        this.storage.forEach((key, materialItem) -> newStorage.put((String)keyMapper.apply((String)key), (MaterialItem)materialItem));
        this.storage = newStorage;
    }

    public class_2487 serialize() {
        class_2487 root = new class_2487();
        this.storage.forEach((key, materialItem) -> root.method_10566(key, (class_2520)materialItem.serialize()));
        return root;
    }

    public class_2487 serializeSafe() {
        class_2487 root = new class_2487();
        this.storage.forEach((key, materialItem) -> root.method_10566(key, (class_2520)materialItem.serializeSafe()));
        return root;
    }

    public boolean deserialize(class_2487 tag) {
        AtomicBoolean anyUpdated = new AtomicBoolean(false);
        tag.method_10541().forEach(key -> {
            MaterialItem newVersion = MaterialItem.deserialize(tag.method_10562(key));
            MaterialItem oldVersion = this.storage.put((String)key, newVersion);
            if (!(oldVersion == null || newVersion.material() == oldVersion.material() && newVersion.enableCT() == oldVersion.enableCT() || anyUpdated.get())) {
                anyUpdated.set(true);
            }
        });
        return anyUpdated.get();
    }

    public static class MaterialItem {
        public static MaterialItem EMPTY = new MaterialItem(AllBlocks.COPYCAT_BASE.getDefaultState(), class_1799.field_8037);
        private class_2680 material;
        private class_1799 consumedItem;
        private boolean enableCT;

        public MaterialItem(class_2680 material, class_1799 consumedItem) {
            this(material, consumedItem, true);
        }

        public MaterialItem(class_2680 material, class_1799 consumedItem, boolean enableCT) {
            this.material = material;
            this.consumedItem = consumedItem;
            this.enableCT = enableCT;
        }

        public class_2487 serialize() {
            class_2487 root = new class_2487();
            root.method_10566("material", (class_2520)class_2512.method_10686((class_2680)this.material));
            root.method_10566("consumedItem", (class_2520)NBTUtils.serializeStack(this.consumedItem));
            root.method_10556("enableCT", this.enableCT);
            return root;
        }

        public class_2487 serializeSafe() {
            class_2487 root = new class_2487();
            root.method_10566("material", (class_2520)class_2512.method_10686((class_2680)this.material));
            class_1799 stackEmpty = this.consumedItem.method_7972();
            stackEmpty.method_7980(null);
            root.method_10566("consumedItem", (class_2520)NBTUtils.serializeStack(stackEmpty));
            root.method_10556("enableCT", this.enableCT);
            return root;
        }

        public static MaterialItem deserialize(class_2487 tag) {
            return new MaterialItem(class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562("material")), class_1799.method_7915((class_2487)tag.method_10562("consumedItem")), !tag.method_10545("enableCT") || tag.method_10577("enableCT"));
        }

        public class_2680 material() {
            return this.material;
        }

        public class_1799 consumedItem() {
            return this.consumedItem;
        }

        public boolean enableCT() {
            return this.enableCT;
        }

        public void setMaterial(class_2680 material) {
            this.material = material;
        }

        public void setConsumedItem(class_1799 stack) {
            this.consumedItem = ItemUtils.copyStackWithSize(stack, 1);
        }

        public void setEnableCT(boolean enableCT) {
            this.enableCT = enableCT;
        }
    }
}

