/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.assembly.fabric;

import com.copycatsplus.copycats.content.copycat.base.model.assembly.Assembler;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableAABB;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableCullFace;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableQuad;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableUV;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableVec3;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableVertex;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.quad.QuadTransform;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class AssemblerImpl {
    static SpriteFinder spriteFinder = SpriteFinder.get((class_1059)class_310.method_1551().method_1554().method_24153(class_1723.field_21668));

    public static void assemblePiece(Assembler.CopycatRenderContext<?, ?> ctx, GlobalTransform globalTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull) {
        CopycatRenderContextFabric context = (CopycatRenderContextFabric)ctx;
        globalTransform.apply(select);
        globalTransform.apply(offset);
        globalTransform.apply(cull);
        if (cull.isCulled(((MutableQuadView)context.source()).lightFace())) {
            return;
        }
        AssemblerImpl.assembleQuad((MutableQuadView)context.source(), (QuadEmitter)context.destination(), select.toAABB(), offset.toVec3().method_1023(select.minX, select.minY, select.minZ));
    }

    public static void assemblePiece(Assembler.CopycatRenderContext<?, ?> ctx, GlobalTransform globalTransform, MutableVec3 offset, MutableAABB select, MutableCullFace cull, QuadTransform ... transforms) {
        CopycatRenderContextFabric context = (CopycatRenderContextFabric)ctx;
        globalTransform.apply(select);
        globalTransform.apply(offset);
        globalTransform.apply(cull);
        if (cull.isCulled(((MutableQuadView)context.source()).lightFace())) {
            return;
        }
        AssemblerImpl.assembleQuad((MutableQuadView)context.source(), (QuadEmitter)context.destination(), select.toAABB(), offset.toVec3().method_1023(select.minX, select.minY, select.minZ), globalTransform, transforms);
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx) {
        CopycatRenderContextFabric context = (CopycatRenderContextFabric)ctx;
        AssemblerImpl.assembleQuad((MutableQuadView)context.source(), (QuadEmitter)context.destination());
    }

    public static <Source extends MutableQuadView, Destination extends QuadEmitter> void assembleQuad(Source src, Destination dest) {
        dest.copyFrom(src);
        dest.emit();
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx, class_238 crop, class_243 move) {
        CopycatRenderContextFabric context = (CopycatRenderContextFabric)ctx;
        AssemblerImpl.assembleQuad((MutableQuadView)context.source(), (QuadEmitter)context.destination(), crop, move);
    }

    public static void assembleQuad(Assembler.CopycatRenderContext<?, ?> ctx, class_238 crop, class_243 move, QuadTransform ... transforms) {
        CopycatRenderContextFabric context = (CopycatRenderContextFabric)ctx;
        AssemblerImpl.assembleQuad((MutableQuadView)context.source(), (QuadEmitter)context.destination(), crop, move, GlobalTransform.IDENTITY, transforms);
    }

    public static <Source extends MutableQuadView, Destination extends QuadEmitter> void assembleQuad(Source src, Destination dest, class_238 crop, class_243 move) {
        dest.copyFrom(src);
        BakedModelHelper.cropAndMove(dest, (class_1058)spriteFinder.find(src), (class_238)crop, (class_243)move);
        dest.emit();
    }

    public static <Source extends MutableQuadView, Destination extends QuadEmitter> void assembleQuad(Source src, Destination dest, class_238 crop, class_243 move, GlobalTransform globalTransform, QuadTransform ... transforms) {
        dest.copyFrom(src);
        class_1058 sprite = spriteFinder.find(src);
        BakedModelHelper.cropAndMove(dest, (class_1058)sprite, (class_238)crop, (class_243)move);
        MutableQuad mutableQuad = AssemblerImpl.getMutableQuad(dest);
        globalTransform.apply(mutableQuad);
        mutableQuad.undoMutate();
        for (QuadTransform transform : transforms) {
            transform.transformVertices(mutableQuad, sprite);
        }
        mutableQuad.mutate();
        for (int i = 0; i < 4; ++i) {
            BakedQuadHelper.setXYZ(dest, (int)i, (class_243)mutableQuad.vertices.get((int)i).xyz.toVec3());
            dest.uv(i, mutableQuad.vertices.get((int)i).uv.u, mutableQuad.vertices.get((int)i).uv.v);
        }
        dest.emit();
    }

    public static <T> MutableQuad getMutableQuad(T data) {
        MutableQuadView vertexData = (MutableQuadView)data;
        ArrayList<MutableVertex> vertices = new ArrayList<MutableVertex>(4);
        for (int i = 0; i < 4; ++i) {
            MutableVec3 xyz = new MutableVec3(vertexData.x(i), vertexData.y(i), vertexData.z(i));
            MutableUV uv = new MutableUV(vertexData.u(i), vertexData.v(i));
            vertices.add(new MutableVertex(xyz, uv));
        }
        return new MutableQuad(vertices, vertexData.lightFace());
    }

    public static class CopycatRenderContextFabric
    extends Assembler.CopycatRenderContext<MutableQuadView, QuadEmitter> {
        public CopycatRenderContextFabric(MutableQuadView source, QuadEmitter destination) {
            super(source, destination);
        }
    }
}

