/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.assembly;

import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class MutableVec3
implements GlobalTransform.Transformable<MutableVec3>,
class_2374 {
    public double x;
    public double y;
    public double z;

    public MutableVec3(class_2374 position) {
        this(position.method_10216(), position.method_10214(), position.method_10215());
    }

    public MutableVec3(double x, double y, double z) {
        this.set(x, y, z);
    }

    @Override
    public MutableVec3 rotateY(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> this.set(1.0 - this.z, this.y, this.x);
            case 180 -> this.set(1.0 - this.x, this.y, 1.0 - this.z);
            case 270 -> this.set(this.z, this.y, 1.0 - this.x);
            default -> this;
        };
    }

    @Override
    public MutableVec3 rotateX(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> this.set(this.x, this.z, 1.0 - this.y);
            case 180 -> this.set(this.x, 1.0 - this.y, 1.0 - this.z);
            case 270 -> this.set(this.x, 1.0 - this.z, this.y);
            default -> this;
        };
    }

    @Override
    public MutableVec3 rotateZ(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 90 -> this.set(this.y, 1.0 - this.x, this.z);
            case 180 -> this.set(1.0 - this.x, 1.0 - this.y, this.z);
            case 270 -> this.set(1.0 - this.y, this.x, this.z);
            default -> this;
        };
    }

    @Override
    public MutableVec3 flipX(boolean flip) {
        if (!flip) {
            return this;
        }
        return this.set(1.0 - this.x, this.y, this.z);
    }

    @Override
    public MutableVec3 flipY(boolean flip) {
        if (!flip) {
            return this;
        }
        return this.set(this.x, 1.0 - this.y, this.z);
    }

    @Override
    public MutableVec3 flipZ(boolean flip) {
        if (!flip) {
            return this;
        }
        return this.set(this.x, this.y, 1.0 - this.z);
    }

    public class_243 toVec3() {
        return new class_243(this.x, this.y, this.z);
    }

    public MutableVec3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public double get(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> this.x;
            case class_2350.class_2351.field_11052 -> this.y;
            case class_2350.class_2351.field_11051 -> this.z;
        };
    }

    public MutableVec3 set(class_2350.class_2351 axis, double value) {
        switch (axis) {
            case field_11048: {
                this.x = value;
                break;
            }
            case field_11052: {
                this.y = value;
                break;
            }
            case field_11051: {
                this.z = value;
            }
        }
        return this;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public MutableVec3 add(class_2374 vec) {
        return this.add(vec.method_10216(), vec.method_10214(), vec.method_10215());
    }

    public MutableVec3 add(double x, double y, double z) {
        return this.set(this.x + x, this.y + y, this.z + z);
    }

    public MutableVec3 subtract(class_2374 vec) {
        return this.set(this.x - vec.method_10216(), this.y - vec.method_10214(), this.z - vec.method_10215());
    }

    public MutableVec3 scale(double scale) {
        return this.set(this.x * scale, this.y * scale, this.z * scale);
    }

    public MutableVec3 multiply(class_2374 vec) {
        return this.set(this.x * vec.method_10216(), this.y * vec.method_10214(), this.z * vec.method_10215());
    }

    public MutableVec3 rotate(class_2374 rotationVec) {
        return this.rotate(rotationVec.method_10216(), rotationVec.method_10214(), rotationVec.method_10215());
    }

    public MutableVec3 rotate(double xRot, double yRot, double zRot) {
        this.rotate(xRot, class_2350.class_2351.field_11048);
        this.rotate(yRot, class_2350.class_2351.field_11052);
        this.rotate(zRot, class_2350.class_2351.field_11051);
        return this;
    }

    public MutableVec3 rotate(double deg, class_2350.class_2351 axis) {
        if (deg == 0.0) {
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = class_3532.method_15374((float)angle);
        double cos = class_3532.method_15362((float)angle);
        double x = this.x;
        double y = this.y;
        double z = this.z;
        if (axis == class_2350.class_2351.field_11048) {
            this.y = y * cos - z * sin;
            this.z = z * cos + y * sin;
        } else if (axis == class_2350.class_2351.field_11052) {
            this.x = x * cos + z * sin;
            this.z = z * cos - x * sin;
        } else if (axis == class_2350.class_2351.field_11051) {
            this.x = x * cos - y * sin;
            this.y = y * cos + x * sin;
        }
        return this;
    }

    public double dot(class_2374 vec) {
        return this.x * vec.method_10216() + this.y * vec.method_10214() + this.z * vec.method_10215();
    }

    public MutableVec3 cross(class_2374 vec) {
        return this.set(this.y * vec.method_10215() - this.z * vec.method_10214(), this.z * vec.method_10216() - this.x * vec.method_10215(), this.x * vec.method_10214() - this.y * vec.method_10216());
    }

    public double distanceTo(class_2374 vec) {
        double d = vec.method_10216() - this.x;
        double e = vec.method_10214() - this.y;
        double f = vec.method_10215() - this.z;
        return Math.sqrt(d * d + e * e + f * f);
    }

    public double distanceToSqr(class_2374 vec) {
        double d = vec.method_10216() - this.x;
        double e = vec.method_10214() - this.y;
        double f = vec.method_10215() - this.z;
        return d * d + e * e + f * f;
    }

    public double distanceToSqr(double x, double y, double z) {
        double d = x - this.x;
        double e = y - this.y;
        double f = z - this.z;
        return d * d + e * e + f * f;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double horizontalDistance() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double horizontalDistanceSqr() {
        return this.x * this.x + this.z * this.z;
    }

    public MutableVec3 normalize() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d < 1.0E-4) {
            return this.set(0.0, 0.0, 0.0);
        }
        return this.set(this.x / d, this.y / d, this.z / d);
    }

    public MutableVec3 copy() {
        return new MutableVec3(this.x, this.y, this.z);
    }

    public double method_10216() {
        return this.x;
    }

    public double method_10214() {
        return this.y;
    }

    public double method_10215() {
        return this.z;
    }

    public static class AsScale
    extends MutableVec3 {
        public AsScale(double x, double y, double z) {
            super(x, y, z);
        }
    }

    public static class AsAngle
    extends MutableVec3 {
        public AsAngle(double x, double y, double z) {
            super(x, y, z);
        }
    }

    public static class AsPivot
    extends MutableVec3 {
        public AsPivot(double x, double y, double z) {
            super(x, y, z);
        }
    }
}

