/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.assembly;

import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableVertex;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.Mutation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;

public class MutableQuad
implements GlobalTransform.Transformable<MutableQuad> {
    public List<MutableVertex> vertices;
    public class_2350 direction;
    List<Mutation> mutations = new ArrayList<Mutation>();

    public MutableQuad(List<MutableVertex> vertices, class_2350 direction) {
        this.vertices = vertices;
        this.direction = direction;
    }

    public MutableQuad mutate() {
        for (Mutation mutation : this.mutations) {
            for (MutableVertex vertex : this.vertices) {
                mutation.mutate(vertex.xyz);
            }
            this.direction = mutation.mutate(this.direction);
        }
        return this;
    }

    public MutableQuad undoMutate() {
        for (int i = this.mutations.size() - 1; i >= 0; --i) {
            Mutation mutation = this.mutations.get(i);
            for (MutableVertex vertex : this.vertices) {
                mutation.undoMutate(vertex.xyz);
            }
            this.direction = mutation.undoMutate(this.direction);
        }
        return this;
    }

    @Override
    public MutableQuad rotateX(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_X, angle));
        return this;
    }

    @Override
    public MutableQuad rotateY(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_Y, angle));
        return this;
    }

    @Override
    public MutableQuad rotateZ(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_Z, angle));
        return this;
    }

    @Override
    public MutableQuad flipX(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 0));
        return this;
    }

    @Override
    public MutableQuad flipY(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 1));
        return this;
    }

    @Override
    public MutableQuad flipZ(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 2));
        return this;
    }
}

