/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcat_lib.util;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class PointMover {
    private double x;
    private double y;
    private final List<Double> xList;
    private final List<Double> yList;
    private final int indexOf;
    private final int time;
    private final double speed;
    private double alpha;

    public PointMover(double x, double y, int timeMilliseconds, double speed) {
        this.x = x;
        this.y = y;
        this.xList = null;
        this.yList = null;
        this.indexOf = -1;
        this.time = timeMilliseconds;
        this.speed = speed;
        this.alpha = 0.0;
    }

    public PointMover(List<Double> xList, List<Double> yList, int indexOf, int timeMilliseconds, double speed) {
        this.x = 0.0;
        this.y = 0.0;
        this.xList = xList;
        this.yList = yList;
        this.indexOf = indexOf;
        this.time = timeMilliseconds;
        this.speed = speed;
        this.alpha = 0.0;
    }

    public void moveTo(double newX, double newY) {
        double dx = newX - this.x;
        double dy = newY - this.y;
        if (this.xList != null && this.yList != null && this.indexOf >= 0) {
            dx = newX - this.xList.get(this.indexOf);
            dy = newY - this.yList.get(this.indexOf);
        }
        double distance = Math.sqrt(dx * dx + dy * dy);
        final int numSteps = (int)(distance / this.speed);
        final double stepX = dx / (double)numSteps;
        final double stepY = dy / (double)numSteps;
        final double stepAlpha = 1.0 / (double)numSteps;
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            private int stepCount = 0;

            @Override
            public void run() {
                if (this.stepCount < numSteps) {
                    if (PointMover.this.xList != null && PointMover.this.yList != null && PointMover.this.indexOf >= 0) {
                        PointMover.this.xList.set(PointMover.this.indexOf, PointMover.this.xList.get(PointMover.this.indexOf) + stepX);
                        PointMover.this.yList.set(PointMover.this.indexOf, PointMover.this.yList.get(PointMover.this.indexOf) + stepY);
                        System.out.println("Position: (" + PointMover.this.xList.get(PointMover.this.indexOf) + ", " + PointMover.this.yList.get(PointMover.this.indexOf) + "), Alpha: " + PointMover.this.alpha);
                    } else {
                        PointMover.this.x += stepX;
                        PointMover.this.y += stepY;
                        System.out.println("Position: (" + PointMover.this.x + ", " + PointMover.this.y + "), Alpha: " + PointMover.this.alpha);
                    }
                    PointMover.this.alpha += stepAlpha;
                    ++this.stepCount;
                } else {
                    timer.cancel();
                }
            }
        }, 0L, (long)this.time);
    }
}

