/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcat_lib.common.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.ixdarklord.coolcat_lib.common.crafting.ICondition;
import net.ixdarklord.coolcat_lib.common.crafting.IConditionSerializer;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<class_2960, IConditionSerializer<?>> conditions = new HashMap();

    public static IConditionSerializer<?> register(IConditionSerializer<?> serializer) {
        class_2960 key = serializer.getID();
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition serializer: " + key);
        }
        conditions.put(key, serializer);
        return serializer;
    }

    public static boolean processConditions(JsonObject json, String memberName, ICondition.IContext context) {
        return !json.has(memberName) || CraftingHelper.processConditions(class_3518.method_15261((JsonObject)json, (String)memberName), context);
    }

    public static boolean processConditions(JsonArray conditions, ICondition.IContext context) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (CraftingHelper.getCondition(json).test(context)) continue;
            return false;
        }
        return true;
    }

    public static ICondition getCondition(JsonObject json) {
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        IConditionSerializer<?> serializer = conditions.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type);
        }
        return serializer.read(json);
    }

    public static <T extends ICondition> JsonObject serialize(T condition) {
        IConditionSerializer<?> serializer = conditions.get(condition.getID());
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + condition.getID().toString());
        }
        return serializer.getJson(condition);
    }

    public static JsonArray serialize(ICondition ... conditions) {
        JsonArray arr = new JsonArray();
        for (ICondition iCond : conditions) {
            arr.add((JsonElement)CraftingHelper.serialize(iCond));
        }
        return arr;
    }
}

