/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcat_lib.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ixdarklord.coolcat_lib.common.crafting.CraftingHelper;
import net.ixdarklord.coolcat_lib.common.crafting.ICondition;
import net.minecraft.class_161;
import net.minecraft.class_2444;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class ConditionalAdvancement {
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public static JsonObject processConditional(JsonObject json, ICondition.IContext context) {
        JsonArray entries = class_3518.method_15292((JsonObject)json, (String)"advancements", null);
        if (entries == null) {
            return CraftingHelper.processConditions(json, "conditions", context) ? json : null;
        }
        int idx = 0;
        for (JsonElement ele : entries) {
            if (!ele.isJsonObject()) {
                throw new JsonSyntaxException("Invalid advancement entry at index " + idx + " Must be JsonObject");
            }
            if (CraftingHelper.processConditions(class_3518.method_15261((JsonObject)ele.getAsJsonObject(), (String)"conditions"), context)) {
                return class_3518.method_15296((JsonObject)ele.getAsJsonObject(), (String)"advancement");
            }
            ++idx;
        }
        return null;
    }

    public static class Builder {
        private List<ICondition[]> conditions = new ArrayList<ICondition[]>();
        private List<Supplier<JsonElement>> advancements = new ArrayList<Supplier<JsonElement>>();
        private List<ICondition> currentConditions = new ArrayList<ICondition>();
        private boolean locked = false;

        public Builder addCondition(ICondition condition) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            this.currentConditions.add(condition);
            return this;
        }

        public Builder addAdvancement(Consumer<Consumer<class_161.class_162>> callable) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            callable.accept(this::addAdvancement);
            return this;
        }

        public Builder addAdvancement(class_161.class_162 advancement) {
            return this.addAdvancement(() -> ((class_161.class_162)advancement).method_698());
        }

        public Builder addAdvancement(class_2444 fromRecipe) {
            return this.addAdvancement(() -> ((class_2444)fromRecipe).method_10415());
        }

        private Builder addAdvancement(Supplier<JsonElement> jsonSupplier) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            if (this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Can not add a advancement with no conditions.");
            }
            this.conditions.add(this.currentConditions.toArray(new ICondition[this.currentConditions.size()]));
            this.advancements.add(jsonSupplier);
            this.currentConditions.clear();
            return this;
        }

        public JsonObject write() {
            if (!this.locked) {
                if (!this.currentConditions.isEmpty()) {
                    throw new IllegalStateException("Invalid builder state: Orphaned conditions");
                }
                if (this.advancements.isEmpty()) {
                    throw new IllegalStateException("Invalid builder state: No Advancements");
                }
                this.locked = true;
            }
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            for (int x = 0; x < this.conditions.size(); ++x) {
                JsonObject holder = new JsonObject();
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions.get(x)) {
                    conds.add((JsonElement)CraftingHelper.serialize(c));
                }
                holder.add("conditions", (JsonElement)conds);
                holder.add("advancement", this.advancements.get(x).get());
                array.add((JsonElement)holder);
            }
            return json;
        }
    }
}

