/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcat_lib.common.brewing.fabric;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.ixdarklord.coolcat_lib.common.brewing.fabric.BrewingRecipe;
import net.ixdarklord.coolcat_lib.common.brewing.fabric.IBrewingRecipe;
import net.ixdarklord.coolcat_lib.common.brewing.fabric.VanillaBrewingRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;

public class BrewingRecipeRegistry {
    private static final List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(class_1856 input, class_1856 ingredient, class_1799 output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static class_1799 getOutput(class_1799 input, class_1799 ingredient) {
        if (input.method_7960() || input.method_7947() != 1) {
            return class_1799.field_8037;
        }
        if (ingredient.method_7960()) {
            return class_1799.field_8037;
        }
        for (IBrewingRecipe recipe : recipes) {
            class_1799 output = recipe.getOutput(input, ingredient);
            if (output.method_7960()) continue;
            return output;
        }
        return class_1799.field_8037;
    }

    public static boolean hasOutput(class_1799 input, class_1799 ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).method_7960();
    }

    public static boolean canBrew(class_2371<class_1799> inputs, class_1799 ingredient, int[] inputIndexes) {
        if (ingredient.method_7960()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput((class_1799)inputs.get(i), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(class_2371<class_1799> inputs, class_1799 ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            class_1799 output = BrewingRecipeRegistry.getOutput((class_1799)inputs.get(i), ingredient);
            if (output.method_7960()) continue;
            inputs.set(i, (Object)output);
        }
    }

    public static boolean isValidIngredient(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(class_1799 stack) {
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    public static List<BrewingRecipe> getBrewingRecipes() {
        return BrewingRecipeRegistry.getRecipes().stream().filter(i -> i instanceof BrewingRecipe).map(i -> (BrewingRecipe)i).collect(Collectors.toList());
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

