/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcat_lib.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.ixdarklord.coolcat_lib.util.ColorUtils;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TextScreen
extends class_332 {
    private final List<Interface> interfacesList = new ArrayList<Interface>();
    private final class_327 font;
    private final int posX;
    private final int posY;
    private int width;
    private int height;
    private final boolean drawShadow;
    private int widthOld = -1;
    private int heightOld = -1;
    private int boxIndex;

    public TextScreen(int posX, int posY, int width, int height, boolean drawShadow) {
        super(class_310.method_1551(), class_4597.method_22991((class_287)new class_287(256)));
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
        this.drawShadow = drawShadow;
        this.font = class_310.method_1551().field_1772;
        this.boxIndex = -1;
    }

    public TextScreen build(int count) {
        for (int i = 0; i < count; ++i) {
            this.interfacesList.add(new Interface(new ArrayList<class_5481>(), false, this.interfacesList.isEmpty()));
            this.boxIndex = 0;
        }
        return this;
    }

    public TextScreen selectBox(int boxIndex) {
        if (boxIndex >= this.interfacesList.size() || boxIndex < 0) {
            throw new IndexOutOfBoundsException("Theres is no such a box with index: " + boxIndex);
        }
        this.boxIndex = boxIndex;
        return this;
    }

    public TextScreen shouldRender(boolean state) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        this.interfacesList.get((int)this.boxIndex).render = state;
        return this;
    }

    public TextScreen alignPosToCenter(boolean state) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        this.interfacesList.get((int)this.boxIndex).centered = state;
        return this;
    }

    public TextScreen backgroundColor(Color colorRGBA) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        this.interfacesList.get((int)this.boxIndex).backgroundColor = colorRGBA;
        return this;
    }

    public void renderBox(class_332 guiGraphics) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        if (!this.interfacesList.get((int)this.boxIndex).render) {
            return;
        }
        List<class_5481> selected = this.interfacesList.get((int)this.boxIndex).sequences;
        int offset = this.interfacesList.get((int)this.boxIndex).scrollOffset;
        int length = this.getBoxLinesLength();
        this.interfacesList.get((int)this.boxIndex).scrollOffset = class_3532.method_15340((int)this.interfacesList.get((int)this.boxIndex).scrollOffset, (int)0, (int)(selected.size() - length));
        for (int m = 0; m < length; ++m) {
            class_5481 sequences = selected.get(Math.min(m + offset, selected.size() - 1));
            float posX = this.posX;
            float posY = this.posY;
            int color = Objects.requireNonNull(class_5251.method_27718((class_124)class_124.field_1068)).method_27716();
            if (this.interfacesList.get((int)this.boxIndex).centered) {
                posY += (float)this.height / 2.0f;
                float k = (float)this.font.method_30880(sequences) / 2.0f;
                float j = (float)selected.size() * 7.35f / 2.0f;
                int n = (int)((posX += (float)this.width / 2.0f) - k);
                Objects.requireNonNull(this.font);
                this.method_51430(this.font, sequences, n, (int)(posY - j + (float)(9 * m)), color, this.drawShadow);
                continue;
            }
            int n = (int)posX;
            Objects.requireNonNull(this.font);
            this.method_51430(this.font, sequences, n, (int)(posY + (float)(m * 9)), color, this.drawShadow);
        }
    }

    public void renderAllBoxes(class_332 guiGraphics, int backgroundColor, Color shaderColor) {
        if (this.interfacesList.isEmpty()) {
            throw new IndexOutOfBoundsException("There is no interface created.");
        }
        class_4587 poseStack = guiGraphics.method_51448();
        for (int i = 0; i < this.interfacesList.size(); ++i) {
            if (!this.interfacesList.get((int)i).render) continue;
            this.selectBox(i);
            List<class_5481> selected = this.interfacesList.get((int)i).sequences;
            Objects.requireNonNull(this.font);
            int length = Math.min(this.height / 9, this.interfacesList.get((int)i).sequences.size());
            int offset = this.interfacesList.get((int)i).scrollOffset = class_3532.method_15340((int)this.interfacesList.get((int)i).scrollOffset, (int)0, (int)(selected.size() - length));
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, (float)i);
            for (int m = 0; m < length; ++m) {
                class_5481 sequence = selected.get(Math.min(m + offset, selected.size() - 1));
                float posX = this.posX;
                float posY = this.posY;
                int color = Color.WHITE.getRGB();
                if (this.interfacesList.get((int)i).centered) {
                    posY += (float)this.height / 2.0f;
                    float k = (float)this.font.method_30880(sequence) / 2.0f;
                    float j = (float)selected.size() * 7.35f / 2.0f;
                    int n = (int)((posX += (float)this.width / 2.0f) - k);
                    Objects.requireNonNull(this.font);
                    this.method_51430(this.font, sequence, n, (int)(posY - j + (float)(9 * m)), color, this.drawShadow);
                    continue;
                }
                int n = (int)posX;
                Objects.requireNonNull(this.font);
                this.method_51430(this.font, sequence, n, (int)(posY + (float)(m * 9)), color, this.drawShadow);
            }
            int renderedInterfaces = this.interfacesList.stream().filter(box -> box.render).toList().size();
            if (renderedInterfaces > 1 && i < this.interfacesList.size() - 1) {
                Color bgColor = this.interfacesList.get((int)(i + 1)).backgroundColor;
                int color = bgColor != null ? ColorUtils.RGBToRGBA(bgColor.getRGB(), (float)bgColor.getAlpha() / 255.0f) : ColorUtils.RGBToRGBA(backgroundColor, 0.85f);
                int width = this.widthOld > 1 ? this.widthOld : this.width;
                int height = this.heightOld > 1 ? this.heightOld : this.height;
                RenderSystem.setShaderColor((float)((float)shaderColor.getRed() / 255.0f), (float)((float)shaderColor.getGreen() / 255.0f), (float)((float)shaderColor.getBlue() / 255.0f), (float)((float)shaderColor.getAlpha() / 255.0f));
                this.method_51739(class_1921.method_51785(), this.posX - 1, this.posY - 1, this.posX + width, this.posY + height, color);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            poseStack.method_22909();
        }
    }

    public void scrollTo(int pos, boolean replace) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        List<class_5481> selected = this.interfacesList.get((int)this.boxIndex).sequences;
        this.interfacesList.get((int)this.boxIndex).scrollOffset = replace ? pos : this.interfacesList.get((int)this.boxIndex).scrollOffset + pos;
        this.interfacesList.get((int)this.boxIndex).scrollOffset = class_3532.method_15340((int)this.interfacesList.get((int)this.boxIndex).scrollOffset, (int)0, (int)(selected.size() - this.getBoxLinesLength()));
    }

    public class_2583 getComponentStyleAt(double mouseX, double mouseY) {
        int linePos;
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        List<class_5481> selected = this.interfacesList.get((int)this.boxIndex).sequences;
        int offset = this.interfacesList.get((int)this.boxIndex).scrollOffset;
        if (selected.isEmpty()) {
            return null;
        }
        int i = class_3532.method_15357((double)(mouseX - (double)this.posX));
        int j = class_3532.method_15357((double)(mouseY - (double)this.posY));
        if (i < 0 || j < 0) {
            return null;
        }
        if (i > this.width || j > this.height) {
            return null;
        }
        if (this.interfacesList.get((int)this.boxIndex).centered) {
            int textBoxHeight = this.height;
            Objects.requireNonNull(this.font);
            int lineHeight = 9;
            int totalLines = selected.size();
            int centerOffset = (textBoxHeight - totalLines * lineHeight) / 2;
            if ((j -= 2) < centerOffset || j > centerOffset + totalLines * lineHeight) {
                return null;
            }
            linePos = (j - centerOffset) / lineHeight;
        } else {
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            if (j >= 9 * Math.min(this.height / 9, selected.size())) {
                return null;
            }
            Objects.requireNonNull(this.font);
            linePos = j / 9;
        }
        if (linePos >= selected.size()) {
            return null;
        }
        class_5481 sequence = selected.get(Math.min(linePos + offset, selected.size() - 1));
        if (this.interfacesList.get((int)this.boxIndex).centered) {
            int textBoxWidth = this.width / 2;
            int lineWidth = this.font.method_30880(sequence) / 2;
            i -= textBoxWidth - lineWidth;
        }
        return this.font.method_27527().method_30876(sequence, i);
    }

    public boolean canScroll() {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        Objects.requireNonNull(this.font);
        return this.height / 9 < this.interfacesList.get((int)this.boxIndex).sequences.size();
    }

    public boolean isEmpty() {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        return this.interfacesList.get((int)this.boxIndex).sequences.isEmpty();
    }

    public TextScreen create(class_2561 text, class_124 ... formats) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        ArrayList result = new ArrayList(class_2477.method_10517().method_30933(this.font.method_27527().method_27495((class_5348)text, this.width, class_2583.field_24360.method_27705(formats))));
        if (!this.interfacesList.get((int)this.boxIndex).sequences.isEmpty()) {
            this.interfacesList.get((int)this.boxIndex).sequences.add(class_5481.field_26385);
            this.interfacesList.get((int)this.boxIndex).sequences.addAll(result);
            return this;
        }
        this.interfacesList.get((int)this.boxIndex).sequences.addAll(result);
        return this;
    }

    public TextScreen create(class_2561 title, class_2561 description, class_124 ... formats) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        ArrayList result = new ArrayList();
        result.addAll(class_2477.method_10517().method_30933(this.font.method_27527().method_27495((class_5348)title, this.width, class_2583.field_24360.method_27705(formats))));
        result.addAll(class_2477.method_10517().method_30933(this.font.method_27527().method_27495((class_5348)description, this.width, class_2583.field_24360.method_27705(formats))));
        if (!this.interfacesList.get((int)this.boxIndex).sequences.isEmpty()) {
            this.interfacesList.get((int)this.boxIndex).sequences.add(class_5481.field_26385);
            this.interfacesList.get((int)this.boxIndex).sequences.addAll(result);
            return this;
        }
        this.interfacesList.get((int)this.boxIndex).sequences.addAll(result);
        return this;
    }

    public TextScreen add(class_5481 formattedCharSequence) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        this.interfacesList.get((int)this.boxIndex).sequences.add(formattedCharSequence);
        return this;
    }

    public void addAll(List<class_5481> formattedCharSequences) {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        this.interfacesList.get((int)this.boxIndex).sequences.addAll(formattedCharSequences);
    }

    public void clear() {
        this.interfacesList.forEach(anInterface -> {
            anInterface.sequences.clear();
            anInterface.backgroundColor = null;
        });
    }

    public boolean canRender() {
        return this.interfacesList.get((int)this.boxIndex).render;
    }

    public int getBoxLinesLength() {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        Objects.requireNonNull(this.font);
        return Math.min(this.height / 9, this.interfacesList.get((int)this.boxIndex).sequences.size());
    }

    public int getRemainingLines() {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        return this.interfacesList.get((int)this.boxIndex).sequences.size() - this.getBoxLinesLength();
    }

    public int getScrollOffset() {
        if (this.boxIndex == -1) {
            throw new IndexOutOfBoundsException("There is no selected box.");
        }
        return this.interfacesList.get((int)this.boxIndex).scrollOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int size, boolean cacheFirstValue) {
        if (cacheFirstValue && this.widthOld == -1) {
            this.widthOld = this.width;
        }
        this.width = size;
    }

    public void setHeight(int size, boolean cacheFirstValue) {
        if (cacheFirstValue && this.heightOld == -1) {
            this.heightOld = this.height;
        }
        this.height = size;
    }

    private static class Interface {
        private final List<class_5481> sequences;
        private boolean centered;
        private boolean render;
        private Color backgroundColor;
        private int scrollOffset;

        private Interface(List<class_5481> sequences, boolean centered, boolean render) {
            this.sequences = sequences;
            this.centered = centered;
            this.render = render;
        }
    }
}

