/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class PocketComputerItem
extends class_1792
implements IComputerItem,
IMedia,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_ON = "On";
    private static final String NBT_INSTANCE = "InstanceId";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public PocketComputerItem(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public class_1799 create(int id, @Nullable String label, int colour, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        class_1799 result = new class_1799((class_1935)this);
        if (id >= 0) {
            result.method_7948().method_10569("ComputerId", id);
        }
        if (label != null) {
            result.method_7977((class_2561)class_2561.method_43470((String)label));
        }
        if (upgrade != null) {
            result.method_7948().method_10582(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            if (!upgrade.data().method_33133()) {
                result.method_7948().method_10566(NBT_UPGRADE_INFO, (class_2520)upgrade.data().method_10553());
            }
        }
        if (colour != -1) {
            result.method_7948().method_10569("Color", colour);
        }
        return result;
    }

    private boolean tick(class_1799 stack, class_1937 world, class_1297 entity, PocketServerComputer computer) {
        boolean on;
        String label;
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        computer.setLevel((class_3218)world);
        computer.updateValues(entity, stack, upgrade);
        boolean changed = false;
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            PocketComputerItem.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.method_7948().method_10556(NBT_ON, on);
        }
        if (upgrade != null) {
            upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
        }
        return changed;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slotNum, boolean selected) {
        class_1661 class_16612;
        if (world.field_9236) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_16612 = player.method_31548();
        } else {
            class_16612 = null;
        }
        class_1661 inventory = class_16612;
        PocketServerComputer computer = this.createServerComputer((class_3218)world, entity, (class_1263)inventory, stack);
        computer.keepAlive();
        boolean changed = this.tick(stack, world, entity, computer);
        if (changed && inventory != null) {
            inventory.method_5431();
        }
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 || level.method_8503() == null) {
            return false;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(level.method_8503(), stack);
        if (computer != null && this.tick(stack, entity.method_37908(), (class_1297)entity, computer)) {
            entity.method_6979(stack.method_7972());
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketServerComputer computer = this.createServerComputer((class_3218)world, (class_1297)player, (class_1263)player.method_31548(), stack);
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                computer.updateValues((class_1297)player, stack, upgrade);
                stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
            }
            if (!stop) {
                boolean isTypingOnly = hand == class_1268.field_5810;
                new ComputerContainerData(computer, stack).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new class_1271(class_1269.method_29236((boolean)world.field_9236), (Object)stack);
    }

    public class_2561 method_7864(class_1799 stack) {
        String baseString = this.method_7866(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{class_2561.method_43471((String)upgrade.getUnlocalisedAdjective())});
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 flag) {
        int id;
        if ((flag.method_8035() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((class_2561)class_2561.method_43469((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id}).method_27692(class_124.field_1080));
        }
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        String mod;
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.instance().getOwner(upgrade)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    public PocketServerComputer createServerComputer(class_3218 level, class_1297 entity, @Nullable class_1263 inventory, class_1799 stack) {
        ServerComputerRegistry registry = ServerContext.get(level.method_8503()).registry();
        PocketServerComputer computer = (PocketServerComputer)registry.get(PocketComputerItem.getSessionID(stack), PocketComputerItem.getInstanceID(stack));
        if (computer == null) {
            int computerID = this.getComputerID(stack);
            if (computerID < 0) {
                computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(level.method_8503(), "computer");
                PocketComputerItem.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(level, entity.method_24515(), this.getComputerID(stack), this.getLabel(stack), this.getFamily());
            class_2487 tag = stack.method_7948();
            tag.method_10569(NBT_SESSION, registry.getSessionID());
            tag.method_25927(NBT_INSTANCE, computer.register());
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            computer.updateValues(entity, stack, upgrade);
            computer.addAPI(new PocketAPI(computer));
            if (PocketComputerItem.isMarkedOn(stack) && entity instanceof class_1657) {
                computer.turnOn();
            }
            if (inventory != null) {
                inventory.method_5431();
            }
        }
        computer.setLevel(level);
        return computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(MinecraftServer server, class_1799 stack) {
        return (PocketServerComputer)ServerContext.get(server).registry().get(PocketComputerItem.getSessionID(stack), PocketComputerItem.getInstanceID(stack));
    }

    private static void setComputerID(class_1799 stack, int computerID) {
        stack.method_7948().method_10569("ComputerId", computerID);
    }

    @Override
    @Nullable
    public String getLabel(class_1799 stack) {
        return IComputerItem.super.getLabel(stack);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public class_1799 changeItem(class_1799 stack, class_1792 newItem) {
        class_1799 class_17992;
        if (newItem instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)newItem;
            class_17992 = pocket.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), PocketComputerItem.getUpgradeWithData(stack));
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    @Override
    public boolean setLabel(class_1799 stack, @Nullable String label) {
        if (label != null) {
            stack.method_7977((class_2561)class_2561.method_43470((String)label));
        } else {
            stack.method_7925();
        }
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(class_1799 stack, class_3218 level) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(level.method_8503(), "computer/" + id, Config.computerSpaceLimit);
        }
        return null;
    }

    @Nullable
    public static UUID getInstanceID(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_25928(NBT_INSTANCE) ? nbt.method_25926(NBT_INSTANCE) : null;
    }

    private static int getSessionID(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_SESSION) ? nbt.method_10550(NBT_SESSION) : -1;
    }

    private static boolean isMarkedOn(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10577(NBT_ON);
    }

    @Nullable
    public static IPocketUpgrade getUpgrade(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null || !compound.method_10545(NBT_UPGRADE)) {
            return null;
        }
        return PocketUpgrades.instance().get(compound.method_10558(NBT_UPGRADE));
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null || !compound.method_10545(NBT_UPGRADE)) {
            return null;
        }
        IPocketUpgrade upgrade = PocketUpgrades.instance().get(compound.method_10558(NBT_UPGRADE));
        return upgrade == null ? null : UpgradeData.of(upgrade, NBTUtil.getCompoundOrEmpty(compound, NBT_UPGRADE_INFO));
    }

    public static void setUpgrade(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        class_2487 compound = stack.method_7948();
        if (upgrade == null) {
            compound.method_10551(NBT_UPGRADE);
            compound.method_10551(NBT_UPGRADE_INFO);
        } else {
            compound.method_10582(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            compound.method_10566(NBT_UPGRADE_INFO, (class_2520)upgrade.data().method_10553());
        }
    }

    public static class_2487 getUpgradeInfo(class_1799 stack) {
        return stack.method_7911(NBT_UPGRADE_INFO);
    }
}

