/*
 * Decompiled with CFR 0.152.
 */
package appeng.shaded.methvin.watcher.changeset;

import appeng.shaded.methvin.watcher.DirectoryChangeEvent;
import appeng.shaded.methvin.watcher.DirectoryChangeListener;
import appeng.shaded.methvin.watcher.changeset.ChangeSet;
import appeng.shaded.methvin.watcher.changeset.ChangeSetBuilder;
import appeng.shaded.methvin.watcher.changeset.ChangeSetEntry;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class ChangeSetListener
implements DirectoryChangeListener {
    private Map<Path, ChangeSetBuilder> changeBuilders = new HashMap<Path, ChangeSetBuilder>();
    private final Object lock = new Object(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(DirectoryChangeEvent directoryChangeEvent) {
        Path path = directoryChangeEvent.rootPath();
        Path path2 = directoryChangeEvent.path();
        Object object = this.lock;
        synchronized (object) {
            ChangeSetBuilder changeSetBuilder = this.changeBuilders.get(path);
            if (changeSetBuilder == null) {
                changeSetBuilder = new ChangeSetBuilder();
                this.changeBuilders.put(path, changeSetBuilder);
            }
            ChangeSetEntry changeSetEntry = new ChangeSetEntry(path2, directoryChangeEvent.isDirectory(), directoryChangeEvent.hash(), directoryChangeEvent.rootPath());
            switch (directoryChangeEvent.eventType()) {
                case CREATE: {
                    changeSetBuilder.addCreated(changeSetEntry);
                    break;
                }
                case MODIFY: {
                    changeSetBuilder.addModified(changeSetEntry);
                    break;
                }
                case DELETE: {
                    changeSetBuilder.addDeleted(changeSetEntry);
                    break;
                }
                case OVERFLOW: {
                    throw new IllegalStateException("OVERFLOW not yet handled");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Path, ChangeSet> getChangeSet() {
        Map<Path, ChangeSetBuilder> map;
        Object object = this.lock;
        synchronized (object) {
            map = this.changeBuilders;
            this.changeBuilders = new HashMap<Path, ChangeSetBuilder>();
        }
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (Path)entry.getKey(), entry -> ((ChangeSetBuilder)entry.getValue()).toChangeSet()));
    }
}

