/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.behaviors.ContainerItemContext;
import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.config.Actionable;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPortableCell
extends AEBasePoweredItem
implements ICellWorkbenchItem,
IMenuItem,
AEToolItem,
class_1768 {
    private final class_3917<?> menuType;
    private final int defaultColor;

    public AbstractPortableCell(class_3917<?> menuType, class_1792.class_1793 props, int defaultColor) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.menuType = menuType;
        this.defaultColor = defaultColor;
    }

    public abstract class_2960 getRecipeId();

    @Override
    public abstract double getChargeRate(class_1799 var1);

    public boolean openFromInventory(class_1657 player, int inventorySlot) {
        return this.openFromInventory(player, inventorySlot, false);
    }

    protected boolean openFromInventory(class_1657 player, int inventorySlot, boolean returningFromSubmenu) {
        class_1799 is = player.method_31548().method_5438(inventorySlot);
        if (is.method_7909() == this) {
            return MenuOpener.open(this.menuType, player, MenuLocators.forInventorySlot(inventorySlot), returningFromSubmenu);
        }
        return false;
    }

    @Override
    @Nullable
    public PortableCellMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, @Nullable class_2338 pos) {
        return new PortableCellMenuHost(player, inventorySlot, this, stack, (p, sm) -> this.openFromInventory((class_1657)p, inventorySlot, true));
    }

    public int method_7800(class_1799 stack) {
        class_2487 compoundTag = stack.method_7941("display");
        if (compoundTag != null && compoundTag.method_10573("color", 99)) {
            return compoundTag.method_10550("color");
        }
        return this.defaultColor;
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return context.method_8046() && this.disassembleDrive(stack, context.method_8045(), context.method_8036()) ? class_1269.method_29236((boolean)context.method_8045().method_8608()) : class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (!(InteractionUtil.isInAlternateUseMode(player) && this.disassembleDrive(player.method_5998(hand), level, player) || level.method_8608())) {
            MenuOpener.open(this.menuType, player, MenuLocators.forHand(player, hand));
        }
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)player.method_5998(hand));
    }

    private boolean disassembleDrive(class_1799 stack, class_1937 level, class_1657 player) {
        if (!AEConfig.instance().isPortableCellDisassemblyEnabled()) {
            return false;
        }
        class_1860 recipe = level.method_8433().method_8130(this.getRecipeId()).orElse(null);
        if (!(recipe instanceof class_3955)) {
            AELog.debug("Cannot disassemble portable cell because it's crafting recipe doesn't exist: %s", this.getRecipeId());
            return false;
        }
        class_3955 craftingRecipe = (class_3955)recipe;
        if (level.method_8608()) {
            return true;
        }
        class_1661 playerInventory = player.method_31548();
        if (playerInventory.method_7391() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        if (inv.getAvailableStacks().isEmpty()) {
            playerInventory.method_5447(playerInventory.field_7545, class_1799.field_8037);
            double remainingEnergy = this.getAECurrentPower(stack);
            for (class_1856 ingredient : craftingRecipe.method_8117()) {
                class_1792 class_17922;
                class_1799 ingredientStack = ingredient.method_8105()[0].method_7972();
                if (remainingEnergy > 0.0 && (class_17922 = ingredientStack.method_7909()) instanceof EnergyCellBlockItem) {
                    EnergyCellBlockItem energyCell = (EnergyCellBlockItem)class_17922;
                    remainingEnergy = energyCell.injectAEPower(ingredientStack, remainingEnergy, Actionable.MODULATE);
                }
                playerInventory.method_7398(ingredientStack);
            }
            for (class_1799 upgrade : this.getUpgrades(stack)) {
                playerInventory.method_7398(upgrade);
            }
        } else {
            player.method_7353((class_2561)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
        }
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    public void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + Upgrades.getEnergyCardMultiplier(upgrades) * 8);
    }

    public long insert(class_1657 player, class_1799 stack, AEKey what, @Nullable AEKeyType allowed, long amount, Actionable mode) {
        if (allowed != null && allowed.tryCast(what) == null) {
            return 0L;
        }
        PortableCellMenuHost host = this.getMenuHost(player, -1, stack, null);
        if (host == null) {
            return 0L;
        }
        MEStorage inv = host.getInventory();
        if (inv != null) {
            return StorageHelper.poweredInsert(host, inv, what, amount, new PlayerSource(player), mode);
        }
        return 0L;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        class_1799 other = slot.method_7677();
        if (other.method_7960()) {
            return true;
        }
        this.tryInsertFromPlayerOwnedItem(player, stack, other);
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (other.method_7960()) {
            return false;
        }
        this.tryInsertFromPlayerOwnedItem(player, stack, other);
        return true;
    }

    protected boolean tryInsertFromPlayerOwnedItem(class_1657 player, class_1799 cellStack, class_1799 otherStack) {
        for (AEKeyType keyType : ContainerItemStrategies.getSupportedKeyTypes()) {
            if (!this.tryInsertFromPlayerOwnedItem(player, cellStack, otherStack, keyType)) continue;
            return true;
        }
        AEItemKey key = AEItemKey.of(otherStack);
        int inserted = (int)this.insert(player, cellStack, key, AEKeyType.items(), otherStack.method_7947(), Actionable.MODULATE);
        if (inserted > 0) {
            otherStack.method_7934(inserted);
            return true;
        }
        return false;
    }

    protected boolean tryInsertFromPlayerOwnedItem(class_1657 player, class_1799 cellStack, class_1799 otherStack, AEKeyType keyType) {
        long extracted;
        GenericStack containedStack;
        ContainerItemContext context = ContainerItemStrategies.findOwnedItemContext(keyType, player, otherStack);
        if (context != null && (containedStack = context.getExtractableContent()) != null && this.insert(player, cellStack, containedStack.what(), keyType, containedStack.amount(), Actionable.SIMULATE) == containedStack.amount() && (extracted = context.extract(containedStack.what(), containedStack.amount(), Actionable.MODULATE)) > 0L) {
            this.insert(player, cellStack, containedStack.what(), keyType, extracted, Actionable.MODULATE);
            context.playEmptySound(player, containedStack.what());
            return true;
        }
        return false;
    }

    public static int getColor(class_1799 stack, int tintIndex) {
        class_1792 class_17922;
        if (tintIndex == 1 && (class_17922 = stack.method_7909()) instanceof AbstractPortableCell) {
            AbstractPortableCell portableCell = (AbstractPortableCell)class_17922;
            if (portableCell.getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            StorageCell cellInv = StorageCells.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        if (tintIndex == 2 && (class_17922 = stack.method_7909()) instanceof AbstractPortableCell) {
            AbstractPortableCell portableCell = (AbstractPortableCell)class_17922;
            return portableCell.method_7800(stack);
        }
        return 0xFFFFFF;
    }
}

