/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IResizableWidget;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AETextField
extends class_342
implements IResizableWidget,
ITooltip {
    private static final Blitter BLITTER = Blitter.texture("guis/text_field.png", 128, 128);
    private static final int PADDING = 2;
    private final int fontPad;
    private final ScreenStyle style;
    private int selectionColor;
    private List<class_2561> tooltipMessage = Collections.emptyList();
    @Nullable
    private class_2561 placeholder;

    public AETextField(ScreenStyle style, class_327 fontRenderer, int xPos, int yPos, int width, int height) {
        super(fontRenderer, xPos + 2, yPos + 2, width - 4 - fontRenderer.method_1727("_"), height - 4, (class_2561)class_2561.method_43473());
        this.style = style;
        this.fontPad = fontRenderer.method_1727("_");
        this.setSelectionColor(style.getColor(PaletteColor.TEXTFIELD_SELECTION).toARGB());
        this.method_1868(style.getColor(PaletteColor.TEXTFIELD_TEXT).toARGB());
    }

    public boolean method_25405(double mouseX, double mouseY) {
        VisualBounds bounds = this.getVisualBounds();
        return mouseX >= (double)bounds.left && mouseX < (double)bounds.right && mouseY >= (double)bounds.top && mouseY < (double)bounds.bottom;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            mouseX = class_3532.method_15350((double)mouseX, (double)this.method_46426(), (double)(this.method_46426() + this.field_22758 - 1));
            mouseY = class_3532.method_15350((double)mouseY, (double)this.method_46427(), (double)(this.method_46427() + this.field_22759 - 1));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.method_25370() && this.method_20315() && keyCode != 258 && keyCode != 256;
    }

    @Override
    public void move(Point pos) {
        super.method_46421(pos.getX() + 2);
        this.method_46419(pos.getY() + 2);
    }

    @Override
    public void resize(int width, int height) {
        super.method_25358(width - 4 - this.fontPad);
        this.field_22759 = height - 4;
    }

    public void selectAll() {
        this.method_1883(0);
        this.method_1884(this.method_1861());
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.method_1885()) {
            int yOffset = 0;
            if (!this.method_20316()) {
                yOffset = 12;
            } else if (this.method_25370()) {
                yOffset = 24;
            }
            VisualBounds bounds = this.getVisualBounds();
            BLITTER.src(0, yOffset, 1, 12).dest(bounds.left, bounds.top).blit(guiGraphics);
            int backgroundWidth = Math.min(126, bounds.right - bounds.left - 2);
            BLITTER.src(1, yOffset, backgroundWidth, 12).dest(bounds.left + 1, bounds.top).blit(guiGraphics);
            BLITTER.src(127, yOffset, 1, 12).dest(bounds.right - 1, bounds.top).blit(guiGraphics);
            super.method_48579(guiGraphics, mouseX, mouseY, partial);
            if (this.placeholder != null && !this.method_25370() && this.method_1882().isEmpty()) {
                class_327 font = class_310.method_1551().field_1772;
                guiGraphics.method_51439(font, this.placeholder, this.method_46426(), this.method_46427(), this.style.getColor(PaletteColor.TEXTFIELD_PLACEHOLDER).toARGB(), false);
            }
        }
    }

    public void method_1886(class_332 guiGraphics, int startX, int startY, int endX, int endY) {
        if (!this.method_25370()) {
            return;
        }
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        ++startX;
        --endX;
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        endX = class_3532.method_15340((int)endX, (int)this.method_46426(), (int)(this.method_46426() + this.field_22758));
        startX = class_3532.method_15340((int)startX, (int)this.method_46426(), (int)(this.method_46426() + this.field_22758));
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        guiGraphics.method_25294(startX, startY -= 2, endX, endY, this.selectionColor);
        RenderSystem.disableColorLogicOp();
    }

    @Override
    public class_768 getTooltipArea() {
        return new class_768(this.method_46426() - 2, this.method_46427() - 2, this.field_22758 + 4 + this.fontPad, this.field_22759 + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.field_22764;
    }

    @Override
    @NotNull
    public List<class_2561> getTooltipMessage() {
        return this.tooltipMessage;
    }

    public void setTooltipMessage(List<class_2561> tooltipMessage) {
        this.tooltipMessage = Objects.requireNonNull(tooltipMessage);
    }

    private VisualBounds getVisualBounds() {
        int left = this.method_46426() - 2;
        int top = this.method_46427() - 2;
        int right = left + this.field_22758 + 4 + this.fontPad;
        return new VisualBounds(left, top, right, top + this.field_22759 + 4);
    }

    public void setPlaceholder(class_2561 placeholder) {
        this.placeholder = placeholder;
    }

    public class_2561 getPlaceholder() {
        return this.placeholder;
    }

    private record VisualBounds(int left, int top, int right, int bottom) {
    }
}

