/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CompatCore;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.Receiving;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioSource;
import com.codinglitch.simpleradio.radio.effects.AudioEffect;
import com.codinglitch.simpleradio.radio.effects.BaseAudioEffect;
import de.maxhenkel.voicechat.api.Entity;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class RadioChannel
implements Supplier<short[]> {
    public UUID owner;
    public WorldlyPosition location;
    public AudioChannel audioChannel;
    public AudioPlayer audioPlayer;
    private final Map<UUID, List<short[]>> packetBuffer;
    private final Map<UUID, OpusDecoder> decoders;
    private final AudioEffect effect;
    private final Frequency frequency;
    public boolean isValid = true;

    public RadioChannel(class_1657 owner, Frequency frequency) {
        this(owner.method_5667(), frequency);
    }

    public RadioChannel(UUID owner, Frequency frequency) {
        this.owner = owner;
        this.frequency = frequency;
        this.packetBuffer = new HashMap<UUID, List<short[]>>();
        this.decoders = new HashMap<UUID, OpusDecoder>();
        this.effect = new BaseAudioEffect();
    }

    @Override
    public short[] get() {
        short[] audio = this.generatePacket();
        if (audio == null) {
            if (this.audioPlayer != null) {
                this.audioPlayer.stopPlaying();
            }
            this.audioPlayer = null;
            return null;
        }
        return audio;
    }

    public short[] generatePacket() {
        ArrayList<short[]> packetsToCombine = new ArrayList<short[]>();
        for (Map.Entry<UUID, List<short[]>> packets : this.packetBuffer.entrySet()) {
            if (packets.getValue().isEmpty()) continue;
            short[] audio = packets.getValue().remove(0);
            packetsToCombine.add(audio);
        }
        this.packetBuffer.values().removeIf(List::isEmpty);
        if (packetsToCombine.isEmpty()) {
            return null;
        }
        short[] combinedAudio = CommonRadioPlugin.combineAudio(packetsToCombine);
        return this.effect.apply(combinedAudio);
    }

    public void updateLocation(WorldlyPosition location) {
        AudioChannel audioChannel = this.audioChannel;
        if (audioChannel instanceof LocationalAudioChannel) {
            LocationalAudioChannel locationalAudioChannel = (LocationalAudioChannel)audioChannel;
            locationalAudioChannel.updateLocation(CommonRadioPlugin.serverApi.createPosition((double)location.x, (double)location.y, (double)location.z));
        }
    }

    public void serverTick(int tickCount) {
        if (this.location != null) {
            Services.COMPAT.modifyPosition(this.location);
            this.updateLocation(this.location);
        }
    }

    public void transmit(RadioSource source, Frequency frequency) {
        class_3218 level = null;
        Vector3f position = null;
        if (this.location != null) {
            level = (class_3218)this.location.level;
            position = this.location.position();
        } else {
            class_3222 player;
            VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(this.owner);
            if (connection != null && (player = (class_3222)connection.getPlayer().getPlayer()) != null) {
                level = player.method_51469();
                position = player.method_19538().method_46409();
            }
        }
        if (level == null || position == null) {
            return;
        }
        if (!SimpleRadioLibrary.SERVER_CONFIG.frequency.crossDimensional.booleanValue() && level != source.location.level) {
            return;
        }
        this.effect.severity = source.computeSeverity(WorldlyPosition.of(position, (class_1937)level), frequency);
        this.effect.volume = source.volume;
        if (this.effect.severity >= 100.0f) {
            return;
        }
        List microphonePackets = this.packetBuffer.computeIfAbsent(source.owner, k -> new ArrayList());
        if (microphonePackets.isEmpty()) {
            for (int i = 0; i < SimpleRadioLibrary.SERVER_CONFIG.frequency.packetBuffer; ++i) {
                microphonePackets.add(null);
            }
        }
        byte[] data = source.data;
        OpusDecoder decoder = this.getDecoder(source.owner);
        if (data == null || data.length == 0) {
            decoder.resetState();
            return;
        }
        short[] decoded = decoder.decode(data);
        microphonePackets.add(decoded);
        Services.COMPAT.onData(this, source, decoded);
        CompatCore.onData(this, source, decoded);
        if (this.audioPlayer == null) {
            this.getAudioPlayer().startPlaying();
        }
    }

    public boolean validate() {
        VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(this.owner);
        if (connection == null) {
            if (this.location == null || !Receiving.validateReceiver(this.location, this.frequency)) {
                this.invalidate();
                return false;
            }
        } else if (!Receiving.validateReceiver(connection, this.frequency)) {
            this.invalidate();
            return false;
        }
        return true;
    }

    public void invalidate() {
        if (this.audioPlayer != null) {
            this.audioPlayer.stopPlaying();
        }
        this.isValid = false;
    }

    public OpusDecoder getDecoder(UUID sender) {
        return this.decoders.computeIfAbsent(sender, uuid -> CommonRadioPlugin.serverApi.createDecoder());
    }

    private AudioPlayer getAudioPlayer() {
        if (this.audioPlayer == null) {
            VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(this.owner);
            if (connection == null) {
                LocationalAudioChannel locationalChannel = CommonRadioPlugin.serverApi.createLocationalAudioChannel(this.owner, CommonRadioPlugin.serverApi.fromServerLevel((Object)this.location.level), CommonRadioPlugin.serverApi.createPosition((double)this.location.x + 0.5, (double)this.location.y + 0.5, (double)this.location.z + 0.5));
                locationalChannel.setDistance((float)SimpleRadioLibrary.SERVER_CONFIG.radio.range.intValue());
                locationalChannel.setCategory(CommonRadioPlugin.RADIOS_CATEGORY);
                this.audioChannel = locationalChannel;
            } else {
                this.audioChannel = CommonRadioPlugin.serverApi.createEntityAudioChannel(this.owner, (Entity)connection.getPlayer());
                this.audioChannel.setCategory(CommonRadioPlugin.TRANSCEIVERS_CATEGORY);
            }
            this.audioPlayer = CommonRadioPlugin.serverApi.createAudioPlayer(this.audioChannel, CommonRadioPlugin.serverApi.createEncoder(), (Supplier)this);
        }
        return this.audioPlayer;
    }
}

