/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.items;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.Receiving;
import com.codinglitch.simpleradio.core.central.Transmitting;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRadioPacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.items.WalkieTalkieItem;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class TransceiverItem
extends class_1792
implements Receiving,
Transmitting {
    public TransceiverItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private void transmit(class_3222 player, boolean started) {
        Services.NETWORKING.sendToPlayer(player, new ClientboundRadioPacket(started, player.method_5667(), this.getClass().getName()));
    }

    private void startTransceiving(class_1937 level, class_1799 stack, String frequencyName, String modulation, UUID owner) {
        this.startReceiving(frequencyName, Frequency.modulationOf(modulation), owner);
        class_1657 player = level.method_18470(owner);
        RadioListener listener = this.startListening((class_1297)player);
        listener.range = 4.0f;
        listener.acceptor(source -> {
            class_1799 using = player.method_6030();
            class_2487 usingTag = using.method_7948();
            if (!usingTag.method_10545("frequency") || !usingTag.method_10545("modulation")) {
                return;
            }
            if (!usingTag.method_10558("frequency").equals(frequencyName) || !usingTag.method_10558("modulation").equals(modulation)) {
                return;
            }
            if (this.getClass() == TransceiverItem.class) {
                source.type = RadioSource.Type.TRANSCEIVER;
            } else if (this.getClass() == WalkieTalkieItem.class) {
                source.type = RadioSource.Type.WALKIE_TALKIE;
            }
            Frequency frequency = this.getFrequency(stack);
            if (frequency != null) {
                RadioManager.transmit(source, frequency);
            }
        });
    }

    private void stopTransceiving(class_1937 level, String frequencyName, String modulation, UUID owner) {
        this.stopReceiving(frequencyName, Frequency.modulationOf(modulation), owner);
        class_1657 entity = level.method_18470(owner);
        this.stopListening((class_1297)entity);
    }

    public int getCooldown() {
        return 20;
    }

    public void method_7860(class_2487 tag) {
        super.method_7860(tag);
        if (tag.method_10545("user")) {
            tag.method_10551("user");
        }
    }

    public void method_33261(class_1542 itemEntity) {
        super.method_33261(itemEntity);
        class_2487 tag = itemEntity.method_6983().method_7948();
        if (tag.method_10545("frequency") && tag.method_10545("modulation") && tag.method_10545("user")) {
            this.stopTransceiving(itemEntity.method_37908(), tag.method_10558("frequency"), tag.method_10558("modulation"), tag.method_25926("user"));
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean b) {
        super.method_7888(stack, level, entity, slot, b);
        class_2487 tag = stack.method_7948();
        String frequency = tag.method_10558("frequency");
        String modulation = tag.method_10558("modulation");
        this.tick(stack, level);
        if (frequency.isEmpty() || modulation.isEmpty()) {
            return;
        }
        if (!Frequency.check(frequency)) {
            CommonSimpleRadio.info("Invalid frequency {}, replacing with default", frequency);
            frequency = this.getDefaultFrequency();
            tag.method_10582("frequency", frequency);
        }
        UUID uuid = entity.method_5667();
        if (tag.method_10545("user")) {
            UUID currentUUID = tag.method_25926("user");
            if (currentUUID.equals(uuid)) {
                if (this.validate(frequency, Frequency.modulationOf(modulation), currentUUID)) {
                    return;
                }
            } else if (!level.field_9236) {
                this.stopTransceiving(level, frequency, modulation, currentUUID);
            }
        }
        frequency = tag.method_10558("frequency");
        modulation = tag.method_10558("modulation");
        if (!level.field_9236) {
            this.startTransceiving(level, stack, frequency, modulation, uuid);
        }
        tag.method_25927("user", uuid);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 tooltip) {
        this.appendTooltip(stack, components);
        super.method_7851(stack, level, components, tooltip);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        level.method_8396(player, player.method_24515(), SimpleRadioSounds.RADIO_OPEN, class_3419.field_15248, 1.0f, 1.0f);
        player.method_6019(hand);
        if (!level.field_9236) {
            this.transmit((class_3222)player, true);
        }
        return class_1271.method_22428((Object)stack);
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            level.method_8396(player, user.method_24515(), SimpleRadioSounds.RADIO_CLOSE, class_3419.field_15248, 1.0f, 1.0f);
            if (!level.field_9236) {
                this.transmit((class_3222)player, false);
            }
            player.method_7357().method_7906((class_1792)this, this.getCooldown());
        }
        super.method_7840(stack, level, user, remainingUseTicks);
    }
}

