/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.FrequencyBlockEntity;
import com.codinglitch.simpleradio.core.central.Transmitting;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class MicrophoneBlockEntity
extends FrequencyBlockEntity
implements Transmitting {
    public boolean isListening = false;
    public UUID listenerID = UUID.randomUUID();
    private RadioListener listener;

    public MicrophoneBlockEntity(class_2338 pos, class_2680 state) {
        super(SimpleRadioBlockEntities.MICROPHONE, pos, state);
    }

    public void method_11012() {
        if (this.field_11863 != null && !this.field_11863.field_9236 && this.listener != null) {
            this.field_11863.method_43128(null, (double)this.listener.location.x, (double)this.listener.location.y, (double)this.listener.location.z, SimpleRadioSounds.RADIO_CLOSE, class_3419.field_15248, 1.0f, 1.0f);
        }
        if (this.frequency != null) {
            this.stopListening(WorldlyPosition.of(this.method_11016(), this.field_11863));
        }
        super.method_11012();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadTag(tag);
    }

    public void method_11007(class_2487 tag) {
        this.saveTag(tag);
        super.method_11007(tag);
    }

    public void method_38240(class_1799 stack) {
        this.saveTag(stack.method_7948());
        super.method_38240(stack);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, MicrophoneBlockEntity blockEntity) {
        if (!level.field_9236 && blockEntity.frequency != null && !blockEntity.isListening) {
            blockEntity.listen();
        }
    }

    public void listen() {
        this.listener = this.startListening(Services.COMPAT.modifyPosition(WorldlyPosition.of(this.field_11867, this.field_11863, this.field_11867)));
        this.listener.range = 12.0f;
        this.listener.acceptor(source -> {
            source.type = RadioSource.Type.TRANSMITTER;
            source.delegate(this.listenerID);
            Frequency frequency = this.getFrequency(this);
            if (frequency != null) {
                RadioManager.transmit(source, frequency);
            }
        });
        this.frequency.tryAddTransmitter(this.listener);
        this.field_11863.method_43128(null, (double)this.listener.location.x, (double)this.listener.location.y, (double)this.listener.location.z, SimpleRadioSounds.RADIO_OPEN, class_3419.field_15248, 1.0f, 1.0f);
        this.isListening = true;
    }

    public void loadFromItem(class_1799 stack) {
        this.loadTag(stack.method_7948());
    }

    public void loadTag(class_2487 tag) {
        if (this.frequency != null) {
            this.stopListening(WorldlyPosition.of(this.method_11016(), this.field_11863));
            this.isListening = false;
        }
        String frequencyName = tag.method_10558("frequency");
        Frequency.Modulation modulation = Frequency.modulationOf(tag.method_10558("modulation"));
        this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
    }

    public void saveTag(class_2487 tag) {
        if (this.frequency == null) {
            return;
        }
        tag.method_10582("frequency", this.frequency.frequency);
        tag.method_10582("modulation", this.frequency.modulation.shorthand);
    }
}

