/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.central.ItemHolder;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRadioPacket;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRadioUpdatePacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.util.TriConsumer;

public class FabricLoader {
    private static final class_2960 ITEMS_ENABLED = CommonSimpleRadio.id("items_enabled");

    public static void loadItems() {
        SimpleRadioItems.ITEMS.forEach((location, item) -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)location, (Object)item.get()));
    }

    public static void loadBlocks() {
        SimpleRadioBlocks.BLOCKS.forEach((location, block) -> class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)location, (Object)block));
    }

    public static void loadPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ServerboundRadioUpdatePacket.ID, (ServerPlayNetworking.PlayChannelHandler)FabricLoader.serverbound(ServerboundRadioUpdatePacket::decode, ServerboundRadioUpdatePacket::handle));
    }

    public static void loadClientPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ClientboundRadioPacket.ID, (ClientPlayNetworking.PlayChannelHandler)FabricLoader.clientbound(ClientboundRadioPacket::decode, ClientboundRadioPacket::handle));
    }

    public static <P> ServerPlayNetworking.PlayChannelHandler serverbound(Function<class_2540, P> decoder, TriConsumer<P, MinecraftServer, class_3222> consumer) {
        return (server, player, _handler, buf, _responseSender) -> consumer.accept(decoder.apply(buf), (Object)server, (Object)player);
    }

    public static <P> ClientPlayNetworking.PlayChannelHandler clientbound(Function<class_2540, P> decoder, Consumer<P> consumer) {
        return (client, listener, buffer, sender) -> consumer.accept(decoder.apply(buffer));
    }

    public static ConditionJsonProvider itemsEnabled(final String ... items) {
        return new ConditionJsonProvider(){

            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (String item : items) {
                    array.add(item);
                }
                object.add("values", (JsonElement)array);
            }

            public class_2960 getConditionId() {
                return ITEMS_ENABLED;
            }
        };
    }

    public static void load() {
        FabricLoader.loadItems();
        FabricLoader.loadBlocks();
        FabricLoader.loadPackets();
        SimpleRadioBlockEntities.load();
        SimpleRadioMenus.load();
    }

    static {
        ResourceConditions.register((class_2960)ITEMS_ENABLED, object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            for (JsonElement element : array) {
                if (element.isJsonPrimitive()) {
                    ItemHolder<class_1792> holder = SimpleRadioItems.getByName(element.getAsString());
                    if (holder == null) continue;
                    return holder.enabled;
                }
                throw new JsonParseException("Invalid item entry: " + element);
            }
            return true;
        });
    }
}

