/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.compat;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioSource;
import de.maxhenkel.vcinteraction.AudioUtils;
import de.maxhenkel.vcinteraction.VoicechatInteraction;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5712;

public class InteractionCompat {
    private static ConcurrentHashMap<UUID, Long> cooldowns = new ConcurrentHashMap();

    public static void onData(RadioChannel channel, RadioSource source, short[] decodedData) {
        UUID sourceOwner = source.getRealOwner();
        VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(sourceOwner);
        if (AudioUtils.calculateAudioLevel((short[])decodedData) < ((Integer)VoicechatInteraction.SERVER_CONFIG.minActivationThreshold.get()).doubleValue()) {
            return;
        }
        if (connection == null) {
            if (channel.location == null) {
                return;
            }
            WorldlyPosition location = channel.location;
            location.level.method_8503().execute(() -> {
                if (InteractionCompat.setCooldown(channel.owner, location.level)) {
                    class_2680 state = location.level.method_8320(location.blockPos());
                    location.level.method_43276(VoicechatInteraction.VOICE_GAME_EVENT, location.blockPos(), class_5712.class_7397.method_43287((class_2680)state));
                }
            });
        } else {
            Object object = connection.getPlayer().getPlayer();
            if (!(object instanceof class_3222)) {
                CommonSimpleRadio.warn("Received microphone packets from non-player", new Object[0]);
                return;
            }
            class_3222 player = (class_3222)object;
            if (InteractionCompat.setCooldown(player.method_5667(), player.method_37908())) {
                player.method_32876(VoicechatInteraction.VOICE_GAME_EVENT);
            }
        }
    }

    private static boolean setCooldown(UUID uuid, class_1937 level) {
        Long lastTimestamp = cooldowns.get(uuid);
        long currentTime = level.method_8510();
        if (lastTimestamp == null || currentTime - lastTimestamp > 20L) {
            cooldowns.put(uuid, currentTime);
            return true;
        }
        return false;
    }
}

