/*
 * Decompiled with CFR 0.152.
 */
package net.mysticdrew.journeymapteams.handlers.properties;

import journeymap.client.api.option.BooleanOption;
import journeymap.client.api.option.EnumOption;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.api.option.OptionCategory;
import net.mysticdrew.journeymapteams.handlers.properties.Color;
import net.mysticdrew.journeymapteams.handlers.properties.Properties;

public class DefaultHandlerProperties
implements Properties {
    private final OptionCategory category;
    private final EnumOption<Color> teamColor;
    private final EnumOption<Color> allyColor;
    private final BooleanOption forceAllyColor;
    private final BooleanOption forceTeamColor;
    private final BooleanOption showIconColor;
    private final BooleanOption showNameColor;

    public DefaultHandlerProperties(String token, String labelKey) {
        this.category = new OptionCategory("journeymapteams-" + token, labelKey);
        this.teamColor = new EnumOption(this.category, "team-color", "prop.option.label.team_color", (KeyedEnum)Color.GREEN);
        this.allyColor = new EnumOption(this.category, "ally-color", "prop.option.label.ally_color", (KeyedEnum)Color.BLUE);
        this.forceAllyColor = new BooleanOption(this.category, "force-ally-color", "prop.option.label.force_ally", Boolean.valueOf(false));
        this.forceTeamColor = new BooleanOption(this.category, "force-team-color", "prop.option.label.force_team", Boolean.valueOf(false));
        this.showIconColor = new BooleanOption(this.category, "show-icon-color", "prop.option.label.show_icon_color", Boolean.valueOf(true));
        this.showNameColor = new BooleanOption(this.category, "show-name-color", "prop.option.label.show_name_color", Boolean.valueOf(true));
    }

    @Override
    public int getTeamColor() {
        return ((Color)((Object)this.teamColor.get())).getColor();
    }

    @Override
    public int getAllyColor() {
        return ((Color)((Object)this.allyColor.get())).getColor();
    }

    @Override
    public boolean getForceAllyColor() {
        return (Boolean)this.forceAllyColor.get();
    }

    @Override
    public boolean getForceTeamColor() {
        return (Boolean)this.forceTeamColor.get();
    }

    @Override
    public boolean getShowIconColor() {
        return (Boolean)this.showIconColor.get();
    }

    @Override
    public boolean getShowNameColor() {
        return (Boolean)this.showNameColor.get();
    }
}

