/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ShapeListImpl
extends ObjectSelectionList<Entry>
implements IShapeList {
    private Runnable update;

    public ShapeListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, Runnable update) {
        super(minecraft, right - left, bottom - top, top, slotHeight);
        this.m_252865_(left);
        this.m_93488_(false);
        this.update = update;
        for (int shapeSetId = 0; shapeSetId < BuildGuide.stateManager.getState().shapeSets.size(); ++shapeSetId) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeSetId));
            if (shapeSetId != BuildGuide.stateManager.getState().iShapeSet) continue;
            this.setSelected((Entry)this.m_6702_().get(this.m_6702_().size() - 1));
        }
    }

    @Override
    public void setYPosition(int y) {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void addEntry(int shapeSetId) {
        this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeSetId));
        this.setSelected((Entry)this.m_6702_().get(shapeSetId));
    }

    public boolean removeEntry(Entry entry) {
        for (Entry e : this.m_6702_()) {
            if (e.getShapeSetId() <= entry.getShapeSetId()) continue;
            e.setShapeSetId(e.getShapeSetId() - 1);
        }
        if (this.m_6702_().size() > entry.getShapeSetId() + 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeSetId() + 1));
        } else if (this.m_6702_().size() > 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeSetId() - 1));
        }
        return super.m_93502_((AbstractSelectionList.Entry)entry);
    }

    @Override
    public boolean removeEntry(IShapeList.IEntry entry) {
        return this.removeEntry((Entry)entry);
    }

    public void setSelected(@Nullable Entry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            BuildGuide.stateManager.getState().iShapeSet = entry.getShapeSetId();
        }
        this.update.run();
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_307439_(), this.m_306468_(), 0x33000000);
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_240140_(GuiGraphics guiGraphics, int top, int width, int height, int colourOuter, int colourInner) {
        int left = this.m_252754_() + (this.f_93618_ - width) / 2;
        int right = this.m_252754_() + (this.f_93618_ + width) / 2;
        this.boundedFill(guiGraphics, left, top - 2, right, top + height + 2, this.m_252754_(), this.m_252907_(), this.m_307439_(), this.m_306468_(), colourOuter);
        this.boundedFill(guiGraphics, left + 1, top - 1, right - 1, top + height + 1, this.m_252754_(), this.m_252907_(), this.m_307439_(), this.m_306468_(), colourInner);
    }

    private void boundedFill(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int boundLeft, int boundTop, int boundRight, int boundBottom, int colour) {
        if (left < boundRight && top < boundBottom && right > boundLeft && bottom > boundTop) {
            guiGraphics.m_280509_(Math.max(left, boundLeft), Math.max(top, boundTop), Math.min(right, boundRight), Math.min(bottom, boundBottom), colour);
        }
    }

    public int m_5759_() {
        return this.f_93618_ - 12;
    }

    protected int m_5756_() {
        return this.m_307439_() - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements IShapeList.IEntry {
        private int shapeSetId;

        public Entry(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, BuildGuide.screenHandler.getFormattedShapeName(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId)), x + 5, y + 4, BuildGuide.screenHandler.getShapeProgressColour(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId).getShape()), true);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ShapeListImpl.this.setSelected(this);
            return false;
        }

        @Override
        public void setShapeSetId(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        @Override
        public int getShapeSetId() {
            return this.shapeSetId;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"");
        }
    }
}

