/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyMinimumInt;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapePolygon
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private String[] rotationNames = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
    private static final int[] rotXX = new int[]{1, 0, -1, 0};
    private static final int[] rotXY = new int[]{0, -1, 0, 1};
    private static final int[] rotYX = new int[]{0, 1, 0, -1};
    private PropertyMinimumInt propertySides = new PropertyMinimumInt(3, BuildGuide.screenHandler.translate("property.buildguide.sides"), () -> this.update(), 3);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.radius"), () -> this.update());
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyEnum<rotation> propertyRot = new PropertyEnum<rotation>(rotation.ROT0, BuildGuide.screenHandler.translate("property.buildguide.rotation"), () -> this.update(), this.rotationNames);
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, BuildGuide.screenHandler.translate("property.buildguide.depth"), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapePolygon() {
        this.properties.add(this.propertySides);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRot);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int n = (Integer)this.propertySides.value;
        float r = ((Float)this.propertyRadius.value).floatValue();
        int rot = ((rotation)((Object)this.propertyRot.value)).ordinal();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.setOriginOffset(0.0, offset, offset);
                break;
            }
            case Y: {
                this.setOriginOffset(offset, 0.0, offset);
                break;
            }
            case Z: {
                this.setOriginOffset(offset, offset, 0.0);
            }
        }
        for (int i = 0; i < n; ++i) {
            int minB = (int)Math.floor(Math.min((double)r * (-Math.cos(Math.PI * 2 * (double)i / (double)n) - Math.tan(Math.PI / (double)n) * Math.sin(Math.PI * 2 * (double)i / (double)n)), (double)r * (-Math.cos(Math.PI * 2 * (double)i / (double)n) + Math.tan(Math.PI / (double)n) * Math.sin(Math.PI * 2 * (double)i / (double)n))) + offset);
            int maxA = (int)Math.ceil(Math.max((double)r * (Math.sin(Math.PI * 2 * (double)i / (double)n) - Math.tan(Math.PI / (double)n) * Math.cos(Math.PI * 2 * (double)i / (double)n)), (double)r * (Math.sin(Math.PI * 2 * (double)i / (double)n) + Math.tan(Math.PI / (double)n) * Math.cos(Math.PI * 2 * (double)i / (double)n))) + offset);
            int maxB = (int)Math.ceil(Math.max((double)r * (-Math.cos(Math.PI * 2 * (double)i / (double)n) - Math.tan(Math.PI / (double)n) * Math.sin(Math.PI * 2 * (double)i / (double)n)), (double)r * (-Math.cos(Math.PI * 2 * (double)i / (double)n) + Math.tan(Math.PI / (double)n) * Math.sin(Math.PI * 2 * (double)i / (double)n))) + offset);
            for (int a = 0; a <= maxA; ++a) {
                for (int b = minB; b <= maxB; ++b) {
                    double theta = Math.atan2((double)b - offset, (double)a - offset) + 1.5707963267948966;
                    double dr = ((double)a - offset) * Math.sin(Math.PI * 2 * (double)i / (double)n) - ((double)b - offset) * Math.cos(Math.PI * 2 * (double)i / (double)n) - (double)r;
                    if (theta < 0.0 && i > 0) {
                        theta += Math.PI * 2;
                    }
                    if (!(dr >= -0.5) || !(dr < 0.5) || !(theta >= (double)(2 * i - 1) * Math.PI / (double)n) || !(theta < (double)(2 * i + 1) * Math.PI / (double)n)) continue;
                    block13: for (int h = (Integer)this.propertyDepth.value > 0 ? 0 : (Integer)this.propertyDepth.value + 1; h < ((Integer)this.propertyDepth.value > 0 ? (Integer)this.propertyDepth.value : 1); ++h) {
                        switch ((direction)((Object)this.propertyDir.value)) {
                            case X: {
                                this.addShapeCube(buffer, h, b * rotXX[rot] + a * rotYX[rot], a * rotXX[rot] + b * rotXY[rot]);
                                if (a == 0) continue block13;
                                this.addShapeCube(buffer, h, b * rotXX[rot] - a * rotYX[rot], -a * rotXX[rot] + b * rotXY[rot]);
                                continue block13;
                            }
                            case Y: {
                                this.addShapeCube(buffer, b * rotXX[rot] + a * rotYX[rot], h, a * rotXX[rot] + b * rotXY[rot]);
                                if (a == 0) continue block13;
                                this.addShapeCube(buffer, b * rotXX[rot] - a * rotYX[rot], h, -a * rotXX[rot] + b * rotXY[rot]);
                                continue block13;
                            }
                            case Z: {
                                this.addShapeCube(buffer, a * rotXX[rot] + b * rotXY[rot], b * rotXX[rot] + a * rotYX[rot], h);
                                if (a == 0) continue block13;
                                this.addShapeCube(buffer, -a * rotXX[rot] + b * rotXY[rot], b * rotXX[rot] - a * rotYX[rot], h);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.polygon";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }

    private static enum rotation {
        ROT0,
        ROT90,
        ROT180,
        ROT270;

    }
}

